/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Interface Declarations                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace wasmssa {
/// Operation that defines one level of nesting for Wasm branching.
/// 
///     These ops defines Wasm control flow nesting levels (Wasm Labels) that Wasm
///     branching operations can target.
///     The branching operations specify a number of nesting level they want to exit,
///     and are redirected to the target of the corresponding nesting LabelLevelOp.
/// 
///     As multiple level can be escaped at once, the level defining ops need themselves
///     to be `Terminator` ops.
class LabelLevelOpInterface;
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
/// Wasm operation that targets a label for a jump.
class LabelBranchingOpInterface;
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
/// Operation that imports a symbol from an external Wasm module;
class ImportOpInterface;
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
/// Operation that defines one level of nesting for Wasm branching.
/// 
///     These ops defines Wasm control flow nesting levels (Wasm Labels) that Wasm
///     branching operations can target.
///     The branching operations specify a number of nesting level they want to exit,
///     and are redirected to the target of the corresponding nesting LabelLevelOp.
/// 
///     As multiple level can be escaped at once, the level defining ops need themselves
///     to be `Terminator` ops.
namespace detail {
struct LabelLevelOpInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    ::mlir::Block*(*getLabelTarget)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::wasmssa::LabelLevelOpInterface;
    Model() : Concept{getLabelTarget} {}

    static inline ::mlir::Block*getLabelTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::wasmssa::LabelLevelOpInterface;
    FallbackModel() : Concept{getLabelTarget} {}

    static inline ::mlir::Block*getLabelTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
  };
};
template <typename ConcreteOp>
struct LabelLevelOpInterfaceTrait;

} // namespace detail
class LabelLevelOpInterface : public ::mlir::OpInterface<LabelLevelOpInterface, detail::LabelLevelOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<LabelLevelOpInterface, detail::LabelLevelOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::LabelLevelOpInterfaceTrait<ConcreteOp> {};

  /// Returns the target block address
  ::mlir::Block*getLabelTarget();
};
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
/// Wasm operation that targets a label for a jump.
namespace detail {
struct LabelBranchingOpInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    size_t (*getExitLevel)(const Concept *impl, ::mlir::Operation *);
    LabelLevelOpInterface (*getTargetOp)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Block*(*getTarget)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::wasmssa::LabelBranchingOpInterface;
    Model() : Concept{getExitLevel, getTargetOp, getTarget} {}

    static inline size_t getExitLevel(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline LabelLevelOpInterface getTargetOp(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Block*getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::wasmssa::LabelBranchingOpInterface;
    FallbackModel() : Concept{getExitLevel, getTargetOp, getTarget} {}

    static inline size_t getExitLevel(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline LabelLevelOpInterface getTargetOp(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Block*getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    ::mlir::Block*getTarget(::mlir::Operation *tablegen_opaque_val) const;
  };
};
template <typename ConcreteOp>
struct LabelBranchingOpInterfaceTrait;

} // namespace detail
class LabelBranchingOpInterface : public ::mlir::OpInterface<LabelBranchingOpInterface, detail::LabelBranchingOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<LabelBranchingOpInterface, detail::LabelBranchingOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::LabelBranchingOpInterfaceTrait<ConcreteOp> {};

  /// Returns the number of context to break from
  size_t getExitLevel();

  /// Returns the destination of this operation
  LabelLevelOpInterface getTargetOp();

  /// Return the target control flow ops that defined the label of this operation
  ::mlir::Block*getTarget();

    static ::llvm::FailureOr<LabelLevelOpInterface> getTargetOpFromBlock(::mlir::Block *block, uint32_t level);
};
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
/// Operation that imports a symbol from an external Wasm module;
namespace detail {
struct ImportOpInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    ::llvm::StringRef (*getModuleName)(const Concept *impl, ::mlir::Operation *);
    ::llvm::StringRef (*getImportName)(const Concept *impl, ::mlir::Operation *);
    ::mlir::StringAttr (*getSymbolName)(const Concept *impl, ::mlir::Operation *);
    std::string (*getQualifiedImportName)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::wasmssa::ImportOpInterface;
    Model() : Concept{getModuleName, getImportName, getSymbolName, getQualifiedImportName} {}

    static inline ::llvm::StringRef getModuleName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::llvm::StringRef getImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::StringAttr getSymbolName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::string getQualifiedImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::wasmssa::ImportOpInterface;
    FallbackModel() : Concept{getModuleName, getImportName, getSymbolName, getQualifiedImportName} {}

    static inline ::llvm::StringRef getModuleName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::llvm::StringRef getImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::StringAttr getSymbolName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::string getQualifiedImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    ::mlir::StringAttr getSymbolName(::mlir::Operation *tablegen_opaque_val) const;
  };
};
template <typename ConcreteOp>
struct ImportOpInterfaceTrait;

} // namespace detail
class ImportOpInterface : public ::mlir::OpInterface<ImportOpInterface, detail::ImportOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<ImportOpInterface, detail::ImportOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::ImportOpInterfaceTrait<ConcreteOp> {};

  /// Returns the module name for the import
  ::llvm::StringRef getModuleName();

  /// Returns the import name for the import
  ::llvm::StringRef getImportName();

  /// Returns the Wasm index based symbol of the op
  ::mlir::StringAttr getSymbolName();

  /// Returns the qualified name of the import
  std::string getQualifiedImportName();
};
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
namespace detail {
  template <typename ConcreteOp>
  struct LabelLevelOpInterfaceTrait : public ::mlir::OpInterface<LabelLevelOpInterface, detail::LabelLevelOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {
    static ::llvm::LogicalResult verifyTrait(::mlir::Operation *op) {
      return success(
      succeeded(verifyLabelLevelInterfaceIsTerminator<ConcreteOp>()) &&
      succeeded(verifyLabelLevelInterface(op)));
    }
  };
}// namespace detail
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
namespace detail {
  template <typename ConcreteOp>
  struct LabelBranchingOpInterfaceTrait : public ::mlir::OpInterface<LabelBranchingOpInterface, detail::LabelBranchingOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {

    /// Return the target control flow ops that defined the label of this operation
    ::mlir::Block*getTarget() {
      auto op = mlir::cast<LabelBranchingOpInterface>(this->getOperation());
        return op.getTargetOp().getLabelTarget();
    }
    static ::llvm::LogicalResult verifyTrait(::mlir::Operation *op) {
      return verifyLabelBranchingOpInterface(op);
    }
  };
}// namespace detail
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
namespace detail {
  template <typename ConcreteOp>
  struct ImportOpInterfaceTrait : public ::mlir::OpInterface<ImportOpInterface, detail::ImportOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {

    /// Returns the Wasm index based symbol of the op
    ::mlir::StringAttr getSymbolName() {
      auto op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getSymNameAttr();
    }
  };
}// namespace detail
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
template<typename ConcreteOp>
::mlir::Block*detail::LabelLevelOpInterfaceInterfaceTraits::Model<ConcreteOp>::getLabelTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getLabelTarget();
}
template<typename ConcreteOp>
::mlir::Block*detail::LabelLevelOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getLabelTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getLabelTarget(tablegen_opaque_val);
}
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
template<typename ConcreteOp>
size_t detail::LabelBranchingOpInterfaceInterfaceTraits::Model<ConcreteOp>::getExitLevel(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getExitLevel();
}
template<typename ConcreteOp>
LabelLevelOpInterface detail::LabelBranchingOpInterfaceInterfaceTraits::Model<ConcreteOp>::getTargetOp(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return *LabelBranchingOpInterface::getTargetOpFromBlock((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getOperation()->getBlock(), (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getExitLevel());
}
template<typename ConcreteOp>
::mlir::Block*detail::LabelBranchingOpInterfaceInterfaceTraits::Model<ConcreteOp>::getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getTarget();
}
template<typename ConcreteOp>
size_t detail::LabelBranchingOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getExitLevel(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getExitLevel(tablegen_opaque_val);
}
template<typename ConcreteOp>
LabelLevelOpInterface detail::LabelBranchingOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTargetOp(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTargetOp(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Block*detail::LabelBranchingOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTarget(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTarget(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
::mlir::Block*detail::LabelBranchingOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getTarget(::mlir::Operation *tablegen_opaque_val) const {
auto op = mlir::cast<LabelBranchingOpInterface>(this->getOperation());
        return op.getTargetOp().getLabelTarget();
}
} // namespace wasmssa
} // namespace mlir
namespace mlir {
namespace wasmssa {
template<typename ConcreteOp>
::llvm::StringRef detail::ImportOpInterfaceInterfaceTraits::Model<ConcreteOp>::getModuleName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getModuleName();
}
template<typename ConcreteOp>
::llvm::StringRef detail::ImportOpInterfaceInterfaceTraits::Model<ConcreteOp>::getImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getImportName();
}
template<typename ConcreteOp>
::mlir::StringAttr detail::ImportOpInterfaceInterfaceTraits::Model<ConcreteOp>::getSymbolName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getSymbolName();
}
template<typename ConcreteOp>
std::string detail::ImportOpInterfaceInterfaceTraits::Model<ConcreteOp>::getQualifiedImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return ((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getModuleName() + ::llvm::Twine{"::"} + (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getImportName()).str();
}
template<typename ConcreteOp>
::llvm::StringRef detail::ImportOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getModuleName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getModuleName(tablegen_opaque_val);
}
template<typename ConcreteOp>
::llvm::StringRef detail::ImportOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getImportName(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::StringAttr detail::ImportOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getSymbolName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getSymbolName(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::string detail::ImportOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getQualifiedImportName(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getQualifiedImportName(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
::mlir::StringAttr detail::ImportOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getSymbolName(::mlir::Operation *tablegen_opaque_val) const {
auto op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getSymNameAttr();
}
} // namespace wasmssa
} // namespace mlir
