/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* TypeDef Declarations                                                       *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_TYPEDEF_CLASSES
#undef GET_TYPEDEF_CLASSES


namespace mlir {
class AsmParser;
class AsmPrinter;
} // namespace mlir
namespace mlir {
namespace smt {
class BoolType;
/// This type represents the `Int` sort as described in the
///     [SMT Ints theory](https://smtlib.cs.uiowa.edu/Theories/Ints.smt2) of the
///     SMT-LIB 2.7 standard.
class IntType;
/// This type represents the `(_ BitVec width)` sort as described in the
///     [SMT bit-vector
///     theory](https://smtlib.cs.uiowa.edu/theories-FixedSizeBitVectors.shtml).
/// 
///     The bit-width must be strictly greater than zero.
class BitVectorType;
/// This type represents the `(Array X Y)` sort, where X and Y are any
///     sort/type, as described in the
///     [SMT ArrayEx theory](https://smtlib.cs.uiowa.edu/Theories/ArraysEx.smt2) of
///     the SMT-LIB standard 2.7.
class ArrayType;
/// This type represents the SMT function sort as described in the
///     [SMT-LIB 2.7 standard](https://smt-lib.org/papers/smt-lib-reference-v2.7-r2025-02-05.pdf).
///     It is part of the language itself rather than a theory or logic.
/// 
///     A function in SMT can have an arbitrary domain size, but always has exactly
///     one range sort.
/// 
///     Since SMT only supports first-order logic, it is not possible to nest
///     function types.
/// 
///     Example: `!smt.func<(!smt.bool, !smt.int) !smt.bool>` is equivalent to
///     `((Bool Int) Bool)` in SMT-LIB.
class SMTFuncType;
/// This type represents uninterpreted sorts. The usage of a type like
///     `!smt.sort<"sort_name"[!smt.bool, !smt.sort<"other_sort">]>` implies a
///     `declare-sort sort_name 2` and a `declare-sort other_sort 0` in SMT-LIB.
///     This type represents concrete use-sites of such declared sorts, in this
///     particular case it would be equivalent to `(sort_name Bool other_sort)` in
///     SMT-LIB. More details about the semantics can be found in the
///     [SMT-LIB 2.7 standard](https://smt-lib.org/papers/smt-lib-reference-v2.7-r2025-02-05.pdf).
class SortType;
class BoolType : public ::mlir::Type::TypeBase<BoolType, ::mlir::Type, ::mlir::TypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "smt.bool";
  static constexpr ::llvm::StringLiteral dialectName = "smt";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"bool"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
};
class IntType : public ::mlir::Type::TypeBase<IntType, ::mlir::Type, ::mlir::TypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "smt.int";
  static constexpr ::llvm::StringLiteral dialectName = "smt";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"int"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
};
namespace detail {
struct BitVectorTypeStorage;
} // namespace detail
class BitVectorType : public ::mlir::Type::TypeBase<BitVectorType, ::mlir::Type, detail::BitVectorTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "smt.bv";
  static constexpr ::llvm::StringLiteral dialectName = "smt";
  using Base::getChecked;
  static BitVectorType get(::mlir::MLIRContext *context, int64_t width);
  static BitVectorType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, int64_t width);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, int64_t width);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, int64_t width);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"bv"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getWidth() const;
};
namespace detail {
struct ArrayTypeStorage;
} // namespace detail
class ArrayType : public ::mlir::Type::TypeBase<ArrayType, ::mlir::Type, detail::ArrayTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "smt.array";
  static constexpr ::llvm::StringLiteral dialectName = "smt";
  using Base::getChecked;
  static ArrayType get(::mlir::MLIRContext *context, mlir::Type domainType, mlir::Type rangeType);
  static ArrayType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, mlir::Type domainType, mlir::Type rangeType);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type domainType, mlir::Type rangeType);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type domainType, mlir::Type rangeType);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"array"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getDomainType() const;
  mlir::Type getRangeType() const;
};
namespace detail {
struct SMTFuncTypeStorage;
} // namespace detail
class SMTFuncType : public ::mlir::Type::TypeBase<SMTFuncType, ::mlir::Type, detail::SMTFuncTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "smt.func";
  static constexpr ::llvm::StringLiteral dialectName = "smt";
  using Base::getChecked;
  static SMTFuncType get(::mlir::MLIRContext *context, ::llvm::ArrayRef<mlir::Type> domainTypes, mlir::Type rangeType);
  static SMTFuncType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::ArrayRef<mlir::Type> domainTypes, mlir::Type rangeType);
  static SMTFuncType get(llvm::ArrayRef<mlir::Type> domainTypes, mlir::Type rangeType);
  static SMTFuncType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, llvm::ArrayRef<mlir::Type> domainTypes, mlir::Type rangeType);
  static SMTFuncType get(mlir::Type rangeType);
  static SMTFuncType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type rangeType);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<mlir::Type> domainTypes, mlir::Type rangeType);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<mlir::Type> domainTypes, mlir::Type rangeType);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"func"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::ArrayRef<mlir::Type> getDomainTypes() const;
  mlir::Type getRangeType() const;
};
namespace detail {
struct SortTypeStorage;
} // namespace detail
class SortType : public ::mlir::Type::TypeBase<SortType, ::mlir::Type, detail::SortTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "smt.sort";
  static constexpr ::llvm::StringLiteral dialectName = "smt";
  using Base::getChecked;
  static SortType get(::mlir::MLIRContext *context, mlir::StringAttr identifier, ::llvm::ArrayRef<mlir::Type> sortParams);
  static SortType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, mlir::StringAttr identifier, ::llvm::ArrayRef<mlir::Type> sortParams);
  static SortType get(::mlir::MLIRContext *context, llvm::StringRef identifier, llvm::ArrayRef<mlir::Type> sortParams);
  static SortType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, llvm::StringRef identifier, llvm::ArrayRef<mlir::Type> sortParams);
  static SortType get(::mlir::MLIRContext *context, llvm::StringRef identifier);
  static SortType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, llvm::StringRef identifier);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::StringAttr identifier, ::llvm::ArrayRef<mlir::Type> sortParams);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::StringAttr identifier, ::llvm::ArrayRef<mlir::Type> sortParams);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"sort"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::StringAttr getIdentifier() const;
  ::llvm::ArrayRef<mlir::Type> getSortParams() const;
};
} // namespace smt
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(mlir::smt::BoolType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(mlir::smt::IntType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(mlir::smt::BitVectorType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(mlir::smt::ArrayType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(mlir::smt::SMTFuncType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(mlir::smt::SortType)

#endif // GET_TYPEDEF_CLASSES

