/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: OpenACCOps.td                                                        *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace acc {
/// performs an atomic capture
/// This operation performs an atomic capture.
/// 
///     The region has the following allowed forms:
/// 
///     ```
///       acc.atomic.capture {
///         acc.atomic.update ...
///         acc.atomic.read ...
///         acc.terminator
///       }
/// 
///       acc.atomic.capture {
///         acc.atomic.read ...
///         acc.atomic.update ...
///         acc.terminator
///       }
/// 
///       acc.atomic.capture {
///         acc.atomic.read ...
///         acc.atomic.write ...
///         acc.terminator
///       }
///     ```
class AtomicCaptureOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// performs an atomic read
/// This operation performs an atomic read.
/// 
///     The operand `x` is the address from where the value is atomically read.
///     The operand `v` is the address where the value is stored after reading.
class AtomicReadOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// performs an atomic update
/// This operation performs an atomic update.
/// 
///     The operand `x` is exactly the same as the operand `x` in the OpenACC
///     Standard (OpenACC 3.3, section 2.12). It is the address of the variable
///     that is being updated. `x` is atomically read/written.
/// 
///     The region describes how to update the value of `x`. It takes the value at
///     `x` as an input and must yield the updated value. Only the update to `x` is
///     atomic. Generally the region must have only one instruction, but can
///     potentially have more than one instructions too. The update is sematically
///     similar to a compare-exchange loop based atomic update.
/// 
///     The syntax of atomic update operation is different from atomic read and
///     atomic write operations. This is because only the host dialect knows how to
///     appropriately update a value. For example, while generating LLVM IR, if
///     there are no special `atomicrmw` instructions for the operation-type
///     combination in atomic update, a compare-exchange loop is generated, where
///     the core update operation is directly translated like regular operations by
///     the host dialect. The front-end must handle semantic checks for allowed
///     operations.
class AtomicUpdateOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// performs an atomic write
/// This operation performs an atomic write.
/// 
///     The operand `x` is the address to where the `expr` is atomically
///     written w.r.t. multiple threads. The evaluation of `expr` need not be
///     atomic w.r.t. the write to address. In general, the type(x) must
///     dereference to type(expr).
class AtomicWriteOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc attach semantics which updates a pointer in device memory with the corresponding device address of the pointee.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class AttachOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents the cache directive that is associated with a loop.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class CacheOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents copyin semantics for acc data clauses like acc copyin and acc copy.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class CopyinOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc copyout semantics - reverse of copyin.
/// - `varPtr`: The address of variable to copy back to.
///     - `accVar`: The acc variable. This is the link from the data-entry
///     operation used.
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, always, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data exit operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class CopyoutOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents create semantics for acc data clauses like acc create and acc copyout.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class CreateOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents normalized bounds information for acc data clause.
/// This operation is used to record bounds used in acc data clause in a
///     normalized fashion (zero-based). This works well with the `PointerLikeType`
///     requirement in data clauses - since a `lowerbound` of 0 means looking
///     at data at the zero offset from pointer.
/// 
///     The operation must have an `upperbound` or `extent` (or both are allowed -
///     but not checked for consistency). When the source language's arrays are
///     not zero-based, the `startIdx` must specify the zero-position index.
/// 
///     The `stride` represents the distance between consecutive elements. For
///     multi-dimensional arrays, the `stride` for each outer dimension must account
///     for the complete size of all inner dimensions.
/// 
///     The `strideInBytes` flag indicates that the `stride` is specified in bytes
///     rather than the number of elements.
/// 
///     Examples below show copying a slice of 10-element array except first element.
///     Note that the examples use extent in data clause for C++ and upperbound
///     for Fortran (as per 2.7.1). To simplify examples, the constants are used
///     directly in the acc.bounds operands - this is not the syntax of operation.
/// 
///     C++:
///     ```
///     int array[10];
///     #pragma acc copy(array[1:9])
///     ```
///     =>
///     ```mlir
///     acc.bounds lb(1) ub(9) extent(9) startIdx(0) stride(1)
///     ```
/// 
///     Fortran:
///     ```
///     integer :: array(1:10)
///     !$acc copy(array(2:10))
///     ```
///     =>
///     ```mlir
///     acc.bounds lb(1) ub(9) extent(9) startIdx(1) stride(1)
///     ```
class DataBoundsOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// data construct
/// The "acc.data" operation represents a data construct. It defines vars to
///     be allocated in the current device memory for the duration of the region,
///     whether data should be copied from local memory to the current device
///     memory upon region entry , and copied from device memory to local memory
///     upon region exit.
/// 
///     Example:
/// 
///     ```mlir
///     acc.data present(%a: memref<10x10xf32>, %b: memref<10x10xf32>,
///         %c: memref<10xf32>, %d: memref<10xf32>) {
///       // data region
///     }
///     ```
/// 
///     `async` and `wait` operands are supported with `device_type` information.
///     They should only be accessed by the extra provided getters. If modified,
///     the corresponding `device_type` attributes must be modified as well.
class DataOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc declare device_resident semantics.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class DeclareDeviceResidentOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// declare directive - entry to implicit data region
/// The "acc.declare_enter" operation represents the OpenACC declare directive
///     and captures the entry semantics to the implicit data region.
///     This operation is modeled similarly to "acc.enter_data".
/// 
///     Example showing `acc declare create(a)`:
/// 
///     ```mlir
///     %0 = acc.create varPtr(%a : !llvm.ptr) -> !llvm.ptr
///     acc.declare_enter dataOperands(%0 : !llvm.ptr)
///     ```
class DeclareEnterOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// declare directive - exit from implicit data region
/// The "acc.declare_exit" operation represents the OpenACC declare directive
///     and captures the exit semantics from the implicit data region.
///     This operation is modeled similarly to "acc.exit_data".
/// 
///     Example showing `acc declare device_resident(a)`:
/// 
///     ```mlir
///     %0 = acc.getdeviceptr varPtr(%a : !llvm.ptr) -> !llvm.ptr {dataClause = #acc<data_clause declare_device_resident>}
///     acc.declare_exit dataOperands(%0 : !llvm.ptr)
///     acc.delete accPtr(%0 : !llvm.ptr) {dataClause = #acc<data_clause declare_device_resident>}
///     ```
class DeclareExitOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc declare link semantics.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class DeclareLinkOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// declare implicit region
/// The "acc.declare" operation represents an implicit declare region in
///     function (and subroutine in Fortran).
/// 
///     Example:
/// 
///     ```mlir
///     %pa = acc.present varPtr(%a : memref<10x10xf32>) -> memref<10x10xf32>
///     acc.declare dataOperands(%pa: memref<10x10xf32>) {
///       // implicit region
///     }
///     ```
class DeclareOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc delete semantics - reverse of create.
/// - `accVar`: The acc variable. This is the link from the data-entry
///     operation used.
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, always, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data exit operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class DeleteOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc detach semantics - reverse of attach.
/// - `accVar`: The acc variable. This is the link from the data-entry
///     operation used.
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, always, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data exit operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class DetachOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Specifies that the variable pointer is a device pointer.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class DevicePtrOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// enter data operation
/// The "acc.enter_data" operation represents the OpenACC enter data directive.
/// 
///     Example:
/// 
///     ```mlir
///     acc.enter_data create(%d1 : memref<10xf32>) attributes {async}
///     ```
class EnterDataOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// exit data operation
/// The "acc.exit_data" operation represents the OpenACC exit data directive.
/// 
///     Example:
/// 
///     ```mlir
///     acc.exit_data delete(%d1 : memref<10xf32>) attributes {async}
///     ```
class ExitDataOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents firstprivate semantic for the acc firstprivate clause.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class FirstprivateOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// privatization recipe
/// Declares an OpenACC privatization recipe with copy of the initial value.
///     The operation requires two mandatory regions and one optional.
/// 
///       1. The initializer region specifies how to allocate and initialize a new
///          private value. For example in Fortran, a derived-type might have a
///          default initialization. The region has an argument that contains the
///          original value that needs to be privatized, followed by bounds arguments
///          (if any) in order from innermost to outermost dimension. The region must
///          yield the privatized copy.
///       2. The copy region specifies how to copy the initial value to the newly
///          created private value. It takes the original value, the privatized
///          value, followed by bounds arguments (if any) in the same order.
///       3. The destroy region specifies how to destruct the value when it reaches
///          its end of life. It takes the original value, the privatized value, and
///          bounds arguments (if any) in the same order. It is optional.
/// 
///     A single privatization recipe can be used for multiple operand if they have
///     the same type and do not require a specific default initialization.
/// 
///     Example:
/// 
///     ```mlir
///     acc.firstprivate.recipe @firstprivate_memref : memref<10x20xf32> init {
///     ^bb0(%original: memref<10x20xf32>):
///       // init region contains a sequence of operations to create and
///       // initialize the copy. It yields the privatized copy.
///       %alloca = memref.alloca() : memref<10x20xf32>
///       acc.yield %alloca : memref<10x20xf32>
///     } copy {
///     ^bb0(%original: memref<10x20xf32>, %privatized: memref<10x20xf32>):
///       // copy region contains a sequence of operations to copy the initial value
///       // of the firstprivate value to the newly created value.
///       memref.copy %original, %privatized : memref<10x20xf32> to memref<10x20xf32>
///       acc.terminator
///     } destroy {
///     ^bb0(%original: memref<10x20xf32>, %privatized: memref<10x20xf32>):
///       // destroy region is empty since alloca is automatically cleaned up
///       acc.terminator
///     }
/// 
///     // Example with bounds for array slicing:
///     acc.firstprivate.recipe @firstprivate_slice : memref<10x20xf32> init {
///     ^bb0(%original: memref<10x20xf32>, %bounds_inner: !acc.data_bounds_ty, %bounds_outer: !acc.data_bounds_ty):
///       // Extract bounds and create appropriately sized allocation
///       %extent_inner = acc.get_extent %bounds_inner : (!acc.data_bounds_ty) -> index
///       %extent_outer = acc.get_extent %bounds_outer : (!acc.data_bounds_ty) -> index
///       %slice_alloc = memref.alloca(%extent_outer, %extent_inner) : memref<?x?xf32>
///       // ... base pointer adjustment logic ...
///       acc.yield %result : memref<10x20xf32>
///     } copy {
///     ^bb0(%original: memref<10x20xf32>, %privatized: memref<10x20xf32>, %bounds_inner: !acc.data_bounds_ty, %bounds_outer: !acc.data_bounds_ty):
///       // Copy the slice portion from original to privatized
///       %lb_inner = acc.get_lowerbound %bounds_inner : (!acc.data_bounds_ty) -> index
///       %lb_outer = acc.get_lowerbound %bounds_outer : (!acc.data_bounds_ty) -> index
///       %extent_inner = acc.get_extent %bounds_inner : (!acc.data_bounds_ty) -> index
///       %extent_outer = acc.get_extent %bounds_outer : (!acc.data_bounds_ty) -> index
///       %subview = memref.subview %original[%lb_outer, %lb_inner][%extent_outer, %extent_inner][1, 1]
///         : memref<10x20xf32> to memref<?x?xf32, strided<[20, 1], offset: ?>>
///       // Copy subview to privatized...
///       acc.terminator
///     }
/// 
///     // The privatization symbol is then used in the corresponding operation.
///     acc.parallel firstprivate(@firstprivate_memref -> %a : memref<10x20xf32>) {
///     }
///     ```
class FirstprivateRecipeOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Gets device address if variable exists on device.
/// This operation is used to get the `accPtr` for a variable. This is often
///       used in conjunction with data exit operations when the data entry
///       operation is not visible. This operation can have a `dataClause` argument
///       that is any of the valid `mlir::acc::DataClause` entries.
///       \
///     
///     Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class GetDevicePtrOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Extract extent from OpenACC data bounds.
/// This operation extracts the extent value from an `acc.bounds` value.
///     If the data bounds does not have an extent specified, it is computed
///     from the upperbound.
/// 
///     Example:
///     ```mlir
///     %extent = acc.get_extent %bounds : (!acc.data_bounds_ty) -> index
///     ```
class GetExtentOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Extract lowerbound from OpenACC data bounds.
/// This operation extracts the lowerbound value from an `acc.bounds` value.
///     If the data bounds does not have a lowerbound specified, it means it is zero.
/// 
///     Example:
///     ```mlir
///     %lb = acc.get_lowerbound %bounds : (!acc.data_bounds_ty) -> index
///     ```
class GetLowerboundOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Extract stride from OpenACC data bounds.
/// This operation extracts the stride value from an `acc.bounds` value.
///     If the data bounds does not have a stride specified, it defaults to 1.
/// 
///     Example:
///     ```mlir
///     %stride = acc.get_stride %bounds : (!acc.data_bounds_ty) -> index
///     ```
class GetStrideOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Extract upperbound from OpenACC data bounds.
/// This operation extracts the upperbound value from an `acc.bounds` value.
///     If the data bounds does not have an upperbound specified, this operation
///     uses the extent to compute it.
/// 
///     Example:
///     ```mlir
///     %ub = acc.get_upperbound %bounds : (!acc.data_bounds_ty) -> index
///     ```
class GetUpperboundOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Used to hold construction operations associated with globals such as declare
/// The "acc.global_ctor" operation is used to capture OpenACC actions to apply
///     on globals (such as `acc declare`) at the entry to the implicit data region.
///     This operation is isolated and intended to be used in a module.
/// 
///     Example showing `declare create` of global:
/// 
///     ```mlir
///     llvm.mlir.global external @globalvar() : i32 {
///       %0 = llvm.mlir.constant(0 : i32) : i32
///       llvm.return %0 : i32
///     }
///     acc.global_ctor @acc_constructor {
///       %0 = llvm.mlir.addressof @globalvar : !llvm.ptr
///       %1 = acc.create varPtr(%0 : !llvm.ptr) -> !llvm.ptr
///       acc.declare_enter dataOperands(%1 : !llvm.ptr)
///     }
///     ```
class GlobalConstructorOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Used to hold destruction operations associated with globals such as declare
/// The "acc.global_dtor" operation is used to capture OpenACC actions to apply
///     on globals (such as `acc declare`) at the exit from the implicit data
///     region. This operation is isolated and intended to be used in a module.
/// 
///     Example showing delete associated with `declare create` of global:
/// 
///     ```mlir
///     llvm.mlir.global external @globalvar() : i32 {
///       %0 = llvm.mlir.constant(0 : i32) : i32
///       llvm.return %0 : i32
///     }
///     acc.global_dtor @acc_destructor {
///       %0 = llvm.mlir.addressof @globalvar : !llvm.ptr
///       %1 = acc.getdeviceptr varPtr(%0 : !llvm.ptr) -> !llvm.ptr {dataClause = #acc<data_clause create>}
///       acc.declare_exit dataOperands(%1 : !llvm.ptr)
///       acc.delete accPtr(%1 : !llvm.ptr) {dataClause = #acc<data_clause create>}
///     }
///     ```
class GlobalDestructorOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// host_data construct
/// The "acc.host_data" operation represents the OpenACC host_data construct.
/// 
///     Example:
/// 
///     ```mlir
///     %0 = acc.use_device varPtr(%a : !llvm.ptr) -> !llvm.ptr
///     acc.host_data dataOperands(%0 : !llvm.ptr) {
/// 
///     }
///     ```
class HostDataOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// init operation
/// The "acc.init" operation represents the OpenACC init executable
///     directive.
/// 
///     Example:
/// 
///     ```mlir
///     acc.init
///     acc.init device_num(%dev1 : i32)
///     ```
class InitOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// kernels construct
/// The "acc.kernels" operation represents a kernels construct block. It has
///     one region to be compiled into a sequence of kernels for execution on the
///     current device.
/// 
///     Example:
/// 
///     ```mlir
///     acc.kernels num_gangs(%c10) num_workers(%c10)
///         private(%c : memref<10xf32>) {
///       // kernels region
///     }
///     ```
/// 
///     `collapse`, `gang`, `worker`, `vector`, `seq`, `independent`, `auto` and
///     `tile` operands are supported with `device_type` information. They should
///     only be accessed by the extra provided getters. If modified, the
///     corresponding `device_type` attributes must be modified as well.
class KernelsOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// loop construct
/// The `acc.loop` operation represents the OpenACC loop construct and when
///     bounds are included, the associated source language loop iterators. The
///     lower and upper bounds specify a half-open range: the range includes the
///     lower bound but does not include the upper bound. If the `inclusive`
///     attribute is set then the upper bound is included.
/// 
///     In cases where the OpenACC loop directive needs to capture multiple
///     source language loops, such as in the case of `collapse` or `tile`,
///     the multiple induction arguments are used to capture each case. Having
///     such a representation makes sure no intermediate transformation such
///     as Loop Invariant Code Motion breaks the property requested by the
///     clause on the loop constructs.
/// 
///     Each `acc.loop` holds private and reduction operands which are the
///     ssa values from the corresponding `acc.private` or `acc.reduction`
///     operations. Additionally, firstprivate operands are supported to
///     represent cases where privatization is needed with initialization
///     from an original value. While the OpenACC specification does not
///     explicitly support firstprivate on loop constructs, this extension
///     enables representing privatization scenarios that arise from an
///     optimization and codegen pipeline operating on acc dialect.
/// 
///     The operation supports capturing information that it comes combined
///     constructs (e.g., `parallel loop`, `kernels loop`, `serial loop`)
///     through the `combined` attribute despite requiring the `acc.loop`
///     to be decomposed from the compute operation representing compute
///     construct.
/// 
///     Example:
/// 
///     ```mlir
///     acc.loop gang() vector() (%arg3 : index, %arg4 : index, %arg5 : index) =
///         (%c0, %c0, %c0 : index, index, index) to 
///         (%c10, %c10, %c10 : index, index, index) step 
///         (%c1, %c1, %c1 : index, index, index) {
///       // Loop body
///       acc.yield
///     } attributes { collapse = [3] }
///     ```
/// 
///     `collapse`, `gang`, `worker`, `vector`, `seq`, `independent`, `auto`,
///     `cache`, and `tile` operands are supported with `device_type`
///     information. These clauses should only be accessed through the provided
///     device-type-aware getter methods. When modifying these operands, the
///     corresponding `device_type` attributes must be updated to maintain
///     consistency between operands and their target device types.
class LoopOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc no_create semantics.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class NoCreateOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// parallel construct
/// The "acc.parallel" operation represents a parallel construct block. It has
///     one region to be executed in parallel on the current device.
/// 
///     Example:
/// 
///     ```mlir
///     acc.parallel num_gangs(%c10) num_workers(%c10)
///         private(%c : memref<10xf32>) {
///       // parallel region
///     }
///     ```
/// 
///     `async`, `wait`, `num_gangs`, `num_workers` and `vector_length` operands are
///     supported with `device_type` information. They should only be accessed by
///     the extra provided getters. If modified, the corresponding `device_type`
///     attributes must be modified as well.
class ParallelOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Specifies that the variable is already present on device.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class PresentOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents private semantics for acc private clause.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class PrivateOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// privatization recipe
/// Declares an OpenACC privatization recipe. The operation requires one
///     mandatory and one optional region.
/// 
///       1. The initializer region specifies how to allocate and initialize a new
///          private value. For example in Fortran, a derived-type might have a
///          default initialization. The region has an argument that contains the
///          original value that needs to be privatized, followed by bounds arguments
///          (if any) in order from innermost to outermost dimension. The region
///          must yield the privatized copy.
///       2. The destroy region specifies how to destruct the value when it reaches
///          its end of life. It takes the original value, the privatized value, and
///          bounds arguments (if any) in the same order as the init region.
/// 
///     A single privatization recipe can be used for multiple operand if they have
///     the same type and do not require a specific default initialization.
/// 
///     Example:
/// 
///     ```mlir
///     acc.private.recipe @privatization_memref : memref<10x20xf32> init {
///     ^bb0(%original: memref<10x20xf32>):
///       // init region contains a sequence of operations to create and
///       // initialize the copy. It yields the privatized copy.
///       %alloca = memref.alloca() : memref<10x20xf32>
///       acc.yield %alloca : memref<10x20xf32>
///     } destroy {
///     ^bb0(%original: memref<10x20xf32>, %privatized: memref<10x20xf32>):
///       // destroy region is empty since alloca is automatically cleaned up
///       acc.terminator
///     }
/// 
///     // Example with bounds for array slicing:
///     acc.private.recipe @privatization_slice : memref<10x20xf32> init {
///     ^bb0(%original: memref<10x20xf32>, %bounds_inner: !acc.data_bounds_ty, %bounds_outer: !acc.data_bounds_ty):
///       // Extract bounds and create appropriately sized allocation
///       %extent_inner = acc.get_extent %bounds_inner : (!acc.data_bounds_ty) -> index
///       %extent_outer = acc.get_extent %bounds_outer : (!acc.data_bounds_ty) -> index
///       %slice_alloc = memref.alloca(%extent_outer, %extent_inner) : memref<?x?xf32>
///       // ... base pointer adjustment logic ...
///       acc.yield %result : memref<10x20xf32>
///     } destroy {
///     ^bb0(%original: memref<10x20xf32>, %privatized: memref<10x20xf32>, %bounds_inner: !acc.data_bounds_ty, %bounds_outer: !acc.data_bounds_ty):
///       // Cleanup is automatic for alloca-based allocations
///       acc.terminator
///     }
/// 
///     // The privatization symbol is then used in the corresponding operation.
///     acc.parallel private(@privatization_memref -> %a : memref<10x20xf32>) {
///     }
///     ```
class PrivateRecipeOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents reduction semantics for acc reduction clause.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class ReductionOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// reduction recipe
/// Declares an OpenACC reduction recipe. The operation requires two
///     mandatory regions and one optional region.
/// 
///       1. The initializer region specifies how to initialize the local reduction
///          value. The region has a first argument that contains the original value
///          that needs to be reduced, followed by bounds arguments (if any) in order
///          from innermost to outermost dimension. It is expected to `acc.yield` the
///          initialized reduction value.
///       2. The combiner region contains a sequence of operations to combine two
///          values of the reduction type into one. It has the first reduction value,
///          the second reduction value, followed by bounds arguments (if any) in the
///          same order. It is expected to `acc.yield` the combined value.
///       3. The optional destroy region specifies how to destruct the value when it
///          reaches its end of life. It takes the original value, the reduction value,
///          and bounds arguments (if any) in the same order.
/// 
///     Example:
/// 
///     ```mlir
///     acc.reduction.recipe @reduction_add_memref : memref<10x20xf32> reduction_operator<add> init {
///     ^bb0(%original: memref<10x20xf32>):
///       // init region contains a sequence of operations to initialize the local
///       // reduction value as specified in 2.5.15
///       %alloca = memref.alloca() : memref<10x20xf32>
///       %cst = arith.constant 0.0 : f32
///       linalg.fill ins(%cst : f32) outs(%alloca : memref<10x20xf32>)
///       acc.yield %alloca : memref<10x20xf32>
///     } combiner {
///     ^bb0(%lhs: memref<10x20xf32>, %rhs: memref<10x20xf32>):
///       // combiner region contains a sequence of operations to combine
///       // two values into one.
///       linalg.add ins(%lhs, %rhs : memref<10x20xf32>, memref<10x20xf32>)
///                  outs(%lhs : memref<10x20xf32>)
///       acc.yield %lhs : memref<10x20xf32>
///     } destroy {
///     ^bb0(%original: memref<10x20xf32>, %reduction: memref<10x20xf32>):
///       // destroy region is empty since alloca is automatically cleaned up
///       acc.terminator
///     }
/// 
///     // Example with bounds for array slicing:
///     acc.reduction.recipe @reduction_add_slice : memref<10x20xf32> reduction_operator<add> init {
///     ^bb0(%original: memref<10x20xf32>, %bounds_inner: !acc.data_bounds_ty, %bounds_outer: !acc.data_bounds_ty):
///       // Extract bounds and create appropriately sized allocation
///       %extent_inner = acc.get_extent %bounds_inner : (!acc.data_bounds_ty) -> index
///       %extent_outer = acc.get_extent %bounds_outer : (!acc.data_bounds_ty) -> index
///       %slice_alloc = memref.alloca(%extent_outer, %extent_inner) : memref<?x?xf32>
///       %cst = arith.constant 0.0 : f32
///       linalg.fill ins(%cst : f32) outs(%slice_alloc : memref<?x?xf32>)
///       // ... base pointer adjustment logic ...
///       acc.yield %result : memref<10x20xf32>
///     } combiner {
///     ^bb0(%lhs: memref<10x20xf32>, %rhs: memref<10x20xf32>, %bounds_inner: !acc.data_bounds_ty, %bounds_outer: !acc.data_bounds_ty):
///       // Extract bounds to operate only on the slice portion
///       %lb_inner = acc.get_lowerbound %bounds_inner : (!acc.data_bounds_ty) -> index
///       %lb_outer = acc.get_lowerbound %bounds_outer : (!acc.data_bounds_ty) -> index
///       %extent_inner = acc.get_extent %bounds_inner : (!acc.data_bounds_ty) -> index
///       %extent_outer = acc.get_extent %bounds_outer : (!acc.data_bounds_ty) -> index
/// 
///       // Create subviews to access only the slice portions
///       %lhs_slice = memref.subview %lhs[%lb_outer, %lb_inner][%extent_outer, %extent_inner][1, 1]
///         : memref<10x20xf32> to memref<?x?xf32, strided<[20, 1], offset: ?>>
///       %rhs_slice = memref.subview %rhs[%lb_outer, %lb_inner][%extent_outer, %extent_inner][1, 1]
///         : memref<10x20xf32> to memref<?x?xf32, strided<[20, 1], offset: ?>>
/// 
///       // Combine only the slice portions
///       linalg.add ins(%lhs_slice, %rhs_slice : memref<?x?xf32, strided<[20, 1], offset: ?>>, memref<?x?xf32, strided<[20, 1], offset: ?>>)
///                  outs(%lhs_slice : memref<?x?xf32, strided<[20, 1], offset: ?>>)
///       acc.yield %lhs : memref<10x20xf32>
///     }
/// 
///     // The reduction symbol is then used in the corresponding operation.
///     acc.parallel reduction(@reduction_add_memref -> %a : memref<10x20xf32>) {
///     }
///     ```
/// 
///     The following table lists the valid operators and the initialization values
///     according to OpenACC 3.3:
/// 
///     |------------------------------------------------|
///     |        C/C++          |        Fortran         |
///     |-----------------------|------------------------|
///     | operator | init value | operator | init value  |
///     |     +    |      0     |     +    |      0      |
///     |     *    |      1     |     *    |      1      |
///     |    max   |    least   |    max   |    least    |
///     |    min   |   largest  |    min   |   largest   |
///     |     &    |     ~0     |   iand   | all bits on |
///     |     |    |      0     |    ior   |      0      |
///     |     ^    |      0     |   ieor   |      0      |
///     |    &&    |      1     |   .and.  |    .true.   |
///     |    ||    |      0     |    .or.  |   .false.   |
///     |          |            |   .eqv.  |    .true.   |
///     |          |            |  .neqv.  |   .false.   |
///     -------------------------------------------------|
class ReductionRecipeOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// acc routine operation
/// The `acc.routine` operation is used to capture the clauses of acc
///     routine directive, including the associated function name. The associated
///     function keeps track of its corresponding routine declaration through
///     the `RoutineInfoAttr`.
/// 
///     Example:
/// 
///     ```mlir
///     func.func @acc_func(%a : i64) -> () attributes 
///         {acc.routine_info = #acc.routine_info<[@acc_func_rout1]>} {
///       return
///     }
///     acc.routine @acc_func_rout1 func(@acc_func) gang
///     ```
/// 
///     `bind`, `gang`, `worker`, `vector` and `seq` operands are supported with
///     `device_type` information. They should only be accessed by the extra
///     provided getters. If modified, the corresponding `device_type` attributes
///     must be modified as well.
class RoutineOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// serial construct
/// The "acc.serial" operation represents a serial construct block. It has
///     one region to be executed in serial on the current device.
/// 
///     Example:
/// 
///     ```mlir
///     acc.serial private(%c : memref<10xf32>) {
///       // serial region
///     }
///     ```
/// 
///     `async` and `wait` operands are supported with `device_type` information.
///     They should only be accessed by the extra provided getters. If modified,
///     the corresponding `device_type` attributes must be modified as well.
class SerialOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// set operation
/// The "acc.set" operation represents the OpenACC set directive.
/// 
///     Example:
/// 
///     ```mlir
///     acc.set device_num(%dev1 : i32)
///     ```
class SetOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// shutdown operation
/// The "acc.shutdown" operation represents the OpenACC shutdown executable
///     directive.
/// 
///     Example:
/// 
///     ```mlir
///     acc.shutdown
///     acc.shutdown device_num(%dev1 : i32)
///     ```
class ShutdownOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Generic terminator for OpenACC regions
/// A terminator operation for regions that appear in the body of OpenACC
///     operation. Generic OpenACC construct regions are not expected to return any
///     value so the terminator takes no operands. The terminator op returns control
///     to the enclosing op.
class TerminatorOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc update device semantics.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class UpdateDeviceOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc update host semantics.
/// - `varPtr`: The address of variable to copy back to.
///     - `accVar`: The acc variable. This is the link from the data-entry
///     operation used.
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, always, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data exit operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class UpdateHostOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// update operation
/// The `acc.update` operation represents the OpenACC update executable
///     directive.
///     As host and self clauses are synonyms, any operands for host and self are
///     add to $hostOperands.
/// 
///     Example:
/// 
///     ```mlir
///     acc.update device(%d1 : memref<10xf32>) attributes {async}
///     ```
/// 
///     `async` and `wait` operands are supported with `device_type` information.
///     They should only be accessed by the extra provided getters. If modified,
///     the corresponding `device_type` attributes must be modified as well.
class UpdateOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Represents acc use_device semantics.
/// Description of arguments:
///     - `var`: The variable to copy. Must be either `MappableType` or
///     `PointerLikeType`.
///     - `varType`: The type of the variable that is being copied. When `var` is
///     a `MappableType`, this matches the type of `var`. When `var` is a
///     `PointerLikeType`, this type holds information about the target of the
///     pointer.
///     - `varPtrPtr`: Specifies the address of the address of `var` - only used
///     when the variable copied is a field in a struct. This is important for
///     OpenACC due to implicit attach semantics on data clauses (2.6.4).
///     - `bounds`: Used when copying just slice of array or array's bounds are not
///     encoded in type. They are in rank order where rank 0 is inner-most dimension.
///     - `asyncOperands` and `asyncOperandsDeviceType`:
///     pair-wise lists of the async clause values associated with device_type's.
///     - `asyncOnly`: a list of device_type's for which async clause
///     does not specify a value (default is acc_async_noval - OpenACC 3.3 2.16.1).
///     - `dataClause`: Keeps track of the data clause the user used. This is because
///     the acc operations are decomposed. So a 'copy' clause is decomposed to both 
///     `acc.copyin` and `acc.copyout` operations, but both have dataClause that
///     specifies `acc_copy` in this field.
///     - `structured`: Flag to note whether this is associated with structured region
///     (parallel, kernels, data) or unstructured (enter data, exit data). This is
///     important due to spec specifically calling out structured and dynamic reference
///     counters (2.6.7).
///     - `implicit`: Whether this is an implicitly generated operation, such as copies
///     done to satisfy "Variables with Implicitly Determined Data Attributes" in 2.6.2.
///     - `modifiers`: Keeps track of the data clause modifiers (eg zero, readonly, etc)
///     - `name`: Holds the name of variable as specified in user clause (including bounds).
/// 
///     The async values attached to the data entry operation imply that the data
///     action applies to all device types specified by the device_type clauses
///     using the activity queues on these devices as defined by the async values.
class UseDeviceOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// wait operation
/// The "acc.wait" operation represents the OpenACC wait executable
///     directive.
/// 
///     Example:
/// 
///     ```mlir
///     acc.wait(%value1: index)
///     acc.wait() async(%async1: i32)
///     ```
/// 
///     acc.wait does not implement MemoryEffects interface,
///     so it affects all the resources. This is conservatively
///     correct. More precise modelling of the memory effects
///     seems to be impossible without the whole program analysis.
class WaitOp;
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {
/// Acc yield and termination operation
/// `acc.yield` is a special terminator operation for block inside regions in
///     various acc ops (including parallel, loop, atomic.update). It returns values
///     to the immediately enclosing acc op.
class YieldOp;
} // namespace acc
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::AtomicCaptureOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicCaptureOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicCaptureOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.atomic.capture", odsAttrs.getContext());
  }

  AtomicCaptureOpGenericAdaptorBase(AtomicCaptureOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class AtomicCaptureOpGenericAdaptor : public detail::AtomicCaptureOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicCaptureOpGenericAdaptorBase;
public:
  AtomicCaptureOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicCaptureOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicCaptureOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicCaptureOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicCaptureOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicCaptureOpGenericAdaptor(RangeT values, const AtomicCaptureOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicCaptureOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicCaptureOp>>>
  AtomicCaptureOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicCaptureOpAdaptor : public AtomicCaptureOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicCaptureOpGenericAdaptor::AtomicCaptureOpGenericAdaptor;
  AtomicCaptureOpAdaptor(AtomicCaptureOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicCaptureOp : public ::mlir::Op<AtomicCaptureOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<TerminatorOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::accomp::AtomicCaptureOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicCaptureOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicCaptureOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.atomic.capture");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static AtomicCaptureOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static AtomicCaptureOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static AtomicCaptureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static AtomicCaptureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCaptureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCaptureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCaptureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCaptureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
  /// Returns the `atomic.read` operation inside the region, if any.
  /// Otherwise, it returns nullptr.
  AtomicReadOp getAtomicReadOp();

  /// Returns the `atomic.write` operation inside the region, if any.
  /// Otherwise, it returns nullptr.
  AtomicWriteOp getAtomicWriteOp();

  /// Returns the `atomic.update` operation inside the region, if any.
  /// Otherwise, it returns nullptr.
  AtomicUpdateOp getAtomicUpdateOp();
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::AtomicCaptureOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::AtomicReadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicReadOpGenericAdaptorBase {
public:
  struct Properties {
    using element_typeTy = ::mlir::TypeAttr;
    element_typeTy element_type;

    auto getElementType() const {
      auto &propStorage = this->element_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setElementType(const ::mlir::TypeAttr &propValue) {
      this->element_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.element_type == this->element_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicReadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.atomic.read", odsAttrs.getContext());
  }

  AtomicReadOpGenericAdaptorBase(AtomicReadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getElementTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().element_type);
    return attr;
  }

  ::mlir::Type getElementType();
};
} // namespace detail
template <typename RangeT>
class AtomicReadOpGenericAdaptor : public detail::AtomicReadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicReadOpGenericAdaptorBase;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_v = 1;
public:
  AtomicReadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicReadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicReadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicReadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicReadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicReadOpGenericAdaptor(RangeT values, const AtomicReadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicReadOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicReadOp>>>
  AtomicReadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getV() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicReadOpAdaptor : public AtomicReadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicReadOpGenericAdaptor::AtomicReadOpGenericAdaptor;
  AtomicReadOpAdaptor(AtomicReadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicReadOp : public ::mlir::Op<AtomicReadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::accomp::AtomicReadOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicReadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicReadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_v = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("element_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getElementTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getElementTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.atomic.read");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getV() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getVMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getElementTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().element_type);
  }

  ::mlir::Type getElementType();
  void setElementTypeAttr(::mlir::TypeAttr attr) {
    getProperties().element_type = attr;
  }

  void setElementType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x, ::mlir::Value v, ::mlir::TypeAttr element_type);
  static AtomicReadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x, ::mlir::Value v, ::mlir::TypeAttr element_type);
  static AtomicReadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x, ::mlir::Value v, ::mlir::TypeAttr element_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value v, ::mlir::TypeAttr element_type);
  static AtomicReadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value v, ::mlir::TypeAttr element_type);
  static AtomicReadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value v, ::mlir::TypeAttr element_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x, ::mlir::Value v, ::mlir::Type element_type);
  static AtomicReadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x, ::mlir::Value v, ::mlir::Type element_type);
  static AtomicReadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x, ::mlir::Value v, ::mlir::Type element_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value v, ::mlir::Type element_type);
  static AtomicReadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value v, ::mlir::Type element_type);
  static AtomicReadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value v, ::mlir::Type element_type);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicReadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicReadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicReadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicReadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::AtomicReadOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::AtomicUpdateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicUpdateOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicUpdateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.atomic.update", odsAttrs.getContext());
  }

  AtomicUpdateOpGenericAdaptorBase(AtomicUpdateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class AtomicUpdateOpGenericAdaptor : public detail::AtomicUpdateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicUpdateOpGenericAdaptorBase;
  static constexpr int odsIndex_x = 0;
public:
  AtomicUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicUpdateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicUpdateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicUpdateOpGenericAdaptor(RangeT values, const AtomicUpdateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicUpdateOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicUpdateOp>>>
  AtomicUpdateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicUpdateOpAdaptor : public AtomicUpdateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicUpdateOpGenericAdaptor::AtomicUpdateOpGenericAdaptor;
  AtomicUpdateOpAdaptor(AtomicUpdateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicUpdateOp : public ::mlir::Op<AtomicUpdateOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<YieldOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::accomp::AtomicUpdateOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicUpdateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicUpdateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_x = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.atomic.update");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x);
  static AtomicUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x);
  static AtomicUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static AtomicUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static AtomicUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifyRegions();
  static ::llvm::LogicalResult canonicalize(AtomicUpdateOp op, ::mlir::PatternRewriter &rewriter);
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  Operation* getFirstOp() {
    return &getRegion().front().getOperations().front();
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::AtomicUpdateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::AtomicWriteOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AtomicWriteOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicWriteOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.atomic.write", odsAttrs.getContext());
  }

  AtomicWriteOpGenericAdaptorBase(AtomicWriteOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class AtomicWriteOpGenericAdaptor : public detail::AtomicWriteOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicWriteOpGenericAdaptorBase;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_expr = 1;
public:
  AtomicWriteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicWriteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicWriteOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicWriteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicWriteOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicWriteOpGenericAdaptor(RangeT values, const AtomicWriteOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicWriteOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicWriteOp>>>
  AtomicWriteOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getX() {
    return (*getODSOperands(0).begin());
  }

  ValueT getExpr() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicWriteOpAdaptor : public AtomicWriteOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicWriteOpGenericAdaptor::AtomicWriteOpGenericAdaptor;
  AtomicWriteOpAdaptor(AtomicWriteOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicWriteOp : public ::mlir::Op<AtomicWriteOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::accomp::AtomicWriteOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicWriteOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicWriteOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_x = 0;
  static constexpr int odsIndex_expr = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.atomic.write");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getX() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getExpr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getXMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getExprMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value x, ::mlir::Value expr);
  static AtomicWriteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value x, ::mlir::Value expr);
  static AtomicWriteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value x, ::mlir::Value expr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value expr);
  static AtomicWriteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value expr);
  static AtomicWriteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value x, ::mlir::Value expr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicWriteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicWriteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicWriteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicWriteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::AtomicWriteOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::AttachOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AttachOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AttachOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.attach", odsAttrs.getContext());
  }

  AttachOpGenericAdaptorBase(AttachOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class AttachOpGenericAdaptor : public detail::AttachOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AttachOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  AttachOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AttachOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AttachOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AttachOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : AttachOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AttachOpGenericAdaptor(RangeT values, const AttachOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AttachOp, typename = std::enable_if_t<std::is_same_v<LateInst, AttachOp>>>
  AttachOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AttachOpAdaptor : public AttachOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AttachOpGenericAdaptor::AttachOpGenericAdaptor;
  AttachOpAdaptor(AttachOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AttachOp : public ::mlir::Op<AttachOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AttachOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AttachOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.attach");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AttachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AttachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::AttachOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CacheOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CacheOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CacheOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.cache", odsAttrs.getContext());
  }

  CacheOpGenericAdaptorBase(CacheOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class CacheOpGenericAdaptor : public detail::CacheOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CacheOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  CacheOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CacheOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CacheOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CacheOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CacheOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CacheOpGenericAdaptor(RangeT values, const CacheOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CacheOp, typename = std::enable_if_t<std::is_same_v<LateInst, CacheOp>>>
  CacheOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CacheOpAdaptor : public CacheOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CacheOpGenericAdaptor::CacheOpGenericAdaptor;
  CacheOpAdaptor(CacheOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CacheOp : public ::mlir::Op<CacheOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CacheOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CacheOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.cache");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CacheOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CacheOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }

  /// Check if this is a cache with readonly modifier.
  bool isCacheReadonly();
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::CacheOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CopyinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CopyinOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CopyinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.copyin", odsAttrs.getContext());
  }

  CopyinOpGenericAdaptorBase(CopyinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class CopyinOpGenericAdaptor : public detail::CopyinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CopyinOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  CopyinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CopyinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CopyinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CopyinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CopyinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CopyinOpGenericAdaptor(RangeT values, const CopyinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CopyinOp, typename = std::enable_if_t<std::is_same_v<LateInst, CopyinOp>>>
  CopyinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CopyinOpAdaptor : public CopyinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CopyinOpGenericAdaptor::CopyinOpGenericAdaptor;
  CopyinOpAdaptor(CopyinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CopyinOp : public ::mlir::Op<CopyinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CopyinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CopyinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.copyin");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CopyinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CopyinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }

  /// Check if this is a copyin with readonly modifier.
  bool isCopyinReadonly();
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::CopyinOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CopyoutOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CopyoutOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CopyoutOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.copyout", odsAttrs.getContext());
  }

  CopyoutOpGenericAdaptorBase(CopyoutOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class CopyoutOpGenericAdaptor : public detail::CopyoutOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CopyoutOpGenericAdaptorBase;
  static constexpr int odsIndex_accVar = 0;
  static constexpr int odsIndex_var = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  CopyoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CopyoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CopyoutOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CopyoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CopyoutOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CopyoutOpGenericAdaptor(RangeT values, const CopyoutOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CopyoutOp, typename = std::enable_if_t<std::is_same_v<LateInst, CopyoutOp>>>
  CopyoutOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAccVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVar() {
    return (*getODSOperands(1).begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CopyoutOpAdaptor : public CopyoutOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CopyoutOpGenericAdaptor::CopyoutOpGenericAdaptor;
  CopyoutOpAdaptor(CopyoutOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CopyoutOp : public ::mlir::Op<CopyoutOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CopyoutOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CopyoutOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_accVar = 0;
  static constexpr int odsIndex_var = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.copyout");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getAccVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::Value var, ::mlir::TypeAttr varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::Value var, ::mlir::TypeAttr varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::Value var, ::mlir::TypeAttr varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::Value var, ::mlir::TypeAttr varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::Value var, ::mlir::TypeAttr varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::Value var, ::mlir::TypeAttr varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::Value var, ::mlir::Type varType, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CopyoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CopyoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }

  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }

  /// Check if this is a copyout with zero modifier.
  bool isCopyoutZero();
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::CopyoutOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CreateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class CreateOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CreateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.create", odsAttrs.getContext());
  }

  CreateOpGenericAdaptorBase(CreateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class CreateOpGenericAdaptor : public detail::CreateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CreateOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  CreateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CreateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CreateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CreateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CreateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CreateOpGenericAdaptor(RangeT values, const CreateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CreateOp, typename = std::enable_if_t<std::is_same_v<LateInst, CreateOp>>>
  CreateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CreateOpAdaptor : public CreateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CreateOpGenericAdaptor::CreateOpGenericAdaptor;
  CreateOpAdaptor(CreateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CreateOp : public ::mlir::Op<CreateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CreateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CreateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.create");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }

  /// Check if this is a create with zero modifier.
  bool isCreateZero();
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::CreateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DataBoundsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DataBoundsOpGenericAdaptorBase {
public:
  struct Properties {
    using strideInBytesTy = ::mlir::BoolAttr;
    strideInBytesTy strideInBytes;

    auto getStrideInBytes() const {
      auto &propStorage = this->strideInBytes;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStrideInBytes(const ::mlir::BoolAttr &propValue) {
      this->strideInBytes = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.strideInBytes == this->strideInBytes &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DataBoundsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.bounds", odsAttrs.getContext());
  }

  DataBoundsOpGenericAdaptorBase(DataBoundsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::BoolAttr getStrideInBytesAttr();
  bool getStrideInBytes();
};
} // namespace detail
template <typename RangeT>
class DataBoundsOpGenericAdaptor : public detail::DataBoundsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DataBoundsOpGenericAdaptorBase;
  static constexpr int odsIndex_lowerbound = 0;
  static constexpr int odsIndex_upperbound = 1;
  static constexpr int odsIndex_extent = 2;
  static constexpr int odsIndex_stride = 3;
  static constexpr int odsIndex_startIdx = 4;
public:
  DataBoundsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DataBoundsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DataBoundsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DataBoundsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DataBoundsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DataBoundsOpGenericAdaptor(RangeT values, const DataBoundsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DataBoundsOp, typename = std::enable_if_t<std::is_same_v<LateInst, DataBoundsOp>>>
  DataBoundsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLowerbound() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getUpperbound() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getExtent() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getStride() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getStartIdx() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DataBoundsOpAdaptor : public DataBoundsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DataBoundsOpGenericAdaptor::DataBoundsOpGenericAdaptor;
  DataBoundsOpAdaptor(DataBoundsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DataBoundsOp : public ::mlir::Op<DataBoundsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::acc::DataBoundsType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DataBoundsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DataBoundsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lowerbound = 0;
  static constexpr int odsIndex_upperbound = 1;
  static constexpr int odsIndex_extent = 2;
  static constexpr int odsIndex_stride = 3;
  static constexpr int odsIndex_startIdx = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("strideInBytes"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getStrideInBytesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getStrideInBytesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.bounds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLowerbound() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getUpperbound() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getExtent() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getStride() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getStartIdx() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::MutableOperandRange getLowerboundMutable();
  ::mlir::MutableOperandRange getUpperboundMutable();
  ::mlir::MutableOperandRange getExtentMutable();
  ::mlir::MutableOperandRange getStrideMutable();
  ::mlir::MutableOperandRange getStartIdxMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DataBoundsType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DataBoundsType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::BoolAttr getStrideInBytesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().strideInBytes);
  }

  bool getStrideInBytes();
  void setStrideInBytesAttr(::mlir::BoolAttr attr) {
    getProperties().strideInBytes = attr;
  }

  void setStrideInBytes(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value extent);
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value extent);
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value extent);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lowerbound, ::mlir::Value upperbound);
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lowerbound, ::mlir::Value upperbound);
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lowerbound, ::mlir::Value upperbound);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx);
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DataBoundsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DataBoundsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DataBoundsOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DataOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DataOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using defaultAttrTy = ::mlir::acc::ClauseDefaultValueAttr;
    defaultAttrTy defaultAttr;

    auto getDefaultAttr() const {
      auto &propStorage = this->defaultAttr;
      return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(propStorage);
    }
    void setDefaultAttr(const ::mlir::acc::ClauseDefaultValueAttr &propValue) {
      this->defaultAttr = propValue;
    }
    using hasWaitDevnumTy = ::mlir::ArrayAttr;
    hasWaitDevnumTy hasWaitDevnum;

    auto getHasWaitDevnum() const {
      auto &propStorage = this->hasWaitDevnum;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setHasWaitDevnum(const ::mlir::ArrayAttr &propValue) {
      this->hasWaitDevnum = propValue;
    }
    using waitOnlyTy = ::mlir::ArrayAttr;
    waitOnlyTy waitOnly;

    auto getWaitOnly() const {
      auto &propStorage = this->waitOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWaitOnly(const ::mlir::ArrayAttr &propValue) {
      this->waitOnly = propValue;
    }
    using waitOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    waitOperandsDeviceTypeTy waitOperandsDeviceType;

    auto getWaitOperandsDeviceType() const {
      auto &propStorage = this->waitOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWaitOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->waitOperandsDeviceType = propValue;
    }
    using waitOperandsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    waitOperandsSegmentsTy waitOperandsSegments;

    auto getWaitOperandsSegments() const {
      auto &propStorage = this->waitOperandsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setWaitOperandsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->waitOperandsSegments = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.defaultAttr == this->defaultAttr &&
        rhs.hasWaitDevnum == this->hasWaitDevnum &&
        rhs.waitOnly == this->waitOnly &&
        rhs.waitOperandsDeviceType == this->waitOperandsDeviceType &&
        rhs.waitOperandsSegments == this->waitOperandsSegments &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.data", odsAttrs.getContext());
  }

  DataOpGenericAdaptorBase(DataOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::DenseI32ArrayAttr getWaitOperandsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().waitOperandsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWaitOperandsSegments();
  ::mlir::ArrayAttr getWaitOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOperandsDeviceType();
  ::mlir::ArrayAttr getHasWaitDevnumAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().hasWaitDevnum);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getHasWaitDevnum();
  ::mlir::ArrayAttr getWaitOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOnly();
  ::mlir::acc::ClauseDefaultValueAttr getDefaultAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
    return attr;
  }

  ::std::optional<::mlir::acc::ClauseDefaultValue> getDefaultAttr();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class DataOpGenericAdaptor : public detail::DataOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DataOpGenericAdaptorBase;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_asyncOperands = 1;
  static constexpr int odsIndex_waitOperands = 2;
  static constexpr int odsIndex_dataClauseOperands = 3;
public:
  DataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DataOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DataOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DataOpGenericAdaptor(RangeT values, const DataOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DataOp, typename = std::enable_if_t<std::is_same_v<LateInst, DataOp>>>
  DataOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getAsyncOperands() {
    return getODSOperands(1);
  }

  RangeT getWaitOperands() {
    return getODSOperands(2);
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DataOpAdaptor : public DataOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DataOpGenericAdaptor::DataOpGenericAdaptor;
  DataOpAdaptor(DataOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DataOp : public ::mlir::Op<DataOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DataOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DataOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_asyncOperands = 1;
  static constexpr int odsIndex_waitOperands = 2;
  static constexpr int odsIndex_dataClauseOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("defaultAttr"), ::llvm::StringRef("hasWaitDevnum"), ::llvm::StringRef("waitOnly"), ::llvm::StringRef("waitOperandsDeviceType"), ::llvm::StringRef("waitOperandsSegments"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDefaultAttrAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDefaultAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getHasWaitDevnumAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getHasWaitDevnumAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getWaitOnlyAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getWaitOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getWaitOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getWaitOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getWaitOperandsSegmentsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getWaitOperandsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.data");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getWaitOperands() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(3);
  }

  ::mlir::MutableOperandRange getIfCondMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  ::mlir::MutableOperandRange getWaitOperandsMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::DenseI32ArrayAttr getWaitOperandsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().waitOperandsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWaitOperandsSegments();
  ::mlir::ArrayAttr getWaitOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOperandsDeviceType();
  ::mlir::ArrayAttr getHasWaitDevnumAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().hasWaitDevnum);
  }

  ::std::optional< ::mlir::ArrayAttr > getHasWaitDevnum();
  ::mlir::ArrayAttr getWaitOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOnly();
  ::mlir::acc::ClauseDefaultValueAttr getDefaultAttrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  }

  ::std::optional<::mlir::acc::ClauseDefaultValue> getDefaultAttr();
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setWaitOperandsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().waitOperandsSegments = attr;
  }

  void setWaitOperandsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setWaitOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().waitOperandsDeviceType = attr;
  }

  void setHasWaitDevnumAttr(::mlir::ArrayAttr attr) {
    getProperties().hasWaitDevnum = attr;
  }

  void setWaitOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().waitOnly = attr;
  }

  void setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
    getProperties().defaultAttr = attr;
  }

  void setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOperandsSegmentsAttr() {
      auto attr = getProperties().waitOperandsSegments;
      getProperties().waitOperandsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOperandsDeviceTypeAttr() {
      auto attr = getProperties().waitOperandsDeviceType;
      getProperties().waitOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeHasWaitDevnumAttr() {
      auto attr = getProperties().hasWaitDevnum;
      getProperties().hasWaitDevnum = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOnlyAttr() {
      auto attr = getProperties().waitOnly;
      getProperties().waitOnly = {};
      return attr;
  }

  ::mlir::Attribute removeDefaultAttrAttr() {
      auto attr = getProperties().defaultAttr;
      getProperties().defaultAttr = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr);
  static DataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr);
  static DataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr);
  static DataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr);
  static DataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// The number of data operands.
  unsigned getNumDataOperands();

  /// The i-th data operand passed.
  Value getDataOperand(unsigned i);

  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly();
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType);
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue();
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType);

  /// Return true if the op has the wait attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasWaitOnly();
  /// Return true if the op has the wait attribute for the given device_type.
  bool hasWaitOnly(mlir::acc::DeviceType deviceType);
  /// Return the values of the wait clause if present.
  mlir::Operation::operand_range getWaitValues();
  /// Return the values of the wait clause for the given device_type if
  /// present.
  mlir::Operation::operand_range
  getWaitValues(mlir::acc::DeviceType deviceType);
  /// Return the wait devnum value clause if present;
  mlir::Value getWaitDevnum();
  /// Return the wait devnum value clause for the given device_type if
  /// present.
  mlir::Value getWaitDevnum(mlir::acc::DeviceType deviceType);
  /// Add an entry to the 'async-only' attribute (clause spelled without
  /// arguments) for each of the additional device types (or a none if it is
  /// empty).
  void addAsyncOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add a value to the 'async' with the current list of device types.
  void addAsyncOperand(MLIRContext *, mlir::Value,
                       llvm::ArrayRef<DeviceType>);
  /// Add an entry to the 'wait-only' attribute (clause spelled without
  /// arguments) for each of the additional device types (or a none if it is
  /// empty).
  void addWaitOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry  to the 'wait' with the current list of device
  /// types.
  void addWaitOperands(MLIRContext *, bool hasDevnum, mlir::ValueRange,
                       llvm::ArrayRef<DeviceType>);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareDeviceResidentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeclareDeviceResidentOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareDeviceResidentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.declare_device_resident", odsAttrs.getContext());
  }

  DeclareDeviceResidentOpGenericAdaptorBase(DeclareDeviceResidentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class DeclareDeviceResidentOpGenericAdaptor : public detail::DeclareDeviceResidentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareDeviceResidentOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  DeclareDeviceResidentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareDeviceResidentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareDeviceResidentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareDeviceResidentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DeclareDeviceResidentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareDeviceResidentOpGenericAdaptor(RangeT values, const DeclareDeviceResidentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareDeviceResidentOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareDeviceResidentOp>>>
  DeclareDeviceResidentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareDeviceResidentOpAdaptor : public DeclareDeviceResidentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareDeviceResidentOpGenericAdaptor::DeclareDeviceResidentOpGenericAdaptor;
  DeclareDeviceResidentOpAdaptor(DeclareDeviceResidentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareDeviceResidentOp : public ::mlir::Op<DeclareDeviceResidentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareDeviceResidentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareDeviceResidentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.declare_device_resident");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareDeviceResidentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareDeviceResidentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareDeviceResidentOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareEnterOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeclareEnterOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareEnterOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.declare_enter", odsAttrs.getContext());
  }

  DeclareEnterOpGenericAdaptorBase(DeclareEnterOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DeclareEnterOpGenericAdaptor : public detail::DeclareEnterOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareEnterOpGenericAdaptorBase;
  static constexpr int odsIndex_dataClauseOperands = 0;
public:
  DeclareEnterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareEnterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareEnterOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareEnterOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DeclareEnterOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareEnterOpGenericAdaptor(RangeT values, const DeclareEnterOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareEnterOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareEnterOp>>>
  DeclareEnterOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareEnterOpAdaptor : public DeclareEnterOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareEnterOpGenericAdaptor::DeclareEnterOpGenericAdaptor;
  DeclareEnterOpAdaptor(DeclareEnterOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareEnterOp : public ::mlir::Op<DeclareEnterOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::acc::DeclareTokenType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareEnterOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareEnterOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dataClauseOperands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.declare_enter");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DeclareTokenType> getToken() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DeclareTokenType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type token, ::mlir::ValueRange dataClauseOperands);
  static DeclareEnterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type token, ::mlir::ValueRange dataClauseOperands);
  static DeclareEnterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type token, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareEnterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareEnterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareEnterOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareEnterOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareEnterOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareExitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeclareExitOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareExitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.declare_exit", odsAttrs.getContext());
  }

  DeclareExitOpGenericAdaptorBase(DeclareExitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class DeclareExitOpGenericAdaptor : public detail::DeclareExitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareExitOpGenericAdaptorBase;
  static constexpr int odsIndex_token = 0;
  static constexpr int odsIndex_dataClauseOperands = 1;
public:
  DeclareExitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareExitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareExitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareExitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DeclareExitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareExitOpGenericAdaptor(RangeT values, const DeclareExitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareExitOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareExitOp>>>
  DeclareExitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getToken() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareExitOpAdaptor : public DeclareExitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareExitOpGenericAdaptor::DeclareExitOpGenericAdaptor;
  DeclareExitOpAdaptor(DeclareExitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareExitOp : public ::mlir::Op<DeclareExitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareExitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareExitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_token = 0;
  static constexpr int odsIndex_dataClauseOperands = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.declare_exit");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DeclareTokenType> getToken() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::DeclareTokenType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::DeclareTokenType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getTokenMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value token, ::mlir::ValueRange dataClauseOperands);
  static DeclareExitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value token, ::mlir::ValueRange dataClauseOperands);
  static DeclareExitOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value token, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value token, ::mlir::ValueRange dataClauseOperands);
  static DeclareExitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value token, ::mlir::ValueRange dataClauseOperands);
  static DeclareExitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value token, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareExitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareExitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareExitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareExitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareExitOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareLinkOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeclareLinkOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareLinkOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.declare_link", odsAttrs.getContext());
  }

  DeclareLinkOpGenericAdaptorBase(DeclareLinkOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class DeclareLinkOpGenericAdaptor : public detail::DeclareLinkOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareLinkOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  DeclareLinkOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareLinkOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareLinkOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareLinkOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DeclareLinkOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareLinkOpGenericAdaptor(RangeT values, const DeclareLinkOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareLinkOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareLinkOp>>>
  DeclareLinkOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareLinkOpAdaptor : public DeclareLinkOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareLinkOpGenericAdaptor::DeclareLinkOpGenericAdaptor;
  DeclareLinkOpAdaptor(DeclareLinkOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareLinkOp : public ::mlir::Op<DeclareLinkOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareLinkOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareLinkOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.declare_link");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareLinkOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareLinkOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareLinkOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeclareOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.declare", odsAttrs.getContext());
  }

  DeclareOpGenericAdaptorBase(DeclareOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class DeclareOpGenericAdaptor : public detail::DeclareOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareOpGenericAdaptorBase;
  static constexpr int odsIndex_dataClauseOperands = 0;
public:
  DeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DeclareOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareOpGenericAdaptor(RangeT values, const DeclareOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareOp>>>
  DeclareOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareOpAdaptor : public DeclareOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareOpGenericAdaptor::DeclareOpGenericAdaptor;
  DeclareOpAdaptor(DeclareOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareOp : public ::mlir::Op<DeclareOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_dataClauseOperands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.declare");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange dataClauseOperands);
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange dataClauseOperands);
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeleteOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DeleteOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeleteOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.delete", odsAttrs.getContext());
  }

  DeleteOpGenericAdaptorBase(DeleteOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class DeleteOpGenericAdaptor : public detail::DeleteOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeleteOpGenericAdaptorBase;
  static constexpr int odsIndex_accVar = 0;
  static constexpr int odsIndex_bounds = 1;
  static constexpr int odsIndex_asyncOperands = 2;
public:
  DeleteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeleteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeleteOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeleteOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DeleteOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeleteOpGenericAdaptor(RangeT values, const DeleteOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeleteOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeleteOp>>>
  DeleteOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAccVar() {
    return (*getODSOperands(0).begin());
  }

  RangeT getBounds() {
    return getODSOperands(1);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeleteOpAdaptor : public DeleteOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeleteOpGenericAdaptor::DeleteOpGenericAdaptor;
  DeleteOpAdaptor(DeleteOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeleteOp : public ::mlir::Op<DeleteOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeleteOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeleteOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_accVar = 0;
  static constexpr int odsIndex_bounds = 1;
  static constexpr int odsIndex_asyncOperands = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.delete");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getAccVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeleteOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeleteOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }

  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DeleteOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DetachOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DetachOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DetachOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.detach", odsAttrs.getContext());
  }

  DetachOpGenericAdaptorBase(DetachOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class DetachOpGenericAdaptor : public detail::DetachOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DetachOpGenericAdaptorBase;
  static constexpr int odsIndex_accVar = 0;
  static constexpr int odsIndex_bounds = 1;
  static constexpr int odsIndex_asyncOperands = 2;
public:
  DetachOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DetachOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DetachOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DetachOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DetachOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DetachOpGenericAdaptor(RangeT values, const DetachOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DetachOp, typename = std::enable_if_t<std::is_same_v<LateInst, DetachOp>>>
  DetachOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAccVar() {
    return (*getODSOperands(0).begin());
  }

  RangeT getBounds() {
    return getODSOperands(1);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DetachOpAdaptor : public DetachOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DetachOpGenericAdaptor::DetachOpGenericAdaptor;
  DetachOpAdaptor(DetachOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DetachOp : public ::mlir::Op<DetachOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DetachOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DetachOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_accVar = 0;
  static constexpr int odsIndex_bounds = 1;
  static constexpr int odsIndex_asyncOperands = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.detach");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getAccVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value accVar, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DetachOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DetachOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }

  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DetachOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DevicePtrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class DevicePtrOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DevicePtrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.deviceptr", odsAttrs.getContext());
  }

  DevicePtrOpGenericAdaptorBase(DevicePtrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class DevicePtrOpGenericAdaptor : public detail::DevicePtrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DevicePtrOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  DevicePtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DevicePtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DevicePtrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DevicePtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DevicePtrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DevicePtrOpGenericAdaptor(RangeT values, const DevicePtrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DevicePtrOp, typename = std::enable_if_t<std::is_same_v<LateInst, DevicePtrOp>>>
  DevicePtrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DevicePtrOpAdaptor : public DevicePtrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DevicePtrOpGenericAdaptor::DevicePtrOpGenericAdaptor;
  DevicePtrOpAdaptor(DevicePtrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DevicePtrOp : public ::mlir::Op<DevicePtrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DevicePtrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DevicePtrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.deviceptr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::DevicePtrOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::EnterDataOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class EnterDataOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncTy = ::mlir::UnitAttr;
    asyncTy async;

    auto getAsync() const {
      auto &propStorage = this->async;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAsync(const ::mlir::UnitAttr &propValue) {
      this->async = propValue;
    }
    using waitTy = ::mlir::UnitAttr;
    waitTy wait;

    auto getWait() const {
      auto &propStorage = this->wait;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setWait(const ::mlir::UnitAttr &propValue) {
      this->wait = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.async == this->async &&
        rhs.wait == this->wait &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EnterDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.enter_data", odsAttrs.getContext());
  }

  EnterDataOpGenericAdaptorBase(EnterDataOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getAsyncAttr();
  bool getAsync();
  ::mlir::UnitAttr getWaitAttr();
  bool getWait();
};
} // namespace detail
template <typename RangeT>
class EnterDataOpGenericAdaptor : public detail::EnterDataOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EnterDataOpGenericAdaptorBase;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_asyncOperand = 1;
  static constexpr int odsIndex_waitDevnum = 2;
  static constexpr int odsIndex_waitOperands = 3;
  static constexpr int odsIndex_dataClauseOperands = 4;
public:
  EnterDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EnterDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EnterDataOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EnterDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : EnterDataOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EnterDataOpGenericAdaptor(RangeT values, const EnterDataOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EnterDataOp, typename = std::enable_if_t<std::is_same_v<LateInst, EnterDataOp>>>
  EnterDataOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getAsyncOperand() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getWaitDevnum() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getWaitOperands() {
    return getODSOperands(3);
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EnterDataOpAdaptor : public EnterDataOpGenericAdaptor<::mlir::ValueRange> {
public:
  using EnterDataOpGenericAdaptor::EnterDataOpGenericAdaptor;
  EnterDataOpAdaptor(EnterDataOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EnterDataOp : public ::mlir::Op<EnterDataOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EnterDataOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EnterDataOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_asyncOperand = 1;
  static constexpr int odsIndex_waitDevnum = 2;
  static constexpr int odsIndex_waitOperands = 3;
  static constexpr int odsIndex_dataClauseOperands = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("async"), ::llvm::StringRef("wait"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getWaitAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getWaitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.enter_data");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getAsyncOperand() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWaitDevnum() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getWaitOperands() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(4);
  }

  ::mlir::MutableOperandRange getIfCondMutable();
  ::mlir::MutableOperandRange getAsyncOperandMutable();
  ::mlir::MutableOperandRange getWaitDevnumMutable();
  ::mlir::MutableOperandRange getWaitOperandsMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getAsyncAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().async);
  }

  bool getAsync();
  ::mlir::UnitAttr getWaitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().wait);
  }

  bool getWait();
  void setAsyncAttr(::mlir::UnitAttr attr) {
    getProperties().async = attr;
  }

  void setAsync(bool attrValue);
  void setWaitAttr(::mlir::UnitAttr attr) {
    getProperties().wait = attr;
  }

  void setWait(bool attrValue);
  ::mlir::Attribute removeAsyncAttr() {
      auto attr = getProperties().async;
      getProperties().async = {};
      return attr;
  }

  ::mlir::Attribute removeWaitAttr() {
      auto attr = getProperties().wait;
      getProperties().wait = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands);
  static EnterDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnterDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EnterDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnterDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EnterDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// The number of data operands.
  unsigned getNumDataOperands();

  /// The i-th data operand passed.
  Value getDataOperand(unsigned i);

  /// Add an entry to the 'async-only' attribute (clause spelled without
  /// arguments). DeviceType array is supplied even though it should always be
  /// empty, so this can mirror other versions of this function.
  void addAsyncOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add a value to the 'async'. DeviceType array is supplied even though it
  /// should always be empty, so this can mirror other versions of this
  /// function.
  void addAsyncOperand(MLIRContext *, mlir::Value,
                       llvm::ArrayRef<DeviceType>);
  /// Add an entry to the 'wait-only' attribute (clause spelled without
  /// arguments). DeviceType array is supplied even though it should always be
  /// empty, so this can mirror other versions of this function.
  void addWaitOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry  to the 'wait'. DeviceType array is supplied
  /// even though it should always be empty, so this can mirror other versions
  /// of this function.
  void addWaitOperands(MLIRContext *, bool hasDevnum, mlir::ValueRange,
                       llvm::ArrayRef<DeviceType>);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::EnterDataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ExitDataOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExitDataOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncTy = ::mlir::UnitAttr;
    asyncTy async;

    auto getAsync() const {
      auto &propStorage = this->async;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAsync(const ::mlir::UnitAttr &propValue) {
      this->async = propValue;
    }
    using finalizeTy = ::mlir::UnitAttr;
    finalizeTy finalize;

    auto getFinalize() const {
      auto &propStorage = this->finalize;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setFinalize(const ::mlir::UnitAttr &propValue) {
      this->finalize = propValue;
    }
    using waitTy = ::mlir::UnitAttr;
    waitTy wait;

    auto getWait() const {
      auto &propStorage = this->wait;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setWait(const ::mlir::UnitAttr &propValue) {
      this->wait = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.async == this->async &&
        rhs.finalize == this->finalize &&
        rhs.wait == this->wait &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExitDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.exit_data", odsAttrs.getContext());
  }

  ExitDataOpGenericAdaptorBase(ExitDataOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getAsyncAttr();
  bool getAsync();
  ::mlir::UnitAttr getWaitAttr();
  bool getWait();
  ::mlir::UnitAttr getFinalizeAttr();
  bool getFinalize();
};
} // namespace detail
template <typename RangeT>
class ExitDataOpGenericAdaptor : public detail::ExitDataOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExitDataOpGenericAdaptorBase;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_asyncOperand = 1;
  static constexpr int odsIndex_waitDevnum = 2;
  static constexpr int odsIndex_waitOperands = 3;
  static constexpr int odsIndex_dataClauseOperands = 4;
public:
  ExitDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExitDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExitDataOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExitDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ExitDataOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExitDataOpGenericAdaptor(RangeT values, const ExitDataOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExitDataOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExitDataOp>>>
  ExitDataOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getAsyncOperand() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getWaitDevnum() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getWaitOperands() {
    return getODSOperands(3);
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExitDataOpAdaptor : public ExitDataOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExitDataOpGenericAdaptor::ExitDataOpGenericAdaptor;
  ExitDataOpAdaptor(ExitDataOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExitDataOp : public ::mlir::Op<ExitDataOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExitDataOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExitDataOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_asyncOperand = 1;
  static constexpr int odsIndex_waitDevnum = 2;
  static constexpr int odsIndex_waitOperands = 3;
  static constexpr int odsIndex_dataClauseOperands = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("async"), ::llvm::StringRef("finalize"), ::llvm::StringRef("wait"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFinalizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFinalizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getWaitAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getWaitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.exit_data");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getAsyncOperand() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWaitDevnum() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getWaitOperands() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(4);
  }

  ::mlir::MutableOperandRange getIfCondMutable();
  ::mlir::MutableOperandRange getAsyncOperandMutable();
  ::mlir::MutableOperandRange getWaitDevnumMutable();
  ::mlir::MutableOperandRange getWaitOperandsMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getAsyncAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().async);
  }

  bool getAsync();
  ::mlir::UnitAttr getWaitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().wait);
  }

  bool getWait();
  ::mlir::UnitAttr getFinalizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalize);
  }

  bool getFinalize();
  void setAsyncAttr(::mlir::UnitAttr attr) {
    getProperties().async = attr;
  }

  void setAsync(bool attrValue);
  void setWaitAttr(::mlir::UnitAttr attr) {
    getProperties().wait = attr;
  }

  void setWait(bool attrValue);
  void setFinalizeAttr(::mlir::UnitAttr attr) {
    getProperties().finalize = attr;
  }

  void setFinalize(bool attrValue);
  ::mlir::Attribute removeAsyncAttr() {
      auto attr = getProperties().async;
      getProperties().async = {};
      return attr;
  }

  ::mlir::Attribute removeWaitAttr() {
      auto attr = getProperties().wait;
      getProperties().wait = {};
      return attr;
  }

  ::mlir::Attribute removeFinalizeAttr() {
      auto attr = getProperties().finalize;
      getProperties().finalize = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize);
  static ExitDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize);
  static ExitDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize);
  static ExitDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize);
  static ExitDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize = false);
  static ExitDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize = false);
  static ExitDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize = false);
  static ExitDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize = false);
  static ExitDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExitDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExitDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExitDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExitDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// The number of data operands.
  unsigned getNumDataOperands();

  /// The i-th data operand passed.
  Value getDataOperand(unsigned i);

  /// Add an entry to the 'async-only' attribute (clause spelled without
  /// arguments). DeviceType array is supplied even though it should always be
  /// empty, so this can mirror other versions of this function.
  void addAsyncOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add a value to the 'async'. DeviceType array is supplied even though it
  /// should always be empty, so this can mirror other versions of this
  /// function.
  void addAsyncOperand(MLIRContext *, mlir::Value,
                       llvm::ArrayRef<DeviceType>);

  /// Add an entry to the 'wait-only' attribute (clause spelled without
  /// arguments). DeviceType array is supplied even though it should always be
  /// empty, so this can mirror other versions of this function.
  void addWaitOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry  to the 'wait'. DeviceType array is supplied
  /// even though it should always be empty, so this can mirror other versions
  /// of this function.
  void addWaitOperands(MLIRContext *, bool hasDevnum, mlir::ValueRange,
                       llvm::ArrayRef<DeviceType>);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::ExitDataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::FirstprivateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class FirstprivateOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FirstprivateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.firstprivate", odsAttrs.getContext());
  }

  FirstprivateOpGenericAdaptorBase(FirstprivateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class FirstprivateOpGenericAdaptor : public detail::FirstprivateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FirstprivateOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  FirstprivateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FirstprivateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FirstprivateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FirstprivateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : FirstprivateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FirstprivateOpGenericAdaptor(RangeT values, const FirstprivateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FirstprivateOp, typename = std::enable_if_t<std::is_same_v<LateInst, FirstprivateOp>>>
  FirstprivateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FirstprivateOpAdaptor : public FirstprivateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FirstprivateOpGenericAdaptor::FirstprivateOpGenericAdaptor;
  FirstprivateOpAdaptor(FirstprivateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FirstprivateOp : public ::mlir::Op<FirstprivateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FirstprivateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FirstprivateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.firstprivate");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FirstprivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FirstprivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::FirstprivateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::FirstprivateRecipeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class FirstprivateRecipeOpGenericAdaptorBase {
public:
  struct Properties {
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using typeTy = ::mlir::TypeAttr;
    typeTy type;

    auto getType() const {
      auto &propStorage = this->type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setType(const ::mlir::TypeAttr &propValue) {
      this->type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.sym_name == this->sym_name &&
        rhs.type == this->type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FirstprivateRecipeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.firstprivate.recipe", odsAttrs.getContext());
  }

  FirstprivateRecipeOpGenericAdaptorBase(FirstprivateRecipeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
    return attr;
  }

  ::mlir::Type getType();
  ::mlir::Region &getInitRegion() {
    return *odsRegions[0];
  }

  ::mlir::Region &getCopyRegion() {
    return *odsRegions[1];
  }

  ::mlir::Region &getDestroyRegion() {
    return *odsRegions[2];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class FirstprivateRecipeOpGenericAdaptor : public detail::FirstprivateRecipeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FirstprivateRecipeOpGenericAdaptorBase;
public:
  FirstprivateRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FirstprivateRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FirstprivateRecipeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FirstprivateRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FirstprivateRecipeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FirstprivateRecipeOpGenericAdaptor(RangeT values, const FirstprivateRecipeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FirstprivateRecipeOp, typename = std::enable_if_t<std::is_same_v<LateInst, FirstprivateRecipeOp>>>
  FirstprivateRecipeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FirstprivateRecipeOpAdaptor : public FirstprivateRecipeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FirstprivateRecipeOpGenericAdaptor::FirstprivateRecipeOpGenericAdaptor;
  FirstprivateRecipeOpAdaptor(FirstprivateRecipeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FirstprivateRecipeOp : public ::mlir::Op<FirstprivateRecipeOp, ::mlir::OpTrait::NRegions<3>::Impl, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait, ::mlir::accomp::RecipeInterface::Trait, ::mlir::OpTrait::AutomaticAllocationScope> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FirstprivateRecipeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FirstprivateRecipeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("sym_name"), ::llvm::StringRef("type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.firstprivate.recipe");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getInitRegion() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getCopyRegion() {
    return (*this)->getRegion(1);
  }

  ::mlir::Region &getDestroyRegion() {
    return (*this)->getRegion(2);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  }

  ::mlir::Type getType();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setTypeAttr(::mlir::TypeAttr attr) {
    getProperties().type = attr;
  }

  void setType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static FirstprivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static FirstprivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static FirstprivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static FirstprivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type);
  static FirstprivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::Type type);
  static FirstprivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::Type type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type);
  static FirstprivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type);
  static FirstprivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FirstprivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FirstprivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FirstprivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FirstprivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::FirstprivateRecipeOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GetDevicePtrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetDevicePtrOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetDevicePtrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.getdeviceptr", odsAttrs.getContext());
  }

  GetDevicePtrOpGenericAdaptorBase(GetDevicePtrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class GetDevicePtrOpGenericAdaptor : public detail::GetDevicePtrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetDevicePtrOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  GetDevicePtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetDevicePtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetDevicePtrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetDevicePtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : GetDevicePtrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetDevicePtrOpGenericAdaptor(RangeT values, const GetDevicePtrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetDevicePtrOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetDevicePtrOp>>>
  GetDevicePtrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetDevicePtrOpAdaptor : public GetDevicePtrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetDevicePtrOpGenericAdaptor::GetDevicePtrOpGenericAdaptor;
  GetDevicePtrOpAdaptor(GetDevicePtrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetDevicePtrOp : public ::mlir::Op<GetDevicePtrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetDevicePtrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetDevicePtrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.getdeviceptr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDevicePtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDevicePtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GetDevicePtrOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GetExtentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetExtentOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetExtentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.get_extent", odsAttrs.getContext());
  }

  GetExtentOpGenericAdaptorBase(GetExtentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class GetExtentOpGenericAdaptor : public detail::GetExtentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetExtentOpGenericAdaptorBase;
  static constexpr int odsIndex_bounds = 0;
public:
  GetExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetExtentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetExtentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetExtentOpGenericAdaptor(RangeT values, const GetExtentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetExtentOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetExtentOp>>>
  GetExtentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBounds() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetExtentOpAdaptor : public GetExtentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetExtentOpGenericAdaptor::GetExtentOpGenericAdaptor;
  GetExtentOpAdaptor(GetExtentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetExtentOp : public ::mlir::Op<GetExtentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetExtentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetExtentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_bounds = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.get_extent");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DataBoundsType> getBounds() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DataBoundsType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoundsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value bounds);
  static GetExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value bounds);
  static GetExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GetExtentOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GetLowerboundOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetLowerboundOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetLowerboundOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.get_lowerbound", odsAttrs.getContext());
  }

  GetLowerboundOpGenericAdaptorBase(GetLowerboundOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class GetLowerboundOpGenericAdaptor : public detail::GetLowerboundOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetLowerboundOpGenericAdaptorBase;
  static constexpr int odsIndex_bounds = 0;
public:
  GetLowerboundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetLowerboundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetLowerboundOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetLowerboundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetLowerboundOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetLowerboundOpGenericAdaptor(RangeT values, const GetLowerboundOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetLowerboundOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetLowerboundOp>>>
  GetLowerboundOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBounds() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetLowerboundOpAdaptor : public GetLowerboundOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetLowerboundOpGenericAdaptor::GetLowerboundOpGenericAdaptor;
  GetLowerboundOpAdaptor(GetLowerboundOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetLowerboundOp : public ::mlir::Op<GetLowerboundOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetLowerboundOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetLowerboundOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_bounds = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.get_lowerbound");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DataBoundsType> getBounds() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DataBoundsType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoundsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value bounds);
  static GetLowerboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value bounds);
  static GetLowerboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetLowerboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetLowerboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetLowerboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetLowerboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetLowerboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetLowerboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GetLowerboundOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GetStrideOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetStrideOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetStrideOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.get_stride", odsAttrs.getContext());
  }

  GetStrideOpGenericAdaptorBase(GetStrideOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class GetStrideOpGenericAdaptor : public detail::GetStrideOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetStrideOpGenericAdaptorBase;
  static constexpr int odsIndex_bounds = 0;
public:
  GetStrideOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetStrideOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetStrideOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetStrideOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetStrideOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetStrideOpGenericAdaptor(RangeT values, const GetStrideOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetStrideOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetStrideOp>>>
  GetStrideOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBounds() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetStrideOpAdaptor : public GetStrideOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetStrideOpGenericAdaptor::GetStrideOpGenericAdaptor;
  GetStrideOpAdaptor(GetStrideOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetStrideOp : public ::mlir::Op<GetStrideOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetStrideOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetStrideOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_bounds = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.get_stride");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DataBoundsType> getBounds() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DataBoundsType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoundsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value bounds);
  static GetStrideOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value bounds);
  static GetStrideOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetStrideOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetStrideOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetStrideOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetStrideOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetStrideOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetStrideOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GetStrideOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GetUpperboundOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GetUpperboundOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetUpperboundOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.get_upperbound", odsAttrs.getContext());
  }

  GetUpperboundOpGenericAdaptorBase(GetUpperboundOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class GetUpperboundOpGenericAdaptor : public detail::GetUpperboundOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetUpperboundOpGenericAdaptorBase;
  static constexpr int odsIndex_bounds = 0;
public:
  GetUpperboundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetUpperboundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetUpperboundOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetUpperboundOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetUpperboundOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetUpperboundOpGenericAdaptor(RangeT values, const GetUpperboundOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetUpperboundOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetUpperboundOp>>>
  GetUpperboundOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBounds() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetUpperboundOpAdaptor : public GetUpperboundOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetUpperboundOpGenericAdaptor::GetUpperboundOpGenericAdaptor;
  GetUpperboundOpAdaptor(GetUpperboundOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetUpperboundOp : public ::mlir::Op<GetUpperboundOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetUpperboundOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetUpperboundOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_bounds = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.get_upperbound");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::acc::DataBoundsType> getBounds() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DataBoundsType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoundsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value bounds);
  static GetUpperboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value bounds);
  static GetUpperboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetUpperboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static GetUpperboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value bounds);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetUpperboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetUpperboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetUpperboundOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetUpperboundOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GetUpperboundOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GlobalConstructorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GlobalConstructorOpGenericAdaptorBase {
public:
  struct Properties {
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.sym_name == this->sym_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalConstructorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.global_ctor", odsAttrs.getContext());
  }

  GlobalConstructorOpGenericAdaptorBase(GlobalConstructorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class GlobalConstructorOpGenericAdaptor : public detail::GlobalConstructorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalConstructorOpGenericAdaptorBase;
public:
  GlobalConstructorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalConstructorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalConstructorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalConstructorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalConstructorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalConstructorOpGenericAdaptor(RangeT values, const GlobalConstructorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalConstructorOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalConstructorOp>>>
  GlobalConstructorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalConstructorOpAdaptor : public GlobalConstructorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalConstructorOpGenericAdaptor::GlobalConstructorOpGenericAdaptor;
  GlobalConstructorOpAdaptor(GlobalConstructorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalConstructorOp : public ::mlir::Op<GlobalConstructorOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalConstructorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalConstructorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("sym_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.global_ctor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name);
  static GlobalConstructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name);
  static GlobalConstructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name);
  static GlobalConstructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name);
  static GlobalConstructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name);
  static GlobalConstructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name);
  static GlobalConstructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name);
  static GlobalConstructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name);
  static GlobalConstructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalConstructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalConstructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalConstructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalConstructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GlobalConstructorOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GlobalDestructorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GlobalDestructorOpGenericAdaptorBase {
public:
  struct Properties {
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.sym_name == this->sym_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalDestructorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.global_dtor", odsAttrs.getContext());
  }

  GlobalDestructorOpGenericAdaptorBase(GlobalDestructorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class GlobalDestructorOpGenericAdaptor : public detail::GlobalDestructorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalDestructorOpGenericAdaptorBase;
public:
  GlobalDestructorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalDestructorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalDestructorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalDestructorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalDestructorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalDestructorOpGenericAdaptor(RangeT values, const GlobalDestructorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalDestructorOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalDestructorOp>>>
  GlobalDestructorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalDestructorOpAdaptor : public GlobalDestructorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalDestructorOpGenericAdaptor::GlobalDestructorOpGenericAdaptor;
  GlobalDestructorOpAdaptor(GlobalDestructorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalDestructorOp : public ::mlir::Op<GlobalDestructorOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalDestructorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalDestructorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("sym_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.global_dtor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name);
  static GlobalDestructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name);
  static GlobalDestructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name);
  static GlobalDestructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name);
  static GlobalDestructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name);
  static GlobalDestructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name);
  static GlobalDestructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name);
  static GlobalDestructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name);
  static GlobalDestructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalDestructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalDestructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalDestructorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalDestructorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::GlobalDestructorOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::HostDataOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class HostDataOpGenericAdaptorBase {
public:
  struct Properties {
    using ifPresentTy = ::mlir::UnitAttr;
    ifPresentTy ifPresent;

    auto getIfPresent() const {
      auto &propStorage = this->ifPresent;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setIfPresent(const ::mlir::UnitAttr &propValue) {
      this->ifPresent = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.ifPresent == this->ifPresent &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  HostDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.host_data", odsAttrs.getContext());
  }

  HostDataOpGenericAdaptorBase(HostDataOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getIfPresentAttr();
  bool getIfPresent();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class HostDataOpGenericAdaptor : public detail::HostDataOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::HostDataOpGenericAdaptorBase;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_dataClauseOperands = 1;
public:
  HostDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  HostDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : HostDataOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  HostDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : HostDataOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  HostDataOpGenericAdaptor(RangeT values, const HostDataOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = HostDataOp, typename = std::enable_if_t<std::is_same_v<LateInst, HostDataOp>>>
  HostDataOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class HostDataOpAdaptor : public HostDataOpGenericAdaptor<::mlir::ValueRange> {
public:
  using HostDataOpGenericAdaptor::HostDataOpGenericAdaptor;
  HostDataOpAdaptor(HostDataOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class HostDataOp : public ::mlir::Op<HostDataOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = HostDataOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = HostDataOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ifCond = 0;
  static constexpr int odsIndex_dataClauseOperands = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("ifPresent"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIfPresentAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIfPresentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.host_data");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getIfCondMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getIfPresentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().ifPresent);
  }

  bool getIfPresent();
  void setIfPresentAttr(::mlir::UnitAttr attr) {
    getProperties().ifPresent = attr;
  }

  void setIfPresent(bool attrValue);
  ::mlir::Attribute removeIfPresentAttr() {
      auto attr = getProperties().ifPresent;
      getProperties().ifPresent = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent);
  static HostDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent);
  static HostDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent);
  static HostDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent);
  static HostDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent = false);
  static HostDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent = false);
  static HostDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent = false);
  static HostDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent = false);
  static HostDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static HostDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static HostDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static HostDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static HostDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::HostDataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::InitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class InitOpGenericAdaptorBase {
public:
  struct Properties {
    using device_typesTy = ::mlir::ArrayAttr;
    device_typesTy device_types;

    auto getDeviceTypes() const {
      auto &propStorage = this->device_types;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setDeviceTypes(const ::mlir::ArrayAttr &propValue) {
      this->device_types = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.device_types == this->device_types &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.init", odsAttrs.getContext());
  }

  InitOpGenericAdaptorBase(InitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getDeviceTypesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().device_types);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getDeviceTypes();
};
} // namespace detail
template <typename RangeT>
class InitOpGenericAdaptor : public detail::InitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InitOpGenericAdaptorBase;
  static constexpr int odsIndex_deviceNum = 0;
  static constexpr int odsIndex_ifCond = 1;
public:
  InitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : InitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InitOpGenericAdaptor(RangeT values, const InitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InitOp, typename = std::enable_if_t<std::is_same_v<LateInst, InitOp>>>
  InitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getDeviceNum() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InitOpAdaptor : public InitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InitOpGenericAdaptor::InitOpGenericAdaptor;
  InitOpAdaptor(InitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InitOp : public ::mlir::Op<InitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_deviceNum = 0;
  static constexpr int odsIndex_ifCond = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("device_types"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDeviceTypesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDeviceTypesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.init");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getDeviceNum() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::MutableOperandRange getDeviceNumMutable();
  ::mlir::MutableOperandRange getIfCondMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getDeviceTypesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().device_types);
  }

  ::std::optional< ::mlir::ArrayAttr > getDeviceTypes();
  void setDeviceTypesAttr(::mlir::ArrayAttr attr) {
    getProperties().device_types = attr;
  }

  ::mlir::Attribute removeDeviceTypesAttr() {
      auto attr = getProperties().device_types;
      getProperties().device_types = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::ArrayAttr device_types, /*optional*/::mlir::Value deviceNum, /*optional*/::mlir::Value ifCond);
  static InitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::ArrayAttr device_types, /*optional*/::mlir::Value deviceNum, /*optional*/::mlir::Value ifCond);
  static InitOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::ArrayAttr device_types, /*optional*/::mlir::Value deviceNum, /*optional*/::mlir::Value ifCond);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::ArrayAttr device_types, /*optional*/::mlir::Value deviceNum, /*optional*/::mlir::Value ifCond);
  static InitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::ArrayAttr device_types, /*optional*/::mlir::Value deviceNum, /*optional*/::mlir::Value ifCond);
  static InitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::ArrayAttr device_types, /*optional*/::mlir::Value deviceNum, /*optional*/::mlir::Value ifCond);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Adds a device type to the list of device types for this directive.
  void addDeviceType(MLIRContext *, mlir::acc::DeviceType);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::InitOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::KernelsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class KernelsOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using combinedTy = ::mlir::UnitAttr;
    combinedTy combined;

    auto getCombined() const {
      auto &propStorage = this->combined;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCombined(const ::mlir::UnitAttr &propValue) {
      this->combined = propValue;
    }
    using defaultAttrTy = ::mlir::acc::ClauseDefaultValueAttr;
    defaultAttrTy defaultAttr;

    auto getDefaultAttr() const {
      auto &propStorage = this->defaultAttr;
      return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(propStorage);
    }
    void setDefaultAttr(const ::mlir::acc::ClauseDefaultValueAttr &propValue) {
      this->defaultAttr = propValue;
    }
    using hasWaitDevnumTy = ::mlir::ArrayAttr;
    hasWaitDevnumTy hasWaitDevnum;

    auto getHasWaitDevnum() const {
      auto &propStorage = this->hasWaitDevnum;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setHasWaitDevnum(const ::mlir::ArrayAttr &propValue) {
      this->hasWaitDevnum = propValue;
    }
    using numGangsDeviceTypeTy = ::mlir::ArrayAttr;
    numGangsDeviceTypeTy numGangsDeviceType;

    auto getNumGangsDeviceType() const {
      auto &propStorage = this->numGangsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNumGangsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->numGangsDeviceType = propValue;
    }
    using numGangsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    numGangsSegmentsTy numGangsSegments;

    auto getNumGangsSegments() const {
      auto &propStorage = this->numGangsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setNumGangsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->numGangsSegments = propValue;
    }
    using numWorkersDeviceTypeTy = ::mlir::ArrayAttr;
    numWorkersDeviceTypeTy numWorkersDeviceType;

    auto getNumWorkersDeviceType() const {
      auto &propStorage = this->numWorkersDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNumWorkersDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->numWorkersDeviceType = propValue;
    }
    using selfAttrTy = ::mlir::UnitAttr;
    selfAttrTy selfAttr;

    auto getSelfAttr() const {
      auto &propStorage = this->selfAttr;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setSelfAttr(const ::mlir::UnitAttr &propValue) {
      this->selfAttr = propValue;
    }
    using vectorLengthDeviceTypeTy = ::mlir::ArrayAttr;
    vectorLengthDeviceTypeTy vectorLengthDeviceType;

    auto getVectorLengthDeviceType() const {
      auto &propStorage = this->vectorLengthDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setVectorLengthDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->vectorLengthDeviceType = propValue;
    }
    using waitOnlyTy = ::mlir::ArrayAttr;
    waitOnlyTy waitOnly;

    auto getWaitOnly() const {
      auto &propStorage = this->waitOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWaitOnly(const ::mlir::ArrayAttr &propValue) {
      this->waitOnly = propValue;
    }
    using waitOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    waitOperandsDeviceTypeTy waitOperandsDeviceType;

    auto getWaitOperandsDeviceType() const {
      auto &propStorage = this->waitOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWaitOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->waitOperandsDeviceType = propValue;
    }
    using waitOperandsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    waitOperandsSegmentsTy waitOperandsSegments;

    auto getWaitOperandsSegments() const {
      auto &propStorage = this->waitOperandsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setWaitOperandsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->waitOperandsSegments = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 8>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.combined == this->combined &&
        rhs.defaultAttr == this->defaultAttr &&
        rhs.hasWaitDevnum == this->hasWaitDevnum &&
        rhs.numGangsDeviceType == this->numGangsDeviceType &&
        rhs.numGangsSegments == this->numGangsSegments &&
        rhs.numWorkersDeviceType == this->numWorkersDeviceType &&
        rhs.selfAttr == this->selfAttr &&
        rhs.vectorLengthDeviceType == this->vectorLengthDeviceType &&
        rhs.waitOnly == this->waitOnly &&
        rhs.waitOperandsDeviceType == this->waitOperandsDeviceType &&
        rhs.waitOperandsSegments == this->waitOperandsSegments &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  KernelsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.kernels", odsAttrs.getContext());
  }

  KernelsOpGenericAdaptorBase(KernelsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::DenseI32ArrayAttr getWaitOperandsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().waitOperandsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWaitOperandsSegments();
  ::mlir::ArrayAttr getWaitOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOperandsDeviceType();
  ::mlir::ArrayAttr getHasWaitDevnumAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().hasWaitDevnum);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getHasWaitDevnum();
  ::mlir::ArrayAttr getWaitOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOnly();
  ::mlir::DenseI32ArrayAttr getNumGangsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().numGangsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getNumGangsSegments();
  ::mlir::ArrayAttr getNumGangsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numGangsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNumGangsDeviceType();
  ::mlir::ArrayAttr getNumWorkersDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numWorkersDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNumWorkersDeviceType();
  ::mlir::ArrayAttr getVectorLengthDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vectorLengthDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getVectorLengthDeviceType();
  ::mlir::UnitAttr getSelfAttrAttr();
  bool getSelfAttr();
  ::mlir::acc::ClauseDefaultValueAttr getDefaultAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
    return attr;
  }

  ::std::optional<::mlir::acc::ClauseDefaultValue> getDefaultAttr();
  ::mlir::UnitAttr getCombinedAttr();
  bool getCombined();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class KernelsOpGenericAdaptor : public detail::KernelsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::KernelsOpGenericAdaptorBase;
  static constexpr int odsIndex_asyncOperands = 0;
  static constexpr int odsIndex_waitOperands = 1;
  static constexpr int odsIndex_numGangs = 2;
  static constexpr int odsIndex_numWorkers = 3;
  static constexpr int odsIndex_vectorLength = 4;
  static constexpr int odsIndex_ifCond = 5;
  static constexpr int odsIndex_selfCond = 6;
  static constexpr int odsIndex_dataClauseOperands = 7;
public:
  KernelsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  KernelsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : KernelsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  KernelsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : KernelsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  KernelsOpGenericAdaptor(RangeT values, const KernelsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = KernelsOp, typename = std::enable_if_t<std::is_same_v<LateInst, KernelsOp>>>
  KernelsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getAsyncOperands() {
    return getODSOperands(0);
  }

  RangeT getWaitOperands() {
    return getODSOperands(1);
  }

  RangeT getNumGangs() {
    return getODSOperands(2);
  }

  RangeT getNumWorkers() {
    return getODSOperands(3);
  }

  RangeT getVectorLength() {
    return getODSOperands(4);
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSelfCond() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(7);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class KernelsOpAdaptor : public KernelsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using KernelsOpGenericAdaptor::KernelsOpGenericAdaptor;
  KernelsOpAdaptor(KernelsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class KernelsOp : public ::mlir::Op<KernelsOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::AutomaticAllocationScope, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::acc::ComputeRegionOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = KernelsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = KernelsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_asyncOperands = 0;
  static constexpr int odsIndex_waitOperands = 1;
  static constexpr int odsIndex_numGangs = 2;
  static constexpr int odsIndex_numWorkers = 3;
  static constexpr int odsIndex_vectorLength = 4;
  static constexpr int odsIndex_ifCond = 5;
  static constexpr int odsIndex_selfCond = 6;
  static constexpr int odsIndex_dataClauseOperands = 7;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("combined"), ::llvm::StringRef("defaultAttr"), ::llvm::StringRef("hasWaitDevnum"), ::llvm::StringRef("numGangsDeviceType"), ::llvm::StringRef("numGangsSegments"), ::llvm::StringRef("numWorkersDeviceType"), ::llvm::StringRef("selfAttr"), ::llvm::StringRef("vectorLengthDeviceType"), ::llvm::StringRef("waitOnly"), ::llvm::StringRef("waitOperandsDeviceType"), ::llvm::StringRef("waitOperandsSegments"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCombinedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCombinedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getDefaultAttrAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getDefaultAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getHasWaitDevnumAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getHasWaitDevnumAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNumGangsDeviceTypeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNumGangsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getNumGangsSegmentsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getNumGangsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getNumWorkersDeviceTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getNumWorkersDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getSelfAttrAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getSelfAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getVectorLengthDeviceTypeAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getVectorLengthDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getWaitOnlyAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getWaitOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getWaitOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getWaitOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getWaitOperandsSegmentsAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getWaitOperandsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.kernels");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getWaitOperands() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getNumGangs() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getNumWorkers() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getVectorLength() {
    return getODSOperands(4);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSelfCond() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(7);
  }

  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  ::mlir::MutableOperandRange getWaitOperandsMutable();
  ::mlir::MutableOperandRange getNumGangsMutable();
  ::mlir::MutableOperandRange getNumWorkersMutable();
  ::mlir::MutableOperandRange getVectorLengthMutable();
  ::mlir::MutableOperandRange getIfCondMutable();
  ::mlir::MutableOperandRange getSelfCondMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::DenseI32ArrayAttr getWaitOperandsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().waitOperandsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWaitOperandsSegments();
  ::mlir::ArrayAttr getWaitOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOperandsDeviceType();
  ::mlir::ArrayAttr getHasWaitDevnumAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().hasWaitDevnum);
  }

  ::std::optional< ::mlir::ArrayAttr > getHasWaitDevnum();
  ::mlir::ArrayAttr getWaitOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOnly();
  ::mlir::DenseI32ArrayAttr getNumGangsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().numGangsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getNumGangsSegments();
  ::mlir::ArrayAttr getNumGangsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numGangsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getNumGangsDeviceType();
  ::mlir::ArrayAttr getNumWorkersDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numWorkersDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getNumWorkersDeviceType();
  ::mlir::ArrayAttr getVectorLengthDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vectorLengthDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getVectorLengthDeviceType();
  ::mlir::UnitAttr getSelfAttrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
  }

  bool getSelfAttr();
  ::mlir::acc::ClauseDefaultValueAttr getDefaultAttrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  }

  ::std::optional<::mlir::acc::ClauseDefaultValue> getDefaultAttr();
  ::mlir::UnitAttr getCombinedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().combined);
  }

  bool getCombined();
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setWaitOperandsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().waitOperandsSegments = attr;
  }

  void setWaitOperandsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setWaitOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().waitOperandsDeviceType = attr;
  }

  void setHasWaitDevnumAttr(::mlir::ArrayAttr attr) {
    getProperties().hasWaitDevnum = attr;
  }

  void setWaitOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().waitOnly = attr;
  }

  void setNumGangsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().numGangsSegments = attr;
  }

  void setNumGangsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setNumGangsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().numGangsDeviceType = attr;
  }

  void setNumWorkersDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().numWorkersDeviceType = attr;
  }

  void setVectorLengthDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().vectorLengthDeviceType = attr;
  }

  void setSelfAttrAttr(::mlir::UnitAttr attr) {
    getProperties().selfAttr = attr;
  }

  void setSelfAttr(bool attrValue);
  void setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
    getProperties().defaultAttr = attr;
  }

  void setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue);
  void setCombinedAttr(::mlir::UnitAttr attr) {
    getProperties().combined = attr;
  }

  void setCombined(bool attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOperandsSegmentsAttr() {
      auto attr = getProperties().waitOperandsSegments;
      getProperties().waitOperandsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOperandsDeviceTypeAttr() {
      auto attr = getProperties().waitOperandsDeviceType;
      getProperties().waitOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeHasWaitDevnumAttr() {
      auto attr = getProperties().hasWaitDevnum;
      getProperties().hasWaitDevnum = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOnlyAttr() {
      auto attr = getProperties().waitOnly;
      getProperties().waitOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNumGangsSegmentsAttr() {
      auto attr = getProperties().numGangsSegments;
      getProperties().numGangsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeNumGangsDeviceTypeAttr() {
      auto attr = getProperties().numGangsDeviceType;
      getProperties().numGangsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeNumWorkersDeviceTypeAttr() {
      auto attr = getProperties().numWorkersDeviceType;
      getProperties().numWorkersDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeVectorLengthDeviceTypeAttr() {
      auto attr = getProperties().vectorLengthDeviceType;
      getProperties().vectorLengthDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeSelfAttrAttr() {
      auto attr = getProperties().selfAttr;
      getProperties().selfAttr = {};
      return attr;
  }

  ::mlir::Attribute removeDefaultAttrAttr() {
      auto attr = getProperties().defaultAttr;
      getProperties().defaultAttr = {};
      return attr;
  }

  ::mlir::Attribute removeCombinedAttr() {
      auto attr = getProperties().combined;
      getProperties().combined = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static KernelsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static KernelsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static KernelsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static KernelsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static KernelsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static KernelsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static KernelsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static KernelsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KernelsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KernelsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KernelsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KernelsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 13 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// The number of data operands.
  unsigned getNumDataOperands();

  /// The i-th data operand passed.
  Value getDataOperand(unsigned i);

  /// Used to retrieve the block inside the op's region.
  Block &getBody() { return getRegion().front(); }

  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly();
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType);
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue();
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType);

  /// Return the value of the num_workers clause if present.
  mlir::Value getNumWorkersValue();
  /// Return the value of the num_workers clause for the given device_type if
  /// present.
  mlir::Value getNumWorkersValue(mlir::acc::DeviceType deviceType);

  /// Return the value of the vector_length clause if present.
  mlir::Value getVectorLengthValue();
  /// Return the value of the vector_length clause for the given device_type 
  /// if present.
  mlir::Value getVectorLengthValue(mlir::acc::DeviceType deviceType);

  /// Return the values of the num_gangs clause if present.
  mlir::Operation::operand_range getNumGangsValues();
  /// Return the values of the num_gangs clause for the given device_type if
  /// present.
  mlir::Operation::operand_range
  getNumGangsValues(mlir::acc::DeviceType deviceType);

  /// Return true if the op has the wait attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasWaitOnly();
  /// Return true if the op has the wait attribute for the given device_type.
  bool hasWaitOnly(mlir::acc::DeviceType deviceType);
  /// Return the values of the wait clause if present.
  mlir::Operation::operand_range getWaitValues();
  /// Return the values of the wait clause for the given device_type if
  /// present.
  mlir::Operation::operand_range
  getWaitValues(mlir::acc::DeviceType deviceType);
  /// Return the wait devnum value clause if present;
  mlir::Value getWaitDevnum();
  /// Return the wait devnum value clause for the given device_type if
  /// present.
  mlir::Value getWaitDevnum(mlir::acc::DeviceType deviceType);
  static mlir::acc::Construct getConstructId() {
    return mlir::acc::Construct::acc_construct_kernels;
  }
  /// Add a value to 'num_workers' with the current list of device types.
  void addNumWorkersOperand(MLIRContext *, mlir::Value,
                            llvm::ArrayRef<DeviceType>);
  /// Add a value to 'vector_length' with the current list of device types.
  void addVectorLengthOperand(MLIRContext *, mlir::Value,
                              llvm::ArrayRef<DeviceType>);
  /// Add an entry to the 'async-only' attribute (clause spelled without
  /// arguments) for each of the additional device types (or a none if it is
  /// empty).
  void addAsyncOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add a value to the 'async' with the current list of device types.
  void addAsyncOperand(MLIRContext *, mlir::Value,
                       llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry to the 'num_gangs' with the current list of
  /// device types.
  void addNumGangsOperands(MLIRContext *, mlir::ValueRange,
                           llvm::ArrayRef<DeviceType>);
  /// Add an entry to the 'wait-only' attribute (clause spelled without
  /// arguments) for each of the additional device types (or a none if it is
  /// empty).
  void addWaitOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry  to the 'wait' with the current list of device
  /// types.
  void addWaitOperands(MLIRContext *, bool hasDevnum, mlir::ValueRange,
                       llvm::ArrayRef<DeviceType>);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::KernelsOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::LoopOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class LoopOpGenericAdaptorBase {
public:
  struct Properties {
    using auto_Ty = ::mlir::ArrayAttr;
    auto_Ty auto_;

    auto getAuto_() const {
      auto &propStorage = this->auto_;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAuto_(const ::mlir::ArrayAttr &propValue) {
      this->auto_ = propValue;
    }
    using collapseTy = ::mlir::ArrayAttr;
    collapseTy collapse;

    auto getCollapse() const {
      auto &propStorage = this->collapse;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setCollapse(const ::mlir::ArrayAttr &propValue) {
      this->collapse = propValue;
    }
    using collapseDeviceTypeTy = ::mlir::ArrayAttr;
    collapseDeviceTypeTy collapseDeviceType;

    auto getCollapseDeviceType() const {
      auto &propStorage = this->collapseDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setCollapseDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->collapseDeviceType = propValue;
    }
    using combinedTy = ::mlir::acc::CombinedConstructsTypeAttr;
    combinedTy combined;

    auto getCombined() const {
      auto &propStorage = this->combined;
      return ::llvm::dyn_cast_or_null<::mlir::acc::CombinedConstructsTypeAttr>(propStorage);
    }
    void setCombined(const ::mlir::acc::CombinedConstructsTypeAttr &propValue) {
      this->combined = propValue;
    }
    using firstprivatizationRecipesTy = ::mlir::ArrayAttr;
    firstprivatizationRecipesTy firstprivatizationRecipes;

    auto getFirstprivatizationRecipes() const {
      auto &propStorage = this->firstprivatizationRecipes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setFirstprivatizationRecipes(const ::mlir::ArrayAttr &propValue) {
      this->firstprivatizationRecipes = propValue;
    }
    using gangTy = ::mlir::ArrayAttr;
    gangTy gang;

    auto getGang() const {
      auto &propStorage = this->gang;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setGang(const ::mlir::ArrayAttr &propValue) {
      this->gang = propValue;
    }
    using gangOperandsArgTypeTy = ::mlir::ArrayAttr;
    gangOperandsArgTypeTy gangOperandsArgType;

    auto getGangOperandsArgType() const {
      auto &propStorage = this->gangOperandsArgType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setGangOperandsArgType(const ::mlir::ArrayAttr &propValue) {
      this->gangOperandsArgType = propValue;
    }
    using gangOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    gangOperandsDeviceTypeTy gangOperandsDeviceType;

    auto getGangOperandsDeviceType() const {
      auto &propStorage = this->gangOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setGangOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->gangOperandsDeviceType = propValue;
    }
    using gangOperandsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    gangOperandsSegmentsTy gangOperandsSegments;

    auto getGangOperandsSegments() const {
      auto &propStorage = this->gangOperandsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setGangOperandsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->gangOperandsSegments = propValue;
    }
    using inclusiveUpperboundTy = ::mlir::DenseBoolArrayAttr;
    inclusiveUpperboundTy inclusiveUpperbound;

    auto getInclusiveUpperbound() const {
      auto &propStorage = this->inclusiveUpperbound;
      return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(propStorage);
    }
    void setInclusiveUpperbound(const ::mlir::DenseBoolArrayAttr &propValue) {
      this->inclusiveUpperbound = propValue;
    }
    using independentTy = ::mlir::ArrayAttr;
    independentTy independent;

    auto getIndependent() const {
      auto &propStorage = this->independent;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setIndependent(const ::mlir::ArrayAttr &propValue) {
      this->independent = propValue;
    }
    using privatizationRecipesTy = ::mlir::ArrayAttr;
    privatizationRecipesTy privatizationRecipes;

    auto getPrivatizationRecipes() const {
      auto &propStorage = this->privatizationRecipes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPrivatizationRecipes(const ::mlir::ArrayAttr &propValue) {
      this->privatizationRecipes = propValue;
    }
    using reductionRecipesTy = ::mlir::ArrayAttr;
    reductionRecipesTy reductionRecipes;

    auto getReductionRecipes() const {
      auto &propStorage = this->reductionRecipes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setReductionRecipes(const ::mlir::ArrayAttr &propValue) {
      this->reductionRecipes = propValue;
    }
    using seqTy = ::mlir::ArrayAttr;
    seqTy seq;

    auto getSeq() const {
      auto &propStorage = this->seq;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setSeq(const ::mlir::ArrayAttr &propValue) {
      this->seq = propValue;
    }
    using tileOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    tileOperandsDeviceTypeTy tileOperandsDeviceType;

    auto getTileOperandsDeviceType() const {
      auto &propStorage = this->tileOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTileOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->tileOperandsDeviceType = propValue;
    }
    using tileOperandsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    tileOperandsSegmentsTy tileOperandsSegments;

    auto getTileOperandsSegments() const {
      auto &propStorage = this->tileOperandsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setTileOperandsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->tileOperandsSegments = propValue;
    }
    using vectorTy = ::mlir::ArrayAttr;
    vectorTy vector;

    auto getVector() const {
      auto &propStorage = this->vector;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setVector(const ::mlir::ArrayAttr &propValue) {
      this->vector = propValue;
    }
    using vectorOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    vectorOperandsDeviceTypeTy vectorOperandsDeviceType;

    auto getVectorOperandsDeviceType() const {
      auto &propStorage = this->vectorOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setVectorOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->vectorOperandsDeviceType = propValue;
    }
    using workerTy = ::mlir::ArrayAttr;
    workerTy worker;

    auto getWorker() const {
      auto &propStorage = this->worker;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWorker(const ::mlir::ArrayAttr &propValue) {
      this->worker = propValue;
    }
    using workerNumOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    workerNumOperandsDeviceTypeTy workerNumOperandsDeviceType;

    auto getWorkerNumOperandsDeviceType() const {
      auto &propStorage = this->workerNumOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWorkerNumOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->workerNumOperandsDeviceType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 11>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.auto_ == this->auto_ &&
        rhs.collapse == this->collapse &&
        rhs.collapseDeviceType == this->collapseDeviceType &&
        rhs.combined == this->combined &&
        rhs.firstprivatizationRecipes == this->firstprivatizationRecipes &&
        rhs.gang == this->gang &&
        rhs.gangOperandsArgType == this->gangOperandsArgType &&
        rhs.gangOperandsDeviceType == this->gangOperandsDeviceType &&
        rhs.gangOperandsSegments == this->gangOperandsSegments &&
        rhs.inclusiveUpperbound == this->inclusiveUpperbound &&
        rhs.independent == this->independent &&
        rhs.privatizationRecipes == this->privatizationRecipes &&
        rhs.reductionRecipes == this->reductionRecipes &&
        rhs.seq == this->seq &&
        rhs.tileOperandsDeviceType == this->tileOperandsDeviceType &&
        rhs.tileOperandsSegments == this->tileOperandsSegments &&
        rhs.vector == this->vector &&
        rhs.vectorOperandsDeviceType == this->vectorOperandsDeviceType &&
        rhs.worker == this->worker &&
        rhs.workerNumOperandsDeviceType == this->workerNumOperandsDeviceType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LoopOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.loop", odsAttrs.getContext());
  }

  LoopOpGenericAdaptorBase(LoopOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseBoolArrayAttr getInclusiveUpperboundAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().inclusiveUpperbound);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<bool>> getInclusiveUpperbound();
  ::mlir::ArrayAttr getCollapseAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().collapse);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getCollapse();
  ::mlir::ArrayAttr getCollapseDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().collapseDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getCollapseDeviceType();
  ::mlir::ArrayAttr getGangOperandsArgTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gangOperandsArgType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getGangOperandsArgType();
  ::mlir::DenseI32ArrayAttr getGangOperandsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().gangOperandsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getGangOperandsSegments();
  ::mlir::ArrayAttr getGangOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gangOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getGangOperandsDeviceType();
  ::mlir::ArrayAttr getWorkerNumOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().workerNumOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWorkerNumOperandsDeviceType();
  ::mlir::ArrayAttr getVectorOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vectorOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getVectorOperandsDeviceType();
  ::mlir::ArrayAttr getSeqAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().seq);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getSeq();
  ::mlir::ArrayAttr getIndependentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().independent);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getIndependent();
  ::mlir::ArrayAttr getAuto_Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().auto_);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAuto_();
  ::mlir::ArrayAttr getGangAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gang);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getGang();
  ::mlir::ArrayAttr getWorkerAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().worker);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWorker();
  ::mlir::ArrayAttr getVectorAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vector);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getVector();
  ::mlir::DenseI32ArrayAttr getTileOperandsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().tileOperandsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getTileOperandsSegments();
  ::mlir::ArrayAttr getTileOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tileOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTileOperandsDeviceType();
  ::mlir::ArrayAttr getPrivatizationRecipesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizationRecipes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPrivatizationRecipes();
  ::mlir::ArrayAttr getFirstprivatizationRecipesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizationRecipes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getFirstprivatizationRecipes();
  ::mlir::ArrayAttr getReductionRecipesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getReductionRecipes();
  ::mlir::acc::CombinedConstructsTypeAttr getCombinedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::CombinedConstructsTypeAttr>(getProperties().combined);
    return attr;
  }

  ::std::optional<::mlir::acc::CombinedConstructsType> getCombined();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class LoopOpGenericAdaptor : public detail::LoopOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LoopOpGenericAdaptorBase;
  static constexpr int odsIndex_lowerbound = 0;
  static constexpr int odsIndex_upperbound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_gangOperands = 3;
  static constexpr int odsIndex_workerNumOperands = 4;
  static constexpr int odsIndex_vectorOperands = 5;
  static constexpr int odsIndex_tileOperands = 6;
  static constexpr int odsIndex_cacheOperands = 7;
  static constexpr int odsIndex_privateOperands = 8;
  static constexpr int odsIndex_firstprivateOperands = 9;
  static constexpr int odsIndex_reductionOperands = 10;
public:
  LoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LoopOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : LoopOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LoopOpGenericAdaptor(RangeT values, const LoopOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LoopOp, typename = std::enable_if_t<std::is_same_v<LateInst, LoopOp>>>
  LoopOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getLowerbound() {
    return getODSOperands(0);
  }

  RangeT getUpperbound() {
    return getODSOperands(1);
  }

  RangeT getStep() {
    return getODSOperands(2);
  }

  RangeT getGangOperands() {
    return getODSOperands(3);
  }

  RangeT getWorkerNumOperands() {
    return getODSOperands(4);
  }

  RangeT getVectorOperands() {
    return getODSOperands(5);
  }

  RangeT getTileOperands() {
    return getODSOperands(6);
  }

  RangeT getCacheOperands() {
    return getODSOperands(7);
  }

  RangeT getPrivateOperands() {
    return getODSOperands(8);
  }

  RangeT getFirstprivateOperands() {
    return getODSOperands(9);
  }

  RangeT getReductionOperands() {
    return getODSOperands(10);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LoopOpAdaptor : public LoopOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LoopOpGenericAdaptor::LoopOpGenericAdaptor;
  LoopOpAdaptor(LoopOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LoopOp : public ::mlir::Op<LoopOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::AutomaticAllocationScope, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::acc::ComputeRegionOpInterface::Trait, ::mlir::LoopLikeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LoopOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LoopOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lowerbound = 0;
  static constexpr int odsIndex_upperbound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_gangOperands = 3;
  static constexpr int odsIndex_workerNumOperands = 4;
  static constexpr int odsIndex_vectorOperands = 5;
  static constexpr int odsIndex_tileOperands = 6;
  static constexpr int odsIndex_cacheOperands = 7;
  static constexpr int odsIndex_privateOperands = 8;
  static constexpr int odsIndex_firstprivateOperands = 9;
  static constexpr int odsIndex_reductionOperands = 10;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("auto_"), ::llvm::StringRef("collapse"), ::llvm::StringRef("collapseDeviceType"), ::llvm::StringRef("combined"), ::llvm::StringRef("firstprivatizationRecipes"), ::llvm::StringRef("gang"), ::llvm::StringRef("gangOperandsArgType"), ::llvm::StringRef("gangOperandsDeviceType"), ::llvm::StringRef("gangOperandsSegments"), ::llvm::StringRef("inclusiveUpperbound"), ::llvm::StringRef("independent"), ::llvm::StringRef("privatizationRecipes"), ::llvm::StringRef("reductionRecipes"), ::llvm::StringRef("seq"), ::llvm::StringRef("tileOperandsDeviceType"), ::llvm::StringRef("tileOperandsSegments"), ::llvm::StringRef("vector"), ::llvm::StringRef("vectorOperandsDeviceType"), ::llvm::StringRef("worker"), ::llvm::StringRef("workerNumOperandsDeviceType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAuto_AttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAuto_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getCollapseAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getCollapseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCollapseDeviceTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCollapseDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getCombinedAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getCombinedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getFirstprivatizationRecipesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getFirstprivatizationRecipesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getGangAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getGangAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getGangOperandsArgTypeAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getGangOperandsArgTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getGangOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getGangOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getGangOperandsSegmentsAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getGangOperandsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getInclusiveUpperboundAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getInclusiveUpperboundAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getIndependentAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getIndependentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getPrivatizationRecipesAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getPrivatizationRecipesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getReductionRecipesAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getReductionRecipesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getSeqAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getSeqAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getTileOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getTileOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getTileOperandsSegmentsAttrName() {
    return getAttributeNameForIndex(15);
  }

  static ::mlir::StringAttr getTileOperandsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 15);
  }

  ::mlir::StringAttr getVectorAttrName() {
    return getAttributeNameForIndex(16);
  }

  static ::mlir::StringAttr getVectorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 16);
  }

  ::mlir::StringAttr getVectorOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(17);
  }

  static ::mlir::StringAttr getVectorOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 17);
  }

  ::mlir::StringAttr getWorkerAttrName() {
    return getAttributeNameForIndex(18);
  }

  static ::mlir::StringAttr getWorkerAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 18);
  }

  ::mlir::StringAttr getWorkerNumOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(19);
  }

  static ::mlir::StringAttr getWorkerNumOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 19);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.loop");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getLowerbound() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getUpperbound() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getStep() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getGangOperands() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getWorkerNumOperands() {
    return getODSOperands(4);
  }

  ::mlir::Operation::operand_range getVectorOperands() {
    return getODSOperands(5);
  }

  ::mlir::Operation::operand_range getTileOperands() {
    return getODSOperands(6);
  }

  ::mlir::Operation::operand_range getCacheOperands() {
    return getODSOperands(7);
  }

  ::mlir::Operation::operand_range getPrivateOperands() {
    return getODSOperands(8);
  }

  ::mlir::Operation::operand_range getFirstprivateOperands() {
    return getODSOperands(9);
  }

  ::mlir::Operation::operand_range getReductionOperands() {
    return getODSOperands(10);
  }

  ::mlir::MutableOperandRange getLowerboundMutable();
  ::mlir::MutableOperandRange getUpperboundMutable();
  ::mlir::MutableOperandRange getStepMutable();
  ::mlir::MutableOperandRange getGangOperandsMutable();
  ::mlir::MutableOperandRange getWorkerNumOperandsMutable();
  ::mlir::MutableOperandRange getVectorOperandsMutable();
  ::mlir::MutableOperandRange getTileOperandsMutable();
  ::mlir::MutableOperandRange getCacheOperandsMutable();
  ::mlir::MutableOperandRange getPrivateOperandsMutable();
  ::mlir::MutableOperandRange getFirstprivateOperandsMutable();
  ::mlir::MutableOperandRange getReductionOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseBoolArrayAttr getInclusiveUpperboundAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().inclusiveUpperbound);
  }

  ::std::optional<::llvm::ArrayRef<bool>> getInclusiveUpperbound();
  ::mlir::ArrayAttr getCollapseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().collapse);
  }

  ::std::optional< ::mlir::ArrayAttr > getCollapse();
  ::mlir::ArrayAttr getCollapseDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().collapseDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getCollapseDeviceType();
  ::mlir::ArrayAttr getGangOperandsArgTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gangOperandsArgType);
  }

  ::std::optional< ::mlir::ArrayAttr > getGangOperandsArgType();
  ::mlir::DenseI32ArrayAttr getGangOperandsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().gangOperandsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getGangOperandsSegments();
  ::mlir::ArrayAttr getGangOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gangOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getGangOperandsDeviceType();
  ::mlir::ArrayAttr getWorkerNumOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().workerNumOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getWorkerNumOperandsDeviceType();
  ::mlir::ArrayAttr getVectorOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vectorOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getVectorOperandsDeviceType();
  ::mlir::ArrayAttr getSeqAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().seq);
  }

  ::std::optional< ::mlir::ArrayAttr > getSeq();
  ::mlir::ArrayAttr getIndependentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().independent);
  }

  ::std::optional< ::mlir::ArrayAttr > getIndependent();
  ::mlir::ArrayAttr getAuto_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().auto_);
  }

  ::std::optional< ::mlir::ArrayAttr > getAuto_();
  ::mlir::ArrayAttr getGangAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gang);
  }

  ::std::optional< ::mlir::ArrayAttr > getGang();
  ::mlir::ArrayAttr getWorkerAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().worker);
  }

  ::std::optional< ::mlir::ArrayAttr > getWorker();
  ::mlir::ArrayAttr getVectorAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vector);
  }

  ::std::optional< ::mlir::ArrayAttr > getVector();
  ::mlir::DenseI32ArrayAttr getTileOperandsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().tileOperandsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getTileOperandsSegments();
  ::mlir::ArrayAttr getTileOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tileOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getTileOperandsDeviceType();
  ::mlir::ArrayAttr getPrivatizationRecipesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizationRecipes);
  }

  ::std::optional< ::mlir::ArrayAttr > getPrivatizationRecipes();
  ::mlir::ArrayAttr getFirstprivatizationRecipesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizationRecipes);
  }

  ::std::optional< ::mlir::ArrayAttr > getFirstprivatizationRecipes();
  ::mlir::ArrayAttr getReductionRecipesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
  }

  ::std::optional< ::mlir::ArrayAttr > getReductionRecipes();
  ::mlir::acc::CombinedConstructsTypeAttr getCombinedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::CombinedConstructsTypeAttr>(getProperties().combined);
  }

  ::std::optional<::mlir::acc::CombinedConstructsType> getCombined();
  void setInclusiveUpperboundAttr(::mlir::DenseBoolArrayAttr attr) {
    getProperties().inclusiveUpperbound = attr;
  }

  void setInclusiveUpperbound(::std::optional<::llvm::ArrayRef<bool>> attrValue);
  void setCollapseAttr(::mlir::ArrayAttr attr) {
    getProperties().collapse = attr;
  }

  void setCollapseDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().collapseDeviceType = attr;
  }

  void setGangOperandsArgTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().gangOperandsArgType = attr;
  }

  void setGangOperandsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().gangOperandsSegments = attr;
  }

  void setGangOperandsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setGangOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().gangOperandsDeviceType = attr;
  }

  void setWorkerNumOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().workerNumOperandsDeviceType = attr;
  }

  void setVectorOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().vectorOperandsDeviceType = attr;
  }

  void setSeqAttr(::mlir::ArrayAttr attr) {
    getProperties().seq = attr;
  }

  void setIndependentAttr(::mlir::ArrayAttr attr) {
    getProperties().independent = attr;
  }

  void setAuto_Attr(::mlir::ArrayAttr attr) {
    getProperties().auto_ = attr;
  }

  void setGangAttr(::mlir::ArrayAttr attr) {
    getProperties().gang = attr;
  }

  void setWorkerAttr(::mlir::ArrayAttr attr) {
    getProperties().worker = attr;
  }

  void setVectorAttr(::mlir::ArrayAttr attr) {
    getProperties().vector = attr;
  }

  void setTileOperandsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().tileOperandsSegments = attr;
  }

  void setTileOperandsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setTileOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().tileOperandsDeviceType = attr;
  }

  void setPrivatizationRecipesAttr(::mlir::ArrayAttr attr) {
    getProperties().privatizationRecipes = attr;
  }

  void setFirstprivatizationRecipesAttr(::mlir::ArrayAttr attr) {
    getProperties().firstprivatizationRecipes = attr;
  }

  void setReductionRecipesAttr(::mlir::ArrayAttr attr) {
    getProperties().reductionRecipes = attr;
  }

  void setCombinedAttr(::mlir::acc::CombinedConstructsTypeAttr attr) {
    getProperties().combined = attr;
  }

  void setCombined(::std::optional<::mlir::acc::CombinedConstructsType> attrValue);
  ::mlir::Attribute removeInclusiveUpperboundAttr() {
      auto attr = getProperties().inclusiveUpperbound;
      getProperties().inclusiveUpperbound = {};
      return attr;
  }

  ::mlir::Attribute removeCollapseAttr() {
      auto attr = getProperties().collapse;
      getProperties().collapse = {};
      return attr;
  }

  ::mlir::Attribute removeCollapseDeviceTypeAttr() {
      auto attr = getProperties().collapseDeviceType;
      getProperties().collapseDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeGangOperandsArgTypeAttr() {
      auto attr = getProperties().gangOperandsArgType;
      getProperties().gangOperandsArgType = {};
      return attr;
  }

  ::mlir::Attribute removeGangOperandsSegmentsAttr() {
      auto attr = getProperties().gangOperandsSegments;
      getProperties().gangOperandsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeGangOperandsDeviceTypeAttr() {
      auto attr = getProperties().gangOperandsDeviceType;
      getProperties().gangOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeWorkerNumOperandsDeviceTypeAttr() {
      auto attr = getProperties().workerNumOperandsDeviceType;
      getProperties().workerNumOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeVectorOperandsDeviceTypeAttr() {
      auto attr = getProperties().vectorOperandsDeviceType;
      getProperties().vectorOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeSeqAttr() {
      auto attr = getProperties().seq;
      getProperties().seq = {};
      return attr;
  }

  ::mlir::Attribute removeIndependentAttr() {
      auto attr = getProperties().independent;
      getProperties().independent = {};
      return attr;
  }

  ::mlir::Attribute removeAuto_Attr() {
      auto attr = getProperties().auto_;
      getProperties().auto_ = {};
      return attr;
  }

  ::mlir::Attribute removeGangAttr() {
      auto attr = getProperties().gang;
      getProperties().gang = {};
      return attr;
  }

  ::mlir::Attribute removeWorkerAttr() {
      auto attr = getProperties().worker;
      getProperties().worker = {};
      return attr;
  }

  ::mlir::Attribute removeVectorAttr() {
      auto attr = getProperties().vector;
      getProperties().vector = {};
      return attr;
  }

  ::mlir::Attribute removeTileOperandsSegmentsAttr() {
      auto attr = getProperties().tileOperandsSegments;
      getProperties().tileOperandsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeTileOperandsDeviceTypeAttr() {
      auto attr = getProperties().tileOperandsDeviceType;
      getProperties().tileOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removePrivatizationRecipesAttr() {
      auto attr = getProperties().privatizationRecipes;
      getProperties().privatizationRecipes = {};
      return attr;
  }

  ::mlir::Attribute removeFirstprivatizationRecipesAttr() {
      auto attr = getProperties().firstprivatizationRecipes;
      getProperties().firstprivatizationRecipes = {};
      return attr;
  }

  ::mlir::Attribute removeReductionRecipesAttr() {
      auto attr = getProperties().reductionRecipes;
      getProperties().reductionRecipes = {};
      return attr;
  }

  ::mlir::Attribute removeCombinedAttr() {
      auto attr = getProperties().combined;
      getProperties().combined = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange lowerbounds, ::mlir::ValueRange upperbounds, ::mlir::ValueRange steps, LoopParMode parMode);
  static LoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange lowerbounds, ::mlir::ValueRange upperbounds, ::mlir::ValueRange steps, LoopParMode parMode);
  static LoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange lowerbounds, ::mlir::ValueRange upperbounds, ::mlir::ValueRange steps, LoopParMode parMode);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::DenseBoolArrayAttr inclusiveUpperbound, /*optional*/::mlir::ArrayAttr collapse, /*optional*/::mlir::ArrayAttr collapseDeviceType, ::mlir::ValueRange gangOperands, /*optional*/::mlir::ArrayAttr gangOperandsArgType, /*optional*/::mlir::DenseI32ArrayAttr gangOperandsSegments, /*optional*/::mlir::ArrayAttr gangOperandsDeviceType, ::mlir::ValueRange workerNumOperands, /*optional*/::mlir::ArrayAttr workerNumOperandsDeviceType, ::mlir::ValueRange vectorOperands, /*optional*/::mlir::ArrayAttr vectorOperandsDeviceType, /*optional*/::mlir::ArrayAttr seq, /*optional*/::mlir::ArrayAttr independent, /*optional*/::mlir::ArrayAttr auto_, /*optional*/::mlir::ArrayAttr gang, /*optional*/::mlir::ArrayAttr worker, /*optional*/::mlir::ArrayAttr vector, ::mlir::ValueRange tileOperands, /*optional*/::mlir::DenseI32ArrayAttr tileOperandsSegments, /*optional*/::mlir::ArrayAttr tileOperandsDeviceType, ::mlir::ValueRange cacheOperands, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, /*optional*/::mlir::acc::CombinedConstructsTypeAttr combined);
  static LoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange results, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::DenseBoolArrayAttr inclusiveUpperbound, /*optional*/::mlir::ArrayAttr collapse, /*optional*/::mlir::ArrayAttr collapseDeviceType, ::mlir::ValueRange gangOperands, /*optional*/::mlir::ArrayAttr gangOperandsArgType, /*optional*/::mlir::DenseI32ArrayAttr gangOperandsSegments, /*optional*/::mlir::ArrayAttr gangOperandsDeviceType, ::mlir::ValueRange workerNumOperands, /*optional*/::mlir::ArrayAttr workerNumOperandsDeviceType, ::mlir::ValueRange vectorOperands, /*optional*/::mlir::ArrayAttr vectorOperandsDeviceType, /*optional*/::mlir::ArrayAttr seq, /*optional*/::mlir::ArrayAttr independent, /*optional*/::mlir::ArrayAttr auto_, /*optional*/::mlir::ArrayAttr gang, /*optional*/::mlir::ArrayAttr worker, /*optional*/::mlir::ArrayAttr vector, ::mlir::ValueRange tileOperands, /*optional*/::mlir::DenseI32ArrayAttr tileOperandsSegments, /*optional*/::mlir::ArrayAttr tileOperandsDeviceType, ::mlir::ValueRange cacheOperands, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, /*optional*/::mlir::acc::CombinedConstructsTypeAttr combined);
  static LoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange results, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::DenseBoolArrayAttr inclusiveUpperbound, /*optional*/::mlir::ArrayAttr collapse, /*optional*/::mlir::ArrayAttr collapseDeviceType, ::mlir::ValueRange gangOperands, /*optional*/::mlir::ArrayAttr gangOperandsArgType, /*optional*/::mlir::DenseI32ArrayAttr gangOperandsSegments, /*optional*/::mlir::ArrayAttr gangOperandsDeviceType, ::mlir::ValueRange workerNumOperands, /*optional*/::mlir::ArrayAttr workerNumOperandsDeviceType, ::mlir::ValueRange vectorOperands, /*optional*/::mlir::ArrayAttr vectorOperandsDeviceType, /*optional*/::mlir::ArrayAttr seq, /*optional*/::mlir::ArrayAttr independent, /*optional*/::mlir::ArrayAttr auto_, /*optional*/::mlir::ArrayAttr gang, /*optional*/::mlir::ArrayAttr worker, /*optional*/::mlir::ArrayAttr vector, ::mlir::ValueRange tileOperands, /*optional*/::mlir::DenseI32ArrayAttr tileOperandsSegments, /*optional*/::mlir::ArrayAttr tileOperandsDeviceType, ::mlir::ValueRange cacheOperands, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, /*optional*/::mlir::acc::CombinedConstructsTypeAttr combined);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Region *> getLoopRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 20 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static StringRef getAutoAttrStrName() { return "auto"; }
  static StringRef getGangNumKeyword() { return "num"; }
  static StringRef getGangDimKeyword() { return "dim"; }
  static StringRef getGangStaticKeyword() { return "static"; }
  static StringRef getControlKeyword() { return "control"; }

  /// The number of private and reduction operands.
  unsigned getNumDataOperands();

  /// The i-th data operand passed.
  Value getDataOperand(unsigned i);

  /// Used to retrieve the block inside the op's region.
  Block &getBody() { return getLoopRegions().front()->front(); }

  /// Used to determine if this operation is merely a container for a loop
  /// operation instead of being loop-like itself.
  bool isLoopLike() { return !getLowerbound().empty(); }
  bool isContainerLike() { return !isLoopLike(); }

  /// Return true if the op has the auto attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAuto();
  /// Return true if the op has the auto attribute for the given device_type.
  bool hasAuto(mlir::acc::DeviceType deviceType);
  /// Return true if the op has the independent attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasIndependent();
  /// Return true if the op has the independent attribute for the given
  /// device_type.
  bool hasIndependent(mlir::acc::DeviceType deviceType);
  /// Return true if the op has the seq attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasSeq();
  /// Return true if the op has the seq attribute for the given device_type.
  bool hasSeq(mlir::acc::DeviceType deviceType);

  /// Return the value of the vector clause if present.
  mlir::Value getVectorValue();
  /// Return the value of the vector clause for the given device_type 
  /// if present.
  mlir::Value getVectorValue(mlir::acc::DeviceType deviceType);
  /// Return true if the op has the vector attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasVector();
  /// Return true if the op has the vector attribute for the given
  /// device_type.
  bool hasVector(mlir::acc::DeviceType deviceType);

  /// Return the value of the worker clause if present.
  mlir::Value getWorkerValue();
  /// Return the value of the worker clause for the given device_type 
  /// if present.
  mlir::Value getWorkerValue(mlir::acc::DeviceType deviceType);
  /// Return true if the op has the worker attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasWorker();
  /// Return true if the op has the worker attribute for the given
  /// device_type.
  bool hasWorker(mlir::acc::DeviceType deviceType);

  /// Return the values of the tile clause if present.
  mlir::Operation::operand_range getTileValues();
  /// Return the values of the tile clause for the given device_type if
  /// present.
  mlir::Operation::operand_range
  getTileValues(mlir::acc::DeviceType deviceType);

  /// Return the value of the collapse clause if present.
  std::optional<int64_t> getCollapseValue();
  /// Return the value of the collapse clause for the given device_type 
  /// if present.
  std::optional<int64_t> getCollapseValue(mlir::acc::DeviceType deviceType);

  /// Return true if the op has the gang attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasGang();
  /// Return true if the op has the gang attribute for the given
  /// device_type.
  bool hasGang(mlir::acc::DeviceType deviceType);

  /// Return the value of the worker clause if present.
  mlir::Value getGangValue(mlir::acc::GangArgType gangArgType);
  /// Return the value of the worker clause for the given device_type 
  /// if present.
  mlir::Value getGangValue(mlir::acc::GangArgType gangArgType, mlir::acc::DeviceType deviceType);

  // Add an entry to the 'seq' attribute for each additional device types.
  void addSeq(MLIRContext *, llvm::ArrayRef<DeviceType>);
  // Add an entry to the 'independent' attribute for each additional device
  // types.
  void addIndependent(MLIRContext *, llvm::ArrayRef<DeviceType>);
  // Add an entry to the 'auto' attribute for each additional device types.
  void addAuto(MLIRContext *, llvm::ArrayRef<DeviceType>);

  // Sets the collapse value for this 'loop' for a set of DeviceTypes. Note
  // that this may only be set once per DeviceType, and will fail the verifier
  // if this is set multiple times.
  void setCollapseForDeviceTypes(MLIRContext *, llvm::ArrayRef<DeviceType>,
                                 llvm::APInt);
  // Sets the tile values for this 'loop' for a set of DeviceTypes. All of the
  // values should be integral constants, with the '*' represented as a '-1'.
  void setTileForDeviceTypes(MLIRContext *, llvm::ArrayRef<DeviceType>,
                             mlir::ValueRange);

  // Add a value to the 'vector' list with a current list of device_types.
  void addVectorOperand(MLIRContext *, mlir::Value,
                        llvm::ArrayRef<DeviceType>);
  // Add an empty value to the 'vector' list with a current list of
  // device_types. This is for the case where there is no expression specified
  // in a 'vector'.
  void addEmptyVector(MLIRContext *, llvm::ArrayRef<DeviceType>);
  // Add a value to the 'worker' list with a current list of device_types.
  void addWorkerNumOperand(MLIRContext *, mlir::Value,
                           llvm::ArrayRef<DeviceType>);
  // Add an empty value to the 'worker' list with a current list of
  // device_types. This is for the case where there is no expression specified
  // in a 'worker'.
  void addEmptyWorker(MLIRContext *, llvm::ArrayRef<DeviceType>);

  // Adds a collection of operands for a 'gang' clause that has various types
  // corresponding to each operand.
  void addGangOperands(MLIRContext *, llvm::ArrayRef<DeviceType>,
                       llvm::ArrayRef<GangArgType>, mlir::ValueRange);

  // Add an empty value to the 'gang' list with a current list of
  // device_types. This is for the case where there is no expression specified
  // in a 'gang'.
  void addEmptyGang(MLIRContext *, llvm::ArrayRef<DeviceType>);

  // Return whether this LoopOp has an auto, seq, or independent for the
  // specified device-type.
  bool hasParallelismFlag(DeviceType);

  // Return whether this LoopOp has a gang, worker, or vector applying to the
  // 'default'/None device-type.
  bool hasDefaultGangWorkerVector();

  // Used to obtain the parallelism mode for the requested device type.
  // This first checks if the mode is set for the device_type requested.
  // And if not, it returns the non-device_type mode.
  LoopParMode getDefaultOrDeviceTypeParallelism(DeviceType);

  /// Adds a private clause variable to this operation, including its recipe.
  void addPrivatization(MLIRContext *, mlir::acc::PrivateOp op,
                        mlir::acc::PrivateRecipeOp recipe);
  /// Adds a firstprivate clause variable to this operation, including its
  /// recipe.
  void addFirstPrivatization(MLIRContext *, mlir::acc::FirstprivateOp op,
                             mlir::acc::FirstprivateRecipeOp recipe);
  /// Adds a reduction clause variable to this operation, including its
  /// recipe.
  void addReduction(MLIRContext *, mlir::acc::ReductionOp op,
                    mlir::acc::ReductionRecipeOp recipe);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::LoopOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::NoCreateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class NoCreateOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NoCreateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.nocreate", odsAttrs.getContext());
  }

  NoCreateOpGenericAdaptorBase(NoCreateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class NoCreateOpGenericAdaptor : public detail::NoCreateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NoCreateOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  NoCreateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NoCreateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NoCreateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NoCreateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : NoCreateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NoCreateOpGenericAdaptor(RangeT values, const NoCreateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NoCreateOp, typename = std::enable_if_t<std::is_same_v<LateInst, NoCreateOp>>>
  NoCreateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NoCreateOpAdaptor : public NoCreateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NoCreateOpGenericAdaptor::NoCreateOpGenericAdaptor;
  NoCreateOpAdaptor(NoCreateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NoCreateOp : public ::mlir::Op<NoCreateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NoCreateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NoCreateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.nocreate");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoCreateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoCreateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::NoCreateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ParallelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ParallelOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using combinedTy = ::mlir::UnitAttr;
    combinedTy combined;

    auto getCombined() const {
      auto &propStorage = this->combined;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCombined(const ::mlir::UnitAttr &propValue) {
      this->combined = propValue;
    }
    using defaultAttrTy = ::mlir::acc::ClauseDefaultValueAttr;
    defaultAttrTy defaultAttr;

    auto getDefaultAttr() const {
      auto &propStorage = this->defaultAttr;
      return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(propStorage);
    }
    void setDefaultAttr(const ::mlir::acc::ClauseDefaultValueAttr &propValue) {
      this->defaultAttr = propValue;
    }
    using firstprivatizationRecipesTy = ::mlir::ArrayAttr;
    firstprivatizationRecipesTy firstprivatizationRecipes;

    auto getFirstprivatizationRecipes() const {
      auto &propStorage = this->firstprivatizationRecipes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setFirstprivatizationRecipes(const ::mlir::ArrayAttr &propValue) {
      this->firstprivatizationRecipes = propValue;
    }
    using hasWaitDevnumTy = ::mlir::ArrayAttr;
    hasWaitDevnumTy hasWaitDevnum;

    auto getHasWaitDevnum() const {
      auto &propStorage = this->hasWaitDevnum;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setHasWaitDevnum(const ::mlir::ArrayAttr &propValue) {
      this->hasWaitDevnum = propValue;
    }
    using numGangsDeviceTypeTy = ::mlir::ArrayAttr;
    numGangsDeviceTypeTy numGangsDeviceType;

    auto getNumGangsDeviceType() const {
      auto &propStorage = this->numGangsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNumGangsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->numGangsDeviceType = propValue;
    }
    using numGangsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    numGangsSegmentsTy numGangsSegments;

    auto getNumGangsSegments() const {
      auto &propStorage = this->numGangsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setNumGangsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->numGangsSegments = propValue;
    }
    using numWorkersDeviceTypeTy = ::mlir::ArrayAttr;
    numWorkersDeviceTypeTy numWorkersDeviceType;

    auto getNumWorkersDeviceType() const {
      auto &propStorage = this->numWorkersDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNumWorkersDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->numWorkersDeviceType = propValue;
    }
    using privatizationRecipesTy = ::mlir::ArrayAttr;
    privatizationRecipesTy privatizationRecipes;

    auto getPrivatizationRecipes() const {
      auto &propStorage = this->privatizationRecipes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPrivatizationRecipes(const ::mlir::ArrayAttr &propValue) {
      this->privatizationRecipes = propValue;
    }
    using reductionRecipesTy = ::mlir::ArrayAttr;
    reductionRecipesTy reductionRecipes;

    auto getReductionRecipes() const {
      auto &propStorage = this->reductionRecipes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setReductionRecipes(const ::mlir::ArrayAttr &propValue) {
      this->reductionRecipes = propValue;
    }
    using selfAttrTy = ::mlir::UnitAttr;
    selfAttrTy selfAttr;

    auto getSelfAttr() const {
      auto &propStorage = this->selfAttr;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setSelfAttr(const ::mlir::UnitAttr &propValue) {
      this->selfAttr = propValue;
    }
    using vectorLengthDeviceTypeTy = ::mlir::ArrayAttr;
    vectorLengthDeviceTypeTy vectorLengthDeviceType;

    auto getVectorLengthDeviceType() const {
      auto &propStorage = this->vectorLengthDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setVectorLengthDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->vectorLengthDeviceType = propValue;
    }
    using waitOnlyTy = ::mlir::ArrayAttr;
    waitOnlyTy waitOnly;

    auto getWaitOnly() const {
      auto &propStorage = this->waitOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWaitOnly(const ::mlir::ArrayAttr &propValue) {
      this->waitOnly = propValue;
    }
    using waitOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    waitOperandsDeviceTypeTy waitOperandsDeviceType;

    auto getWaitOperandsDeviceType() const {
      auto &propStorage = this->waitOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWaitOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->waitOperandsDeviceType = propValue;
    }
    using waitOperandsSegmentsTy = ::mlir::DenseI32ArrayAttr;
    waitOperandsSegmentsTy waitOperandsSegments;

    auto getWaitOperandsSegments() const {
      auto &propStorage = this->waitOperandsSegments;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setWaitOperandsSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->waitOperandsSegments = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 11>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.combined == this->combined &&
        rhs.defaultAttr == this->defaultAttr &&
        rhs.firstprivatizationRecipes == this->firstprivatizationRecipes &&
        rhs.hasWaitDevnum == this->hasWaitDevnum &&
        rhs.numGangsDeviceType == this->numGangsDeviceType &&
        rhs.numGangsSegments == this->numGangsSegments &&
        rhs.numWorkersDeviceType == this->numWorkersDeviceType &&
        rhs.privatizationRecipes == this->privatizationRecipes &&
        rhs.reductionRecipes == this->reductionRecipes &&
        rhs.selfAttr == this->selfAttr &&
        rhs.vectorLengthDeviceType == this->vectorLengthDeviceType &&
        rhs.waitOnly == this->waitOnly &&
        rhs.waitOperandsDeviceType == this->waitOperandsDeviceType &&
        rhs.waitOperandsSegments == this->waitOperandsSegments &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ParallelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.parallel", odsAttrs.getContext());
  }

  ParallelOpGenericAdaptorBase(ParallelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::DenseI32ArrayAttr getWaitOperandsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().waitOperandsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWaitOperandsSegments();
  ::mlir::ArrayAttr getWaitOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOperandsDeviceType();
  ::mlir::ArrayAttr getHasWaitDevnumAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().hasWaitDevnum);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getHasWaitDevnum();
  ::mlir::ArrayAttr getWaitOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOnly();
  ::mlir::DenseI32ArrayAttr getNumGangsSegmentsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().numGangsSegments);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getNumGangsSegments();
  ::mlir::ArrayAttr getNumGangsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numGangsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNumGangsDeviceType();
  ::mlir::ArrayAttr getNumWorkersDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numWorkersDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNumWorkersDeviceType();
  ::mlir::ArrayAttr getVectorLengthDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vectorLengthDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getVectorLengthDeviceType();
  ::mlir::UnitAttr getSelfAttrAttr();
  bool getSelfAttr();
  ::mlir::ArrayAttr getReductionRecipesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getReductionRecipes();
  ::mlir::ArrayAttr getPrivatizationRecipesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizationRecipes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPrivatizationRecipes();
  ::mlir::ArrayAttr getFirstprivatizationRecipesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizationRecipes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getFirstprivatizationRecipes();
  ::mlir::acc::ClauseDefaultValueAttr getDefaultAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
    return attr;
  }

  ::std::optional<::mlir::acc::ClauseDefaultValue> getDefaultAttr();
  ::mlir::UnitAttr getCombinedAttr();
  bool getCombined();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class ParallelOpGenericAdaptor : public detail::ParallelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ParallelOpGenericAdaptorBase;
  static constexpr int odsIndex_asyncOperands = 0;
  static constexpr int odsIndex_waitOperands = 1;
  static constexpr int odsIndex_numGangs = 2;
  static constexpr int odsIndex_numWorkers = 3;
  static constexpr int odsIndex_vectorLength = 4;
  static constexpr int odsIndex_ifCond = 5;
  static constexpr int odsIndex_selfCond = 6;
  static constexpr int odsIndex_reductionOperands = 7;
  static constexpr int odsIndex_privateOperands = 8;
  static constexpr int odsIndex_firstprivateOperands = 9;
  static constexpr int odsIndex_dataClauseOperands = 10;
public:
  ParallelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ParallelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ParallelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ParallelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ParallelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ParallelOpGenericAdaptor(RangeT values, const ParallelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ParallelOp, typename = std::enable_if_t<std::is_same_v<LateInst, ParallelOp>>>
  ParallelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getAsyncOperands() {
    return getODSOperands(0);
  }

  RangeT getWaitOperands() {
    return getODSOperands(1);
  }

  RangeT getNumGangs() {
    return getODSOperands(2);
  }

  RangeT getNumWorkers() {
    return getODSOperands(3);
  }

  RangeT getVectorLength() {
    return getODSOperands(4);
  }

  ValueT getIfCond() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSelfCond() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getReductionOperands() {
    return getODSOperands(7);
  }

  RangeT getPrivateOperands() {
    return getODSOperands(8);
  }

  RangeT getFirstprivateOperands() {
    return getODSOperands(9);
  }

  RangeT getDataClauseOperands() {
    return getODSOperands(10);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ParallelOpAdaptor : public ParallelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ParallelOpGenericAdaptor::ParallelOpGenericAdaptor;
  ParallelOpAdaptor(ParallelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ParallelOp : public ::mlir::Op<ParallelOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::AutomaticAllocationScope, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::acc::ComputeRegionOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ParallelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ParallelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_asyncOperands = 0;
  static constexpr int odsIndex_waitOperands = 1;
  static constexpr int odsIndex_numGangs = 2;
  static constexpr int odsIndex_numWorkers = 3;
  static constexpr int odsIndex_vectorLength = 4;
  static constexpr int odsIndex_ifCond = 5;
  static constexpr int odsIndex_selfCond = 6;
  static constexpr int odsIndex_reductionOperands = 7;
  static constexpr int odsIndex_privateOperands = 8;
  static constexpr int odsIndex_firstprivateOperands = 9;
  static constexpr int odsIndex_dataClauseOperands = 10;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("combined"), ::llvm::StringRef("defaultAttr"), ::llvm::StringRef("firstprivatizationRecipes"), ::llvm::StringRef("hasWaitDevnum"), ::llvm::StringRef("numGangsDeviceType"), ::llvm::StringRef("numGangsSegments"), ::llvm::StringRef("numWorkersDeviceType"), ::llvm::StringRef("privatizationRecipes"), ::llvm::StringRef("reductionRecipes"), ::llvm::StringRef("selfAttr"), ::llvm::StringRef("vectorLengthDeviceType"), ::llvm::StringRef("waitOnly"), ::llvm::StringRef("waitOperandsDeviceType"), ::llvm::StringRef("waitOperandsSegments"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCombinedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCombinedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getDefaultAttrAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getDefaultAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getFirstprivatizationRecipesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getFirstprivatizationRecipesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getHasWaitDevnumAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getHasWaitDevnumAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getNumGangsDeviceTypeAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getNumGangsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getNumGangsSegmentsAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getNumGangsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getNumWorkersDeviceTypeAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getNumWorkersDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getPrivatizationRecipesAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getPrivatizationRecipesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getReductionRecipesAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getReductionRecipesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getSelfAttrAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getSelfAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getVectorLengthDeviceTypeAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getVectorLengthDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getWaitOnlyAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getWaitOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getWaitOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getWaitOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getWaitOperandsSegmentsAttrName() {
    return getAttributeNameForIndex(15);
  }

  static ::mlir::StringAttr getWaitOperandsSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 15);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.parallel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getWaitOperands() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getNumGangs() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getNumWorkers() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getVectorLength() {
    return getODSOperands(4);
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIfCond() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSelfCond() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getReductionOperands() {
    return getODSOperands(7);
  }

  ::mlir::Operation::operand_range getPrivateOperands() {
    return getODSOperands(8);
  }

  ::mlir::Operation::operand_range getFirstprivateOperands() {
    return getODSOperands(9);
  }

  ::mlir::Operation::operand_range getDataClauseOperands() {
    return getODSOperands(10);
  }

  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  ::mlir::MutableOperandRange getWaitOperandsMutable();
  ::mlir::MutableOperandRange getNumGangsMutable();
  ::mlir::MutableOperandRange getNumWorkersMutable();
  ::mlir::MutableOperandRange getVectorLengthMutable();
  ::mlir::MutableOperandRange getIfCondMutable();
  ::mlir::MutableOperandRange getSelfCondMutable();
  ::mlir::MutableOperandRange getReductionOperandsMutable();
  ::mlir::MutableOperandRange getPrivateOperandsMutable();
  ::mlir::MutableOperandRange getFirstprivateOperandsMutable();
  ::mlir::MutableOperandRange getDataClauseOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::DenseI32ArrayAttr getWaitOperandsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().waitOperandsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWaitOperandsSegments();
  ::mlir::ArrayAttr getWaitOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOperandsDeviceType();
  ::mlir::ArrayAttr getHasWaitDevnumAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().hasWaitDevnum);
  }

  ::std::optional< ::mlir::ArrayAttr > getHasWaitDevnum();
  ::mlir::ArrayAttr getWaitOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().waitOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getWaitOnly();
  ::mlir::DenseI32ArrayAttr getNumGangsSegmentsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().numGangsSegments);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getNumGangsSegments();
  ::mlir::ArrayAttr getNumGangsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numGangsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getNumGangsDeviceType();
  ::mlir::ArrayAttr getNumWorkersDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().numWorkersDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getNumWorkersDeviceType();
  ::mlir::ArrayAttr getVectorLengthDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vectorLengthDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getVectorLengthDeviceType();
  ::mlir::UnitAttr getSelfAttrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
  }

  bool getSelfAttr();
  ::mlir::ArrayAttr getReductionRecipesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
  }

  ::std::optional< ::mlir::ArrayAttr > getReductionRecipes();
  ::mlir::ArrayAttr getPrivatizationRecipesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizationRecipes);
  }

  ::std::optional< ::mlir::ArrayAttr > getPrivatizationRecipes();
  ::mlir::ArrayAttr getFirstprivatizationRecipesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizationRecipes);
  }

  ::std::optional< ::mlir::ArrayAttr > getFirstprivatizationRecipes();
  ::mlir::acc::ClauseDefaultValueAttr getDefaultAttrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  }

  ::std::optional<::mlir::acc::ClauseDefaultValue> getDefaultAttr();
  ::mlir::UnitAttr getCombinedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().combined);
  }

  bool getCombined();
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setWaitOperandsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().waitOperandsSegments = attr;
  }

  void setWaitOperandsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setWaitOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().waitOperandsDeviceType = attr;
  }

  void setHasWaitDevnumAttr(::mlir::ArrayAttr attr) {
    getProperties().hasWaitDevnum = attr;
  }

  void setWaitOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().waitOnly = attr;
  }

  void setNumGangsSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().numGangsSegments = attr;
  }

  void setNumGangsSegments(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setNumGangsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().numGangsDeviceType = attr;
  }

  void setNumWorkersDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().numWorkersDeviceType = attr;
  }

  void setVectorLengthDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().vectorLengthDeviceType = attr;
  }

  void setSelfAttrAttr(::mlir::UnitAttr attr) {
    getProperties().selfAttr = attr;
  }

  void setSelfAttr(bool attrValue);
  void setReductionRecipesAttr(::mlir::ArrayAttr attr) {
    getProperties().reductionRecipes = attr;
  }

  void setPrivatizationRecipesAttr(::mlir::ArrayAttr attr) {
    getProperties().privatizationRecipes = attr;
  }

  void setFirstprivatizationRecipesAttr(::mlir::ArrayAttr attr) {
    getProperties().firstprivatizationRecipes = attr;
  }

  void setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
    getProperties().defaultAttr = attr;
  }

  void setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue);
  void setCombinedAttr(::mlir::UnitAttr attr) {
    getProperties().combined = attr;
  }

  void setCombined(bool attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOperandsSegmentsAttr() {
      auto attr = getProperties().waitOperandsSegments;
      getProperties().waitOperandsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOperandsDeviceTypeAttr() {
      auto attr = getProperties().waitOperandsDeviceType;
      getProperties().waitOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeHasWaitDevnumAttr() {
      auto attr = getProperties().hasWaitDevnum;
      getProperties().hasWaitDevnum = {};
      return attr;
  }

  ::mlir::Attribute removeWaitOnlyAttr() {
      auto attr = getProperties().waitOnly;
      getProperties().waitOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNumGangsSegmentsAttr() {
      auto attr = getProperties().numGangsSegments;
      getProperties().numGangsSegments = {};
      return attr;
  }

  ::mlir::Attribute removeNumGangsDeviceTypeAttr() {
      auto attr = getProperties().numGangsDeviceType;
      getProperties().numGangsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeNumWorkersDeviceTypeAttr() {
      auto attr = getProperties().numWorkersDeviceType;
      getProperties().numWorkersDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeVectorLengthDeviceTypeAttr() {
      auto attr = getProperties().vectorLengthDeviceType;
      getProperties().vectorLengthDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeSelfAttrAttr() {
      auto attr = getProperties().selfAttr;
      getProperties().selfAttr = {};
      return attr;
  }

  ::mlir::Attribute removeReductionRecipesAttr() {
      auto attr = getProperties().reductionRecipes;
      getProperties().reductionRecipes = {};
      return attr;
  }

  ::mlir::Attribute removePrivatizationRecipesAttr() {
      auto attr = getProperties().privatizationRecipes;
      getProperties().privatizationRecipes = {};
      return attr;
  }

  ::mlir::Attribute removeFirstprivatizationRecipesAttr() {
      auto attr = getProperties().firstprivatizationRecipes;
      getProperties().firstprivatizationRecipes = {};
      return attr;
  }

  ::mlir::Attribute removeDefaultAttrAttr() {
      auto attr = getProperties().defaultAttr;
      getProperties().defaultAttr = {};
      return attr;
  }

  ::mlir::Attribute removeCombinedAttr() {
      auto attr = getProperties().combined;
      getProperties().combined = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::ValueRange numGangs = {}, mlir::ValueRange numWorkers = {}, mlir::ValueRange vectorLength = {}, mlir::ValueRange asyncOperands = {}, mlir::ValueRange waitOperands = {}, mlir::Value ifCond = {}, mlir::Value selfCond = {}, mlir::ValueRange reductionOperands = {}, mlir::ValueRange privateOperands = {}, mlir::ValueRange firstprivateOperands = {}, mlir::ValueRange dataClauseOperands = {});
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::ValueRange numGangs = {}, mlir::ValueRange numWorkers = {}, mlir::ValueRange vectorLength = {}, mlir::ValueRange asyncOperands = {}, mlir::ValueRange waitOperands = {}, mlir::Value ifCond = {}, mlir::Value selfCond = {}, mlir::ValueRange reductionOperands = {}, mlir::ValueRange privateOperands = {}, mlir::ValueRange firstprivateOperands = {}, mlir::ValueRange dataClauseOperands = {});
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::ValueRange numGangs = {}, mlir::ValueRange numWorkers = {}, mlir::ValueRange vectorLength = {}, mlir::ValueRange asyncOperands = {}, mlir::ValueRange waitOperands = {}, mlir::Value ifCond = {}, mlir::Value selfCond = {}, mlir::ValueRange reductionOperands = {}, mlir::ValueRange privateOperands = {}, mlir::ValueRange firstprivateOperands = {}, mlir::ValueRange dataClauseOperands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/::mlir::UnitAttr combined);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::ValueRange waitOperands, /*optional*/::mlir::DenseI32ArrayAttr waitOperandsSegments, /*optional*/::mlir::ArrayAttr waitOperandsDeviceType, /*optional*/::mlir::ArrayAttr hasWaitDevnum, /*optional*/::mlir::ArrayAttr waitOnly, ::mlir::ValueRange numGangs, /*optional*/::mlir::DenseI32ArrayAttr numGangsSegments, /*optional*/::mlir::ArrayAttr numGangsDeviceType, ::mlir::ValueRange numWorkers, /*optional*/::mlir::ArrayAttr numWorkersDeviceType, ::mlir::ValueRange vectorLength, /*optional*/::mlir::ArrayAttr vectorLengthDeviceType, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizationRecipes, ::mlir::ValueRange firstprivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizationRecipes, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr, /*optional*/bool combined = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ParallelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ParallelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 16 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// The number of data operands.
  unsigned getNumDataOperands();

  /// The i-th data operand passed.
  Value getDataOperand(unsigned i);

  /// Used to retrieve the block inside the op's region.
  Block &getBody() { return getRegion().front(); }

  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly();
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType);
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue();
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType);

  /// Return the value of the num_workers clause if present.
  mlir::Value getNumWorkersValue();
  /// Return the value of the num_workers clause for the given device_type if
  /// present.
  mlir::Value getNumWorkersValue(mlir::acc::DeviceType deviceType);

  /// Return the value of the vector_length clause if present.
  mlir::Value getVectorLengthValue();
  /// Return the value of the vector_length clause for the given device_type 
  /// if present.
  mlir::Value getVectorLengthValue(mlir::acc::DeviceType deviceType);

  /// Return the values of the num_gangs clause if present.
  mlir::Operation::operand_range getNumGangsValues();
  /// Return the values of the num_gangs clause for the given device_type if
  /// present.
  mlir::Operation::operand_range
  getNumGangsValues(mlir::acc::DeviceType deviceType);

  /// Return true if the op has the wait attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasWaitOnly();
  /// Return true if the op has the wait attribute for the given device_type.
  bool hasWaitOnly(mlir::acc::DeviceType deviceType);
  /// Return the values of the wait clause if present.
  mlir::Operation::operand_range getWaitValues();
  /// Return the values of the wait clause for the given device_type if
  /// present.
  mlir::Operation::operand_range
  getWaitValues(mlir::acc::DeviceType deviceType);
  /// Return the wait devnum value clause if present;
  mlir::Value getWaitDevnum();
  /// Return the wait devnum value clause for the given device_type if
  /// present.
  mlir::Value getWaitDevnum(mlir::acc::DeviceType deviceType);
  static mlir::acc::Construct getConstructId() {
    return mlir::acc::Construct::acc_construct_parallel;
  }
  /// Add a value to 'num_workers' with the current list of device types.
  void addNumWorkersOperand(MLIRContext *, mlir::Value,
                            llvm::ArrayRef<DeviceType>);
  /// Add a value to 'vector_length' with the current list of device types.
  void addVectorLengthOperand(MLIRContext *, mlir::Value,
                              llvm::ArrayRef<DeviceType>);
  /// Add an entry to the 'async-only' attribute (clause spelled without
  /// arguments)for each of the additional device types (or a none if it is
  /// empty).
  void addAsyncOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add a value to the 'async' with the current list of device types.
  void addAsyncOperand(MLIRContext *, mlir::Value,
                       llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry to the 'num_gangs' with the current list of
  /// device types.
  void addNumGangsOperands(MLIRContext *, mlir::ValueRange,
                           llvm::ArrayRef<DeviceType>);
  /// Add an entry to the 'wait-only' attribute (clause spelled without
  /// arguments)for each of the additional device types (or a none if it is
  /// empty).
  void addWaitOnly(MLIRContext *, llvm::ArrayRef<DeviceType>);
  /// Add an array-like entry  to the 'wait' with the current list of device
  /// types.
  void addWaitOperands(MLIRContext *, bool hasDevnum, mlir::ValueRange,
                       llvm::ArrayRef<DeviceType>);

  /// Adds a private clause variable to this operation, including its recipe.
  void addPrivatization(MLIRContext *, mlir::acc::PrivateOp op,
                        mlir::acc::PrivateRecipeOp recipe);
  /// Adds a firstprivate clause variable to this operation, including its
  /// recipe.
  void addFirstPrivatization(MLIRContext *, mlir::acc::FirstprivateOp op,
                             mlir::acc::FirstprivateRecipeOp recipe);

  /// Adds a reduction clause variable to this operation, including its
  /// recipe.
  void addReduction(MLIRContext *, mlir::acc::ReductionOp op,
                    mlir::acc::ReductionRecipeOp recipe);
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::ParallelOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::PresentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PresentOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PresentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.present", odsAttrs.getContext());
  }

  PresentOpGenericAdaptorBase(PresentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class PresentOpGenericAdaptor : public detail::PresentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PresentOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  PresentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PresentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PresentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PresentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : PresentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PresentOpGenericAdaptor(RangeT values, const PresentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PresentOp, typename = std::enable_if_t<std::is_same_v<LateInst, PresentOp>>>
  PresentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PresentOpAdaptor : public PresentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PresentOpGenericAdaptor::PresentOpGenericAdaptor;
  PresentOpAdaptor(PresentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PresentOp : public ::mlir::Op<PresentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PresentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PresentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.present");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::PresentOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::PrivateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PrivateOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PrivateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.private", odsAttrs.getContext());
  }

  PrivateOpGenericAdaptorBase(PrivateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class PrivateOpGenericAdaptor : public detail::PrivateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PrivateOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  PrivateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PrivateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PrivateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PrivateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : PrivateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PrivateOpGenericAdaptor(RangeT values, const PrivateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PrivateOp, typename = std::enable_if_t<std::is_same_v<LateInst, PrivateOp>>>
  PrivateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PrivateOpAdaptor : public PrivateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PrivateOpGenericAdaptor::PrivateOpGenericAdaptor;
  PrivateOpAdaptor(PrivateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PrivateOp : public ::mlir::Op<PrivateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PrivateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PrivateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.private");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PrivateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PrivateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::PrivateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::PrivateRecipeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class PrivateRecipeOpGenericAdaptorBase {
public:
  struct Properties {
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using typeTy = ::mlir::TypeAttr;
    typeTy type;

    auto getType() const {
      auto &propStorage = this->type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setType(const ::mlir::TypeAttr &propValue) {
      this->type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.sym_name == this->sym_name &&
        rhs.type == this->type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PrivateRecipeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.private.recipe", odsAttrs.getContext());
  }

  PrivateRecipeOpGenericAdaptorBase(PrivateRecipeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
    return attr;
  }

  ::mlir::Type getType();
  ::mlir::Region &getInitRegion() {
    return *odsRegions[0];
  }

  ::mlir::Region &getDestroyRegion() {
    return *odsRegions[1];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class PrivateRecipeOpGenericAdaptor : public detail::PrivateRecipeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PrivateRecipeOpGenericAdaptorBase;
public:
  PrivateRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PrivateRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PrivateRecipeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PrivateRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PrivateRecipeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PrivateRecipeOpGenericAdaptor(RangeT values, const PrivateRecipeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PrivateRecipeOp, typename = std::enable_if_t<std::is_same_v<LateInst, PrivateRecipeOp>>>
  PrivateRecipeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PrivateRecipeOpAdaptor : public PrivateRecipeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PrivateRecipeOpGenericAdaptor::PrivateRecipeOpGenericAdaptor;
  PrivateRecipeOpAdaptor(PrivateRecipeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PrivateRecipeOp : public ::mlir::Op<PrivateRecipeOp, ::mlir::OpTrait::NRegions<2>::Impl, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait, ::mlir::accomp::RecipeInterface::Trait, ::mlir::OpTrait::AutomaticAllocationScope> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PrivateRecipeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PrivateRecipeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("sym_name"), ::llvm::StringRef("type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.private.recipe");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getInitRegion() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getDestroyRegion() {
    return (*this)->getRegion(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  }

  ::mlir::Type getType();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setTypeAttr(::mlir::TypeAttr attr) {
    getProperties().type = attr;
  }

  void setType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static PrivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static PrivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static PrivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static PrivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type);
  static PrivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::Type type);
  static PrivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::Type type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type);
  static PrivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type);
  static PrivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PrivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PrivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PrivateRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PrivateRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::PrivateRecipeOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ReductionOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ReductionOpGenericAdaptorBase {
public:
  struct Properties {
    using asyncOnlyTy = ::mlir::ArrayAttr;
    asyncOnlyTy asyncOnly;

    auto getAsyncOnly() const {
      auto &propStorage = this->asyncOnly;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOnly(const ::mlir::ArrayAttr &propValue) {
      this->asyncOnly = propValue;
    }
    using asyncOperandsDeviceTypeTy = ::mlir::ArrayAttr;
    asyncOperandsDeviceTypeTy asyncOperandsDeviceType;

    auto getAsyncOperandsDeviceType() const {
      auto &propStorage = this->asyncOperandsDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAsyncOperandsDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->asyncOperandsDeviceType = propValue;
    }
    using dataClauseTy = ::mlir::acc::DataClauseAttr;
    dataClauseTy dataClause;

    auto getDataClause() const {
      auto &propStorage = this->dataClause;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(propStorage);
    }
    void setDataClause(const ::mlir::acc::DataClauseAttr &propValue) {
      this->dataClause = propValue;
    }
    using implicitTy = ::mlir::BoolAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setImplicit(const ::mlir::BoolAttr &propValue) {
      this->implicit = propValue;
    }
    using modifiersTy = ::mlir::acc::DataClauseModifierAttr;
    modifiersTy modifiers;

    auto getModifiers() const {
      auto &propStorage = this->modifiers;
      return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(propStorage);
    }
    void setModifiers(const ::mlir::acc::DataClauseModifierAttr &propValue) {
      this->modifiers = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using structuredTy = ::mlir::BoolAttr;
    structuredTy structured;

    auto getStructured() const {
      auto &propStorage = this->structured;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setStructured(const ::mlir::BoolAttr &propValue) {
      this->structured = propValue;
    }
    using varTypeTy = ::mlir::TypeAttr;
    varTypeTy varType;

    auto getVarType() const {
      auto &propStorage = this->varType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setVarType(const ::mlir::TypeAttr &propValue) {
      this->varType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asyncOnly == this->asyncOnly &&
        rhs.asyncOperandsDeviceType == this->asyncOperandsDeviceType &&
        rhs.dataClause == this->dataClause &&
        rhs.implicit == this->implicit &&
        rhs.modifiers == this->modifiers &&
        rhs.name == this->name &&
        rhs.structured == this->structured &&
        rhs.varType == this->varType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReductionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.reduction", odsAttrs.getContext());
  }

  ReductionOpGenericAdaptorBase(ReductionOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
    return attr;
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr();
  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr();
  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr();
  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getName();
};
} // namespace detail
template <typename RangeT>
class ReductionOpGenericAdaptor : public detail::ReductionOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReductionOpGenericAdaptorBase;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
public:
  ReductionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReductionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReductionOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReductionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ReductionOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReductionOpGenericAdaptor(RangeT values, const ReductionOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReductionOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReductionOp>>>
  ReductionOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getBounds() {
    return getODSOperands(2);
  }

  RangeT getAsyncOperands() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReductionOpAdaptor : public ReductionOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReductionOpGenericAdaptor::ReductionOpGenericAdaptor;
  ReductionOpAdaptor(ReductionOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReductionOp : public ::mlir::Op<ReductionOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReductionOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReductionOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_var = 0;
  static constexpr int odsIndex_varPtrPtr = 1;
  static constexpr int odsIndex_bounds = 2;
  static constexpr int odsIndex_asyncOperands = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asyncOnly"), ::llvm::StringRef("asyncOperandsDeviceType"), ::llvm::StringRef("dataClause"), ::llvm::StringRef("implicit"), ::llvm::StringRef("modifiers"), ::llvm::StringRef("name"), ::llvm::StringRef("structured"), ::llvm::StringRef("varType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsyncOnlyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsyncOnlyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsyncOperandsDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataClauseAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataClauseAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getModifiersAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getModifiersAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStructuredAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStructuredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.reduction");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::acc::PointerLikeType> getVarPtrPtr() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getBounds() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getAsyncOperands() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getVarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getVarPtrPtrMutable();
  ::mlir::MutableOperandRange getBoundsMutable();
  ::mlir::MutableOperandRange getAsyncOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAccVar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().varType);
  }

  ::mlir::Type getVarType();
  ::mlir::ArrayAttr getAsyncOperandsDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOperandsDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOperandsDeviceType();
  ::mlir::ArrayAttr getAsyncOnlyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().asyncOnly);
  }

  ::std::optional< ::mlir::ArrayAttr > getAsyncOnly();
  ::mlir::acc::DataClauseAttr getDataClauseAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  }

  ::mlir::acc::DataClause getDataClause();
  ::mlir::BoolAttr getStructuredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  }

  bool getStructured();
  ::mlir::BoolAttr getImplicitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  }

  bool getImplicit();
  ::mlir::acc::DataClauseModifierAttr getModifiersAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseModifierAttr>(getProperties().modifiers);
  }

  ::mlir::acc::DataClauseModifier getModifiers();
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::std::optional< ::llvm::StringRef > getName();
  void setVarTypeAttr(::mlir::TypeAttr attr) {
    getProperties().varType = attr;
  }

  void setVarType(::mlir::Type attrValue);
  void setAsyncOperandsDeviceTypeAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOperandsDeviceType = attr;
  }

  void setAsyncOnlyAttr(::mlir::ArrayAttr attr) {
    getProperties().asyncOnly = attr;
  }

  void setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
    getProperties().dataClause = attr;
  }

  void setDataClause(::mlir::acc::DataClause attrValue);
  void setStructuredAttr(::mlir::BoolAttr attr) {
    getProperties().structured = attr;
  }

  void setStructured(bool attrValue);
  void setImplicitAttr(::mlir::BoolAttr attr) {
    getProperties().implicit = attr;
  }

  void setImplicit(bool attrValue);
  void setModifiersAttr(::mlir::acc::DataClauseModifierAttr attr) {
    getProperties().modifiers = attr;
  }

  void setModifiers(::mlir::acc::DataClauseModifier attrValue);
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeAsyncOperandsDeviceTypeAttr() {
      auto attr = getProperties().asyncOperandsDeviceType;
      getProperties().asyncOperandsDeviceType = {};
      return attr;
  }

  ::mlir::Attribute removeAsyncOnlyAttr() {
      auto attr = getProperties().asyncOnly;
      getProperties().asyncOnly = {};
      return attr;
  }

  ::mlir::Attribute removeNameAttr() {
      auto attr = getProperties().name;
      getProperties().name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value var, bool structured, bool implicit, const ::llvm::Twine &name, ::mlir::ValueRange bounds = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVarType, ::mlir::Value var, ::mlir::Type varType, ::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, ::mlir::ArrayAttr asyncOperandsDeviceType, ::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::TypeAttr varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, ::mlir::acc::DataClauseModifierAttr modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type accVar, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value var, ::mlir::Type varType, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::ValueRange asyncOperands, /*optional*/::mlir::ArrayAttr asyncOperandsDeviceType, /*optional*/::mlir::ArrayAttr asyncOnly, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, ::mlir::acc::DataClauseModifier modifiers, /*optional*/::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return true if the op has the async attribute for the
  /// mlir::acc::DeviceType::None device_type.
  bool hasAsyncOnly() {
    return hasAsyncOnly(mlir::acc::DeviceType::None);
  }
  /// Return true if the op has the async attribute for the given device_type.
  bool hasAsyncOnly(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr asyncOnly = getAsyncOnlyAttr();
    if (!asyncOnly)
      return false;
    for (auto attr : asyncOnly) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return true;
    }
    return false;
  }
  /// Return the value of the async clause if present.
  mlir::Value getAsyncValue() {
    return getAsyncValue(mlir::acc::DeviceType::None);
  }
  /// Return the value of the async clause for the given device_type if
  /// present.
  mlir::Value getAsyncValue(mlir::acc::DeviceType deviceType) {
    mlir::ArrayAttr deviceTypes = getAsyncOperandsDeviceTypeAttr();
    if (!deviceTypes)
      return nullptr;
    for (auto [attr, asyncValue] :
        llvm::zip(deviceTypes, getAsyncOperands())) {
      auto deviceTypeAttr = mlir::dyn_cast<mlir::acc::DeviceTypeAttr>(attr);
      if (deviceTypeAttr.getValue() == deviceType)
        return asyncValue;
    }
    return nullptr;
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getVarPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getVar());
  }
  mlir::TypedValue<mlir::acc::PointerLikeType> getAccPtr() {
    return mlir::dyn_cast<mlir::TypedValue<mlir::acc::PointerLikeType>>(getAccVar());
  }
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::ReductionOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ReductionRecipeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ReductionRecipeOpGenericAdaptorBase {
public:
  struct Properties {
    using reductionOperatorTy = ::mlir::acc::ReductionOperatorAttr;
    reductionOperatorTy reductionOperator;

    auto getReductionOperator() const {
      auto &propStorage = this->reductionOperator;
      return ::llvm::cast<::mlir::acc::ReductionOperatorAttr>(propStorage);
    }
    void setReductionOperator(const ::mlir::acc::ReductionOperatorAttr &propValue) {
      this->reductionOperator = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using typeTy = ::mlir::TypeAttr;
    typeTy type;

    auto getType() const {
      auto &propStorage = this->type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setType(const ::mlir::TypeAttr &propValue) {
      this->type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.reductionOperator == this->reductionOperator &&
        rhs.sym_name == this->sym_name &&
        rhs.type == this->type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReductionRecipeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.reduction.recipe", odsAttrs.getContext());
  }

  ReductionRecipeOpGenericAdaptorBase(ReductionRecipeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
    return attr;
  }

  ::mlir::Type getType();
  ::mlir::acc::ReductionOperatorAttr getReductionOperatorAttr() {
    auto attr = ::llvm::cast<::mlir::acc::ReductionOperatorAttr>(getProperties().reductionOperator);
    return attr;
  }

  ::mlir::acc::ReductionOperator getReductionOperator();
  ::mlir::Region &getInitRegion() {
    return *odsRegions[0];
  }

  ::mlir::Region &getCombinerRegion() {
    return *odsRegions[1];
  }

  ::mlir::Region &getDestroyRegion() {
    return *odsRegions[2];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class ReductionRecipeOpGenericAdaptor : public detail::ReductionRecipeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReductionRecipeOpGenericAdaptorBase;
public:
  ReductionRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReductionRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReductionRecipeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReductionRecipeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ReductionRecipeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReductionRecipeOpGenericAdaptor(RangeT values, const ReductionRecipeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReductionRecipeOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReductionRecipeOp>>>
  ReductionRecipeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReductionRecipeOpAdaptor : public ReductionRecipeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReductionRecipeOpGenericAdaptor::ReductionRecipeOpGenericAdaptor;
  ReductionRecipeOpAdaptor(ReductionRecipeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReductionRecipeOp : public ::mlir::Op<ReductionRecipeOp, ::mlir::OpTrait::NRegions<3>::Impl, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait, ::mlir::accomp::RecipeInterface::Trait, ::mlir::OpTrait::AutomaticAllocationScope> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReductionRecipeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReductionRecipeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("reductionOperator"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReductionOperatorAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReductionOperatorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.reduction.recipe");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getInitRegion() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getCombinerRegion() {
    return (*this)->getRegion(1);
  }

  ::mlir::Region &getDestroyRegion() {
    return (*this)->getRegion(2);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  }

  ::mlir::Type getType();
  ::mlir::acc::ReductionOperatorAttr getReductionOperatorAttr() {
    return ::llvm::cast<::mlir::acc::ReductionOperatorAttr>(getProperties().reductionOperator);
  }

  ::mlir::acc::ReductionOperator getReductionOperator();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setTypeAttr(::mlir::TypeAttr attr) {
    getProperties().type = attr;
  }

  void setType(::mlir::Type attrValue);
  void setReductionOperatorAttr(::mlir::acc::ReductionOperatorAttr attr) {
    getProperties().reductionOperator = attr;
  }

  void setReductionOperator(::mlir::acc::ReductionOperator attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator);
  static ReductionRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator);
  static ReductionRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator);
  static ReductionRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator);
  static ReductionRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator);
  static ReductionRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator);
  static ReductionRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator);
  static ReductionRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator);
  static ReductionRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReductionRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReductionRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReductionRecipeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReductionRecipeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace acc
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::acc::ReductionRecipeOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::RoutineOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class RoutineOpGenericAdaptorBase {
public:
  struct Properties {
    using bindIdNameTy = ::mlir::ArrayAttr;
    bindIdNameTy bindIdName;

    auto getBindIdName() const {
      auto &propStorage = this->bindIdName;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setBindIdName(const ::mlir::ArrayAttr &propValue) {
      this->bindIdName = propValue;
    }
    using bindIdNameDeviceTypeTy = ::mlir::ArrayAttr;
    bindIdNameDeviceTypeTy bindIdNameDeviceType;

    auto getBindIdNameDeviceType() const {
      auto &propStorage = this->bindIdNameDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setBindIdNameDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->bindIdNameDeviceType = propValue;
    }
    using bindStrNameTy = ::mlir::ArrayAttr;
    bindStrNameTy bindStrName;

    auto getBindStrName() const {
      auto &propStorage = this->bindStrName;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setBindStrName(const ::mlir::ArrayAttr &propValue) {
      this->bindStrName = propValue;
    }
    using bindStrNameDeviceTypeTy = ::mlir::ArrayAttr;
    bindStrNameDeviceTypeTy bindStrNameDeviceType;

    auto getBindStrNameDeviceType() const {
      auto &propStorage = this->bindStrNameDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setBindStrNameDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->bindStrNameDeviceType = propValue;
    }
    using func_nameTy = ::mlir::SymbolRefAttr;
    func_nameTy func_name;

    auto getFuncName() const {
      auto &propStorage = this->func_name;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setFuncName(const ::mlir::SymbolRefAttr &propValue) {
      this->func_name = propValue;
    }
    using gangTy = ::mlir::ArrayAttr;
    gangTy gang;

    auto getGang() const {
      auto &propStorage = this->gang;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setGang(const ::mlir::ArrayAttr &propValue) {
      this->gang = propValue;
    }
    using gangDimTy = ::mlir::ArrayAttr;
    gangDimTy gangDim;

    auto getGangDim() const {
      auto &propStorage = this->gangDim;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setGangDim(const ::mlir::ArrayAttr &propValue) {
      this->gangDim = propValue;
    }
    using gangDimDeviceTypeTy = ::mlir::ArrayAttr;
    gangDimDeviceTypeTy gangDimDeviceType;

    auto getGangDimDeviceType() const {
      auto &propStorage = this->gangDimDeviceType;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setGangDimDeviceType(const ::mlir::ArrayAttr &propValue) {
      this->gangDimDeviceType = propValue;
    }
    using implicitTy = ::mlir::UnitAttr;
    implicitTy implicit;

    auto getImplicit() const {
      auto &propStorage = this->implicit;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setImplicit(const ::mlir::UnitAttr &propValue) {
      this->implicit = propValue;
    }
    using nohostTy = ::mlir::UnitAttr;
    nohostTy nohost;

    auto getNohost() const {
      auto &propStorage = this->nohost;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNohost(const ::mlir::UnitAttr &propValue) {
      this->nohost = propValue;
    }
    using seqTy = ::mlir::ArrayAttr;
    seqTy seq;

    auto getSeq() const {
      auto &propStorage = this->seq;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setSeq(const ::mlir::ArrayAttr &propValue) {
      this->seq = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using vectorTy = ::mlir::ArrayAttr;
    vectorTy vector;

    auto getVector() const {
      auto &propStorage = this->vector;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setVector(const ::mlir::ArrayAttr &propValue) {
      this->vector = propValue;
    }
    using workerTy = ::mlir::ArrayAttr;
    workerTy worker;

    auto getWorker() const {
      auto &propStorage = this->worker;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setWorker(const ::mlir::ArrayAttr &propValue) {
      this->worker = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bindIdName == this->bindIdName &&
        rhs.bindIdNameDeviceType == this->bindIdNameDeviceType &&
        rhs.bindStrName == this->bindStrName &&
        rhs.bindStrNameDeviceType == this->bindStrNameDeviceType &&
        rhs.func_name == this->func_name &&
        rhs.gang == this->gang &&
        rhs.gangDim == this->gangDim &&
        rhs.gangDimDeviceType == this->gangDimDeviceType &&
        rhs.implicit == this->implicit &&
        rhs.nohost == this->nohost &&
        rhs.seq == this->seq &&
        rhs.sym_name == this->sym_name &&
        rhs.vector == this->vector &&
        rhs.worker == this->worker &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  RoutineOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("acc.routine", odsAttrs.getContext());
  }

  RoutineOpGenericAdaptorBase(RoutineOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::SymbolRefAttr getFuncNameAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().func_name);
    return attr;
  }

  ::mlir::SymbolRefAttr getFuncName();
  ::mlir::ArrayAttr getBindIdNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindIdName);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getBindIdName();
  ::mlir::ArrayAttr getBindStrNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindStrName);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getBindStrName();
  ::mlir::ArrayAttr getBindIdNameDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindIdNameDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getBindIdNameDeviceType();
  ::mlir::ArrayAttr getBindStrNameDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindStrNameDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getBindStrNameDeviceType();
  ::mlir::ArrayAttr getWorkerAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().worker);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getWorker();
  ::mlir::ArrayAttr getVectorAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().vector);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getVector();
  ::mlir::ArrayAttr getSeqAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().seq);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getSeq();
  ::mlir::UnitAttr getNohostAttr();
  bool getNohost();
  ::mlir::UnitAttr getImplicitAttr();
  bool getImplicit();
  ::mlir::ArrayAttr getGangAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gang);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getGang();
  ::mlir::ArrayAttr getGangDimAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gangDim);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getGangDim();
  ::mlir::ArrayAttr getGangDimDeviceTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().gangDimDeviceType);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getGangDimDeviceType();
};
} // namespace detail
template <typename RangeT>
class RoutineOpGenericAdaptor : public detail::RoutineOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::RoutineOpGenericAdaptorBase;
public:
  RoutineOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  RoutineOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : RoutineOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  RoutineOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : RoutineOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  RoutineOpGenericAdaptor(RangeT values, const RoutineOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = RoutineOp, typename = std::enable_if_t<std::is_same_v<LateInst, RoutineOp>>>
  RoutineOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class RoutineOpAdaptor : public RoutineOpGenericAdaptor<::mlir::ValueRange> {
public:
  using RoutineOpGenericAdaptor::RoutineOpGenericAdaptor;
  RoutineOpAdaptor(RoutineOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class RoutineOp : public ::mlir::Op<RoutineOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = RoutineOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = RoutineOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bindIdName"), ::llvm::StringRef("bindIdNameDeviceType"), ::llvm::StringRef("bindStrName"), ::llvm::StringRef("bindStrNameDeviceType"), ::llvm::StringRef("func_name"), ::llvm::StringRef("gang"), ::llvm::StringRef("gangDim"), ::llvm::StringRef("gangDimDeviceType"), ::llvm::StringRef("implicit"), ::llvm::StringRef("nohost"), ::llvm::StringRef("seq"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("vector"), ::llvm::StringRef("worker")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBindIdNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBindIdNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBindIdNameDeviceTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBindIdNameDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getBindStrNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getBindStrNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getBindStrNameDeviceTypeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getBindStrNameDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getFuncNameAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getFuncNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getGangAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getGangAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getGangDimAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getGangDimAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getGangDimDeviceTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getGangDimDeviceTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getImplicitAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getImplicitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getNohostAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getNohostAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getSeqAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getSeqAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getVectorAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getVectorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getWorkerAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getWorkerAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("acc.routine");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::SymbolRefAttr getFuncNameAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().func_name);
  }

  ::mlir::SymbolRefAttr getFuncName();
  ::mlir::ArrayAttr getBindIdNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindIdName);
  }

  ::std::optional< ::mlir::ArrayAttr > getBindIdName();
  ::mlir::ArrayAttr getBindStrNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindStrName);
  }

  ::std::optional< ::mlir::ArrayAttr > getBindStrName();
  ::mlir::ArrayAttr getBindIdNameDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindIdNameDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getBindIdNameDeviceType();
  ::mlir::ArrayAttr getBindStrNameDeviceTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().bindStrNameDeviceType);
  }

  ::std::optional< ::mlir::ArrayAttr > getBindStrNameDeviceType();
  ::mlir::ArrayAttr getWorkerAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().worker);
  }

  ::std::optional< ::mlir::ArrayAttr > 