/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: XeVMOps.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::xevm::BlockLoad2dOp,
::mlir::xevm::BlockLoadOp,
::mlir::xevm::BlockPrefetch2dOp,
::mlir::xevm::BlockStore2dOp,
::mlir::xevm::BlockStoreOp,
::mlir::xevm::GridDimXOp,
::mlir::xevm::GridDimYOp,
::mlir::xevm::GridDimZOp,
::mlir::xevm::LaneIdOp,
::mlir::xevm::MMAOp,
::mlir::xevm::MemfenceOp,
::mlir::xevm::PrefetchOp,
::mlir::xevm::SubgroupIdOp,
::mlir::xevm::SubgroupSizeOp,
::mlir::xevm::WorkgroupDimXOp,
::mlir::xevm::WorkgroupDimYOp,
::mlir::xevm::WorkgroupDimZOp,
::mlir::xevm::WorkgroupIdXOp,
::mlir::xevm::WorkgroupIdYOp,
::mlir::xevm::WorkgroupIdZOp,
::mlir::xevm::WorkitemIdXOp,
::mlir::xevm::WorkitemIdYOp,
::mlir::xevm::WorkitemIdZOp
#endif // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace xevm {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeVMOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM pointer type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeVMOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(32)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeVMOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((::llvm::isa<::mlir::FixedVectorType>(type))) && ([](::mlir::Type elementType) { return ((elementType.isInteger(8))) || ((elementType.isInteger(16))) || ((elementType.isInteger(32))) || ((elementType.isF32())) || ((::llvm::isa<::mlir::FloatTF32Type>(elementType))) || ((elementType.isF16())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be fixed-length vector of 8-bit integer or 16-bit integer or 32-bit integer or 32-bit float or tf32 type or 16-bit float or bfloat16 type values of ranks 1, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeVMOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((::llvm::isa<::mlir::FixedVectorType>(type))) && ([](::mlir::Type elementType) { return ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be fixed-length vector of 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer values of ranks 1, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeVMOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isSignlessInteger(32))) || ((type.isSignlessInteger(64))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 32-bit signless integer or 64-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeVMOps6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))) && ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).getAddressSpace() == 1))) || (((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))) && ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).getAddressSpace() == 4))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM pointer in address space 1 or LLVM pointer in address space 4, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(1)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 1-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xevm::LoadCacheControlAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describe the cache settings for load operators";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xevm::StoreCacheControlAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describe the cache settings for store operators";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xevm::MMAShapeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: ";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xevm::MMATypesAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: ";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps8(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xevm::MemScopeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describe memory scopes";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps8(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps9(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xevm::AddrSpaceAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describe address spaces";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeVMOps9(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeVMOps9(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
} // namespace xevm
} // namespace mlir
namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::BlockLoad2dOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BlockLoad2dOpGenericAdaptorBase::BlockLoad2dOpGenericAdaptorBase(BlockLoad2dOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t BlockLoad2dOpGenericAdaptorBase::getElemSizeInBits() {
  auto attr = getElemSizeInBitsAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockLoad2dOpGenericAdaptorBase::getTileWidth() {
  auto attr = getTileWidthAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockLoad2dOpGenericAdaptorBase::getTileHeight() {
  auto attr = getTileHeightAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockLoad2dOpGenericAdaptorBase::getVBlocks() {
  auto attr = getVBlocksAttr();
  return attr.getValue().getZExtValue();
}

bool BlockLoad2dOpGenericAdaptorBase::getTranspose() {
  auto attr = getTransposeAttr();
  return attr.getValue().getZExtValue();
}

bool BlockLoad2dOpGenericAdaptorBase::getPackRegister() {
  auto attr = getPackRegisterAttr();
  return attr.getValue().getZExtValue();
}

::std::optional<::mlir::xevm::LoadCacheControl> BlockLoad2dOpGenericAdaptorBase::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
BlockLoad2dOpAdaptor::BlockLoad2dOpAdaptor(BlockLoad2dOp op) : BlockLoad2dOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult BlockLoad2dOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;
  auto tblgen_elem_size_in_bits = getProperties().elem_size_in_bits; (void)tblgen_elem_size_in_bits;
  if (!tblgen_elem_size_in_bits) return emitError(loc, "'xevm.blockload2d' op ""requires attribute 'elem_size_in_bits'");
  auto tblgen_pack_register = getProperties().pack_register; (void)tblgen_pack_register;
  if (!tblgen_pack_register) return emitError(loc, "'xevm.blockload2d' op ""requires attribute 'pack_register'");
  auto tblgen_tile_height = getProperties().tile_height; (void)tblgen_tile_height;
  if (!tblgen_tile_height) return emitError(loc, "'xevm.blockload2d' op ""requires attribute 'tile_height'");
  auto tblgen_tile_width = getProperties().tile_width; (void)tblgen_tile_width;
  if (!tblgen_tile_width) return emitError(loc, "'xevm.blockload2d' op ""requires attribute 'tile_width'");
  auto tblgen_transpose = getProperties().transpose; (void)tblgen_transpose;
  if (!tblgen_transpose) return emitError(loc, "'xevm.blockload2d' op ""requires attribute 'transpose'");
  auto tblgen_v_blocks = getProperties().v_blocks; (void)tblgen_v_blocks;
  if (!tblgen_v_blocks) return emitError(loc, "'xevm.blockload2d' op ""requires attribute 'v_blocks'");

  if (tblgen_elem_size_in_bits && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_elem_size_in_bits))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_elem_size_in_bits).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'elem_size_in_bits' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_tile_width && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_tile_width))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_tile_width).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'tile_width' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_tile_height && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_tile_height))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_tile_height).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'tile_height' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_v_blocks && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_v_blocks))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_v_blocks).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'v_blocks' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_transpose && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_transpose))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_transpose).getType().isSignlessInteger(1)))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'transpose' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_pack_register && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_pack_register))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_pack_register).getType().isSignlessInteger(1)))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'pack_register' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_cache_control && !((::llvm::isa<::mlir::xevm::LoadCacheControlAttr>(tblgen_cache_control))))
    return emitError(loc, "'xevm.blockload2d' op ""attribute 'cache_control' failed to satisfy constraint: Describe the cache settings for load operators");
  return ::mlir::success();
}

::llvm::LogicalResult BlockLoad2dOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache_control;
       auto attr = dict.get("cache_control");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.elem_size_in_bits;
       auto attr = dict.get("elem_size_in_bits");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_size_in_bits` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.pack_register;
       auto attr = dict.get("pack_register");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `pack_register` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tile_height;
       auto attr = dict.get("tile_height");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_height` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tile_width;
       auto attr = dict.get("tile_width");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_width` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.transpose;
       auto attr = dict.get("transpose");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `transpose` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.v_blocks;
       auto attr = dict.get("v_blocks");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `v_blocks` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute BlockLoad2dOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache_control;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache_control",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.elem_size_in_bits;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("elem_size_in_bits",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.pack_register;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("pack_register",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tile_height;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tile_height",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tile_width;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tile_width",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.transpose;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("transpose",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.v_blocks;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("v_blocks",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code BlockLoad2dOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache_control.getAsOpaquePointer()), 
    llvm::hash_value(prop.elem_size_in_bits.getAsOpaquePointer()), 
    llvm::hash_value(prop.pack_register.getAsOpaquePointer()), 
    llvm::hash_value(prop.tile_height.getAsOpaquePointer()), 
    llvm::hash_value(prop.tile_width.getAsOpaquePointer()), 
    llvm::hash_value(prop.transpose.getAsOpaquePointer()), 
    llvm::hash_value(prop.v_blocks.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> BlockLoad2dOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache_control")
      return prop.cache_control;

    if (name == "elem_size_in_bits")
      return prop.elem_size_in_bits;

    if (name == "pack_register")
      return prop.pack_register;

    if (name == "tile_height")
      return prop.tile_height;

    if (name == "tile_width")
      return prop.tile_width;

    if (name == "transpose")
      return prop.transpose;

    if (name == "v_blocks")
      return prop.v_blocks;
  return std::nullopt;
}

void BlockLoad2dOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache_control") {
       prop.cache_control = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache_control)>>(value);
       return;
    }

    if (name == "elem_size_in_bits") {
       prop.elem_size_in_bits = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.elem_size_in_bits)>>(value);
       return;
    }

    if (name == "pack_register") {
       prop.pack_register = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.pack_register)>>(value);
       return;
    }

    if (name == "tile_height") {
       prop.tile_height = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tile_height)>>(value);
       return;
    }

    if (name == "tile_width") {
       prop.tile_width = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tile_width)>>(value);
       return;
    }

    if (name == "transpose") {
       prop.transpose = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.transpose)>>(value);
       return;
    }

    if (name == "v_blocks") {
       prop.v_blocks = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.v_blocks)>>(value);
       return;
    }
}

void BlockLoad2dOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache_control) attrs.append("cache_control", prop.cache_control);

    if (prop.elem_size_in_bits) attrs.append("elem_size_in_bits", prop.elem_size_in_bits);

    if (prop.pack_register) attrs.append("pack_register", prop.pack_register);

    if (prop.tile_height) attrs.append("tile_height", prop.tile_height);

    if (prop.tile_width) attrs.append("tile_width", prop.tile_width);

    if (prop.transpose) attrs.append("transpose", prop.transpose);

    if (prop.v_blocks) attrs.append("v_blocks", prop.v_blocks);
}

::llvm::LogicalResult BlockLoad2dOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheControlAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(attr, "cache_control", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getElemSizeInBitsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "elem_size_in_bits", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getPackRegisterAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps2(attr, "pack_register", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTileHeightAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "tile_height", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTileWidthAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "tile_width", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTransposeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps2(attr, "transpose", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getVBlocksAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "v_blocks", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult BlockLoad2dOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache_control)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.elem_size_in_bits)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.pack_register)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.tile_height)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.tile_width)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.transpose)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.v_blocks)))
    return ::mlir::failure();
  return ::mlir::success();
}

void BlockLoad2dOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache_control);
  writer.writeAttribute(prop.elem_size_in_bits);
  writer.writeAttribute(prop.pack_register);
  writer.writeAttribute(prop.tile_height);
  writer.writeAttribute(prop.tile_width);
  writer.writeAttribute(prop.transpose);
  writer.writeAttribute(prop.v_blocks);
}

uint32_t BlockLoad2dOp::getElemSizeInBits() {
  auto attr = getElemSizeInBitsAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockLoad2dOp::getTileWidth() {
  auto attr = getTileWidthAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockLoad2dOp::getTileHeight() {
  auto attr = getTileHeightAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockLoad2dOp::getVBlocks() {
  auto attr = getVBlocksAttr();
  return attr.getValue().getZExtValue();
}

bool BlockLoad2dOp::getTranspose() {
  auto attr = getTransposeAttr();
  return attr.getValue().getZExtValue();
}

bool BlockLoad2dOp::getPackRegister() {
  auto attr = getPackRegisterAttr();
  return attr.getValue().getZExtValue();
}

::std::optional<::mlir::xevm::LoadCacheControl> BlockLoad2dOp::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

void BlockLoad2dOp::setElemSizeInBits(uint32_t attrValue) {
  getProperties().elem_size_in_bits = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockLoad2dOp::setTileWidth(uint32_t attrValue) {
  getProperties().tile_width = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockLoad2dOp::setTileHeight(uint32_t attrValue) {
  getProperties().tile_height = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockLoad2dOp::setVBlocks(uint32_t attrValue) {
  getProperties().v_blocks = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockLoad2dOp::setTranspose(bool attrValue) {
  getProperties().transpose = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue);
}

void BlockLoad2dOp::setPackRegister(bool attrValue) {
  getProperties().pack_register = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue);
}

void BlockLoad2dOp::setCacheControl(::std::optional<::mlir::xevm::LoadCacheControl> attrValue) {
    auto &odsProp = getProperties().cache_control;
    if (attrValue)
      odsProp = ::mlir::xevm::LoadCacheControlAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void BlockLoad2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, ::mlir::IntegerAttr transpose, ::mlir::IntegerAttr pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = elem_size_in_bits;
  odsState.getOrAddProperties<Properties>().tile_width = tile_width;
  odsState.getOrAddProperties<Properties>().tile_height = tile_height;
  odsState.getOrAddProperties<Properties>().v_blocks = v_blocks;
  odsState.getOrAddProperties<Properties>().transpose = transpose;
  odsState.getOrAddProperties<Properties>().pack_register = pack_register;
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  odsState.addTypes(res);
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, ::mlir::IntegerAttr transpose, ::mlir::IntegerAttr pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockLoad2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, ::mlir::IntegerAttr transpose, ::mlir::IntegerAttr pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), res, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
}

void BlockLoad2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, ::mlir::IntegerAttr transpose, ::mlir::IntegerAttr pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = elem_size_in_bits;
  odsState.getOrAddProperties<Properties>().tile_width = tile_width;
  odsState.getOrAddProperties<Properties>().tile_height = tile_height;
  odsState.getOrAddProperties<Properties>().v_blocks = v_blocks;
  odsState.getOrAddProperties<Properties>().transpose = transpose;
  odsState.getOrAddProperties<Properties>().pack_register = pack_register;
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, ::mlir::IntegerAttr transpose, ::mlir::IntegerAttr pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockLoad2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, ::mlir::IntegerAttr transpose, ::mlir::IntegerAttr pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
}

void BlockLoad2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, bool transpose, bool pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_size_in_bits);
  odsState.getOrAddProperties<Properties>().tile_width = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_width);
  odsState.getOrAddProperties<Properties>().tile_height = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_height);
  odsState.getOrAddProperties<Properties>().v_blocks = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), v_blocks);
  odsState.getOrAddProperties<Properties>().transpose = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), transpose);
  odsState.getOrAddProperties<Properties>().pack_register = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), pack_register);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  odsState.addTypes(res);
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, bool transpose, bool pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockLoad2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, bool transpose, bool pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), res, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
}

void BlockLoad2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, bool transpose, bool pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_size_in_bits);
  odsState.getOrAddProperties<Properties>().tile_width = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_width);
  odsState.getOrAddProperties<Properties>().tile_height = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_height);
  odsState.getOrAddProperties<Properties>().v_blocks = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), v_blocks);
  odsState.getOrAddProperties<Properties>().transpose = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), transpose);
  odsState.getOrAddProperties<Properties>().pack_register = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), pack_register);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, bool transpose, bool pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockLoad2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, bool transpose, bool pack_register, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, transpose, pack_register, cache_control);
}

void BlockLoad2dOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<BlockLoad2dOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<BlockLoad2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void BlockLoad2dOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<BlockLoad2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoad2dOp BlockLoad2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult BlockLoad2dOp::verifyInvariantsImpl() {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;
  auto tblgen_elem_size_in_bits = getProperties().elem_size_in_bits; (void)tblgen_elem_size_in_bits;
  if (!tblgen_elem_size_in_bits) return emitOpError("requires attribute 'elem_size_in_bits'");
  auto tblgen_pack_register = getProperties().pack_register; (void)tblgen_pack_register;
  if (!tblgen_pack_register) return emitOpError("requires attribute 'pack_register'");
  auto tblgen_tile_height = getProperties().tile_height; (void)tblgen_tile_height;
  if (!tblgen_tile_height) return emitOpError("requires attribute 'tile_height'");
  auto tblgen_tile_width = getProperties().tile_width; (void)tblgen_tile_width;
  if (!tblgen_tile_width) return emitOpError("requires attribute 'tile_width'");
  auto tblgen_transpose = getProperties().transpose; (void)tblgen_transpose;
  if (!tblgen_transpose) return emitOpError("requires attribute 'transpose'");
  auto tblgen_v_blocks = getProperties().v_blocks; (void)tblgen_v_blocks;
  if (!tblgen_v_blocks) return emitOpError("requires attribute 'v_blocks'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_elem_size_in_bits, "elem_size_in_bits")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_tile_width, "tile_width")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_tile_height, "tile_height")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_v_blocks, "v_blocks")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps2(*this, tblgen_transpose, "transpose")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps2(*this, tblgen_pack_register, "pack_register")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(*this, tblgen_cache_control, "cache_control")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult BlockLoad2dOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult BlockLoad2dOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  [[maybe_unused]] ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult BlockLoad2dOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.elem_size_in_bits;
    auto elem_size_in_bitsAttrName = ::mlir::StringAttr::get(ctx, "elem_size_in_bits");
    auto attr = dict.get(elem_size_in_bitsAttrName);
    usedKeys.insert(elem_size_in_bitsAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for elem_size_in_bits in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_size_in_bits` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.tile_width;
    auto tile_widthAttrName = ::mlir::StringAttr::get(ctx, "tile_width");
    auto attr = dict.get(tile_widthAttrName);
    usedKeys.insert(tile_widthAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for tile_width in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_width` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.tile_height;
    auto tile_heightAttrName = ::mlir::StringAttr::get(ctx, "tile_height");
    auto attr = dict.get(tile_heightAttrName);
    usedKeys.insert(tile_heightAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for tile_height in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_height` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.v_blocks;
    auto v_blocksAttrName = ::mlir::StringAttr::get(ctx, "v_blocks");
    auto attr = dict.get(v_blocksAttrName);
    usedKeys.insert(v_blocksAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for v_blocks in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `v_blocks` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.transpose;
    auto transposeAttrName = ::mlir::StringAttr::get(ctx, "transpose");
    auto attr = dict.get(transposeAttrName);
    usedKeys.insert(transposeAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for transpose in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `transpose` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.pack_register;
    auto pack_registerAttrName = ::mlir::StringAttr::get(ctx, "pack_register");
    auto attr = dict.get(pack_registerAttrName);
    usedKeys.insert(pack_registerAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for pack_register in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `pack_register` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.cache_control;
    auto cache_controlAttrName = ::mlir::StringAttr::get(ctx, "cache_control");
    auto attr = dict.get(cache_controlAttrName);
    usedKeys.insert(cache_controlAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for cache_control in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void BlockLoad2dOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void BlockLoad2dOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::BlockLoad2dOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::BlockLoadOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BlockLoadOpGenericAdaptorBase::BlockLoadOpGenericAdaptorBase(BlockLoadOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xevm::LoadCacheControl> BlockLoadOpGenericAdaptorBase::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
BlockLoadOpAdaptor::BlockLoadOpAdaptor(BlockLoadOp op) : BlockLoadOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult BlockLoadOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;

  if (tblgen_cache_control && !((::llvm::isa<::mlir::xevm::LoadCacheControlAttr>(tblgen_cache_control))))
    return emitError(loc, "'xevm.blockload' op ""attribute 'cache_control' failed to satisfy constraint: Describe the cache settings for load operators");
  return ::mlir::success();
}

::llvm::LogicalResult BlockLoadOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache_control;
       auto attr = dict.get("cache_control");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute BlockLoadOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache_control;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache_control",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code BlockLoadOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache_control.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> BlockLoadOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache_control")
      return prop.cache_control;
  return std::nullopt;
}

void BlockLoadOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache_control") {
       prop.cache_control = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache_control)>>(value);
       return;
    }
}

void BlockLoadOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache_control) attrs.append("cache_control", prop.cache_control);
}

::llvm::LogicalResult BlockLoadOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheControlAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(attr, "cache_control", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult BlockLoadOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache_control)))
    return ::mlir::failure();
  return ::mlir::success();
}

void BlockLoadOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache_control);
}

::std::optional<::mlir::xevm::LoadCacheControl> BlockLoadOp::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

void BlockLoadOp::setCacheControl(::std::optional<::mlir::xevm::LoadCacheControl> attrValue) {
    auto &odsProp = getProperties().cache_control;
    if (attrValue)
      odsProp = ::mlir::xevm::LoadCacheControlAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void BlockLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  odsState.addTypes(res);
}

BlockLoadOp BlockLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, ptr, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoadOp BlockLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), res, ptr, cache_control);
}

void BlockLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockLoadOp BlockLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoadOp BlockLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, cache_control);
}

void BlockLoadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<BlockLoadOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

BlockLoadOp BlockLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<BlockLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoadOp BlockLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void BlockLoadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

BlockLoadOp BlockLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<BlockLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockLoadOp BlockLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult BlockLoadOp::verifyInvariantsImpl() {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(*this, tblgen_cache_control, "cache_control")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps4(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult BlockLoadOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult BlockLoadOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  [[maybe_unused]] ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult BlockLoadOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.cache_control;
    auto cache_controlAttrName = ::mlir::StringAttr::get(ctx, "cache_control");
    auto attr = dict.get(cache_controlAttrName);
    usedKeys.insert(cache_controlAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for cache_control in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void BlockLoadOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void BlockLoadOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::BlockLoadOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::BlockPrefetch2dOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BlockPrefetch2dOpGenericAdaptorBase::BlockPrefetch2dOpGenericAdaptorBase(BlockPrefetch2dOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t BlockPrefetch2dOpGenericAdaptorBase::getElemSizeInBits() {
  auto attr = getElemSizeInBitsAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockPrefetch2dOpGenericAdaptorBase::getTileWidth() {
  auto attr = getTileWidthAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockPrefetch2dOpGenericAdaptorBase::getTileHeight() {
  auto attr = getTileHeightAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockPrefetch2dOpGenericAdaptorBase::getVBlocks() {
  auto attr = getVBlocksAttr();
  return attr.getValue().getZExtValue();
}

::std::optional<::mlir::xevm::LoadCacheControl> BlockPrefetch2dOpGenericAdaptorBase::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
BlockPrefetch2dOpAdaptor::BlockPrefetch2dOpAdaptor(BlockPrefetch2dOp op) : BlockPrefetch2dOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult BlockPrefetch2dOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;
  auto tblgen_elem_size_in_bits = getProperties().elem_size_in_bits; (void)tblgen_elem_size_in_bits;
  if (!tblgen_elem_size_in_bits) return emitError(loc, "'xevm.blockprefetch2d' op ""requires attribute 'elem_size_in_bits'");
  auto tblgen_tile_height = getProperties().tile_height; (void)tblgen_tile_height;
  if (!tblgen_tile_height) return emitError(loc, "'xevm.blockprefetch2d' op ""requires attribute 'tile_height'");
  auto tblgen_tile_width = getProperties().tile_width; (void)tblgen_tile_width;
  if (!tblgen_tile_width) return emitError(loc, "'xevm.blockprefetch2d' op ""requires attribute 'tile_width'");
  auto tblgen_v_blocks = getProperties().v_blocks; (void)tblgen_v_blocks;
  if (!tblgen_v_blocks) return emitError(loc, "'xevm.blockprefetch2d' op ""requires attribute 'v_blocks'");

  if (tblgen_elem_size_in_bits && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_elem_size_in_bits))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_elem_size_in_bits).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockprefetch2d' op ""attribute 'elem_size_in_bits' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_tile_width && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_tile_width))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_tile_width).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockprefetch2d' op ""attribute 'tile_width' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_tile_height && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_tile_height))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_tile_height).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockprefetch2d' op ""attribute 'tile_height' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_v_blocks && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_v_blocks))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_v_blocks).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockprefetch2d' op ""attribute 'v_blocks' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_cache_control && !((::llvm::isa<::mlir::xevm::LoadCacheControlAttr>(tblgen_cache_control))))
    return emitError(loc, "'xevm.blockprefetch2d' op ""attribute 'cache_control' failed to satisfy constraint: Describe the cache settings for load operators");
  return ::mlir::success();
}

::llvm::LogicalResult BlockPrefetch2dOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache_control;
       auto attr = dict.get("cache_control");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.elem_size_in_bits;
       auto attr = dict.get("elem_size_in_bits");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_size_in_bits` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tile_height;
       auto attr = dict.get("tile_height");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_height` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tile_width;
       auto attr = dict.get("tile_width");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_width` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.v_blocks;
       auto attr = dict.get("v_blocks");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `v_blocks` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute BlockPrefetch2dOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache_control;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache_control",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.elem_size_in_bits;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("elem_size_in_bits",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tile_height;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tile_height",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tile_width;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tile_width",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.v_blocks;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("v_blocks",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code BlockPrefetch2dOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache_control.getAsOpaquePointer()), 
    llvm::hash_value(prop.elem_size_in_bits.getAsOpaquePointer()), 
    llvm::hash_value(prop.tile_height.getAsOpaquePointer()), 
    llvm::hash_value(prop.tile_width.getAsOpaquePointer()), 
    llvm::hash_value(prop.v_blocks.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> BlockPrefetch2dOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache_control")
      return prop.cache_control;

    if (name == "elem_size_in_bits")
      return prop.elem_size_in_bits;

    if (name == "tile_height")
      return prop.tile_height;

    if (name == "tile_width")
      return prop.tile_width;

    if (name == "v_blocks")
      return prop.v_blocks;
  return std::nullopt;
}

void BlockPrefetch2dOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache_control") {
       prop.cache_control = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache_control)>>(value);
       return;
    }

    if (name == "elem_size_in_bits") {
       prop.elem_size_in_bits = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.elem_size_in_bits)>>(value);
       return;
    }

    if (name == "tile_height") {
       prop.tile_height = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tile_height)>>(value);
       return;
    }

    if (name == "tile_width") {
       prop.tile_width = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tile_width)>>(value);
       return;
    }

    if (name == "v_blocks") {
       prop.v_blocks = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.v_blocks)>>(value);
       return;
    }
}

void BlockPrefetch2dOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache_control) attrs.append("cache_control", prop.cache_control);

    if (prop.elem_size_in_bits) attrs.append("elem_size_in_bits", prop.elem_size_in_bits);

    if (prop.tile_height) attrs.append("tile_height", prop.tile_height);

    if (prop.tile_width) attrs.append("tile_width", prop.tile_width);

    if (prop.v_blocks) attrs.append("v_blocks", prop.v_blocks);
}

::llvm::LogicalResult BlockPrefetch2dOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheControlAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(attr, "cache_control", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getElemSizeInBitsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "elem_size_in_bits", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTileHeightAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "tile_height", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTileWidthAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "tile_width", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getVBlocksAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "v_blocks", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult BlockPrefetch2dOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache_control)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.elem_size_in_bits)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.tile_height)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.tile_width)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.v_blocks)))
    return ::mlir::failure();
  return ::mlir::success();
}

void BlockPrefetch2dOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache_control);
  writer.writeAttribute(prop.elem_size_in_bits);
  writer.writeAttribute(prop.tile_height);
  writer.writeAttribute(prop.tile_width);
  writer.writeAttribute(prop.v_blocks);
}

uint32_t BlockPrefetch2dOp::getElemSizeInBits() {
  auto attr = getElemSizeInBitsAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockPrefetch2dOp::getTileWidth() {
  auto attr = getTileWidthAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockPrefetch2dOp::getTileHeight() {
  auto attr = getTileHeightAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockPrefetch2dOp::getVBlocks() {
  auto attr = getVBlocksAttr();
  return attr.getValue().getZExtValue();
}

::std::optional<::mlir::xevm::LoadCacheControl> BlockPrefetch2dOp::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

void BlockPrefetch2dOp::setElemSizeInBits(uint32_t attrValue) {
  getProperties().elem_size_in_bits = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockPrefetch2dOp::setTileWidth(uint32_t attrValue) {
  getProperties().tile_width = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockPrefetch2dOp::setTileHeight(uint32_t attrValue) {
  getProperties().tile_height = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockPrefetch2dOp::setVBlocks(uint32_t attrValue) {
  getProperties().v_blocks = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockPrefetch2dOp::setCacheControl(::std::optional<::mlir::xevm::LoadCacheControl> attrValue) {
    auto &odsProp = getProperties().cache_control;
    if (attrValue)
      odsProp = ::mlir::xevm::LoadCacheControlAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void BlockPrefetch2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = elem_size_in_bits;
  odsState.getOrAddProperties<Properties>().tile_width = tile_width;
  odsState.getOrAddProperties<Properties>().tile_height = tile_height;
  odsState.getOrAddProperties<Properties>().v_blocks = v_blocks;
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockPrefetch2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
}

void BlockPrefetch2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = elem_size_in_bits;
  odsState.getOrAddProperties<Properties>().tile_width = tile_width;
  odsState.getOrAddProperties<Properties>().tile_height = tile_height;
  odsState.getOrAddProperties<Properties>().v_blocks = v_blocks;
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockPrefetch2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::IntegerAttr v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
}

void BlockPrefetch2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_size_in_bits);
  odsState.getOrAddProperties<Properties>().tile_width = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_width);
  odsState.getOrAddProperties<Properties>().tile_height = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_height);
  odsState.getOrAddProperties<Properties>().v_blocks = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), v_blocks);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockPrefetch2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
}

void BlockPrefetch2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_size_in_bits);
  odsState.getOrAddProperties<Properties>().tile_width = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_width);
  odsState.getOrAddProperties<Properties>().tile_height = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_height);
  odsState.getOrAddProperties<Properties>().v_blocks = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), v_blocks);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockPrefetch2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, uint32_t v_blocks, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, v_blocks, cache_control);
}

void BlockPrefetch2dOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<BlockPrefetch2dOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<BlockPrefetch2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void BlockPrefetch2dOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<BlockPrefetch2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockPrefetch2dOp BlockPrefetch2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult BlockPrefetch2dOp::verifyInvariantsImpl() {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;
  auto tblgen_elem_size_in_bits = getProperties().elem_size_in_bits; (void)tblgen_elem_size_in_bits;
  if (!tblgen_elem_size_in_bits) return emitOpError("requires attribute 'elem_size_in_bits'");
  auto tblgen_tile_height = getProperties().tile_height; (void)tblgen_tile_height;
  if (!tblgen_tile_height) return emitOpError("requires attribute 'tile_height'");
  auto tblgen_tile_width = getProperties().tile_width; (void)tblgen_tile_width;
  if (!tblgen_tile_width) return emitOpError("requires attribute 'tile_width'");
  auto tblgen_v_blocks = getProperties().v_blocks; (void)tblgen_v_blocks;
  if (!tblgen_v_blocks) return emitOpError("requires attribute 'v_blocks'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_elem_size_in_bits, "elem_size_in_bits")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_tile_width, "tile_width")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_tile_height, "tile_height")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_v_blocks, "v_blocks")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(*this, tblgen_cache_control, "cache_control")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult BlockPrefetch2dOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult BlockPrefetch2dOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;
  [[maybe_unused]] ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult BlockPrefetch2dOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.elem_size_in_bits;
    auto elem_size_in_bitsAttrName = ::mlir::StringAttr::get(ctx, "elem_size_in_bits");
    auto attr = dict.get(elem_size_in_bitsAttrName);
    usedKeys.insert(elem_size_in_bitsAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for elem_size_in_bits in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_size_in_bits` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.tile_width;
    auto tile_widthAttrName = ::mlir::StringAttr::get(ctx, "tile_width");
    auto attr = dict.get(tile_widthAttrName);
    usedKeys.insert(tile_widthAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for tile_width in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_width` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.tile_height;
    auto tile_heightAttrName = ::mlir::StringAttr::get(ctx, "tile_height");
    auto attr = dict.get(tile_heightAttrName);
    usedKeys.insert(tile_heightAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for tile_height in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_height` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.v_blocks;
    auto v_blocksAttrName = ::mlir::StringAttr::get(ctx, "v_blocks");
    auto attr = dict.get(v_blocksAttrName);
    usedKeys.insert(v_blocksAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for v_blocks in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `v_blocks` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.cache_control;
    auto cache_controlAttrName = ::mlir::StringAttr::get(ctx, "cache_control");
    auto attr = dict.get(cache_controlAttrName);
    usedKeys.insert(cache_controlAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for cache_control in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void BlockPrefetch2dOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  _odsPrinter << getOperation()->getOperandTypes();
  _odsPrinter << ")";
}

void BlockPrefetch2dOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::BlockPrefetch2dOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::BlockStore2dOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BlockStore2dOpGenericAdaptorBase::BlockStore2dOpGenericAdaptorBase(BlockStore2dOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t BlockStore2dOpGenericAdaptorBase::getElemSizeInBits() {
  auto attr = getElemSizeInBitsAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockStore2dOpGenericAdaptorBase::getTileWidth() {
  auto attr = getTileWidthAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockStore2dOpGenericAdaptorBase::getTileHeight() {
  auto attr = getTileHeightAttr();
  return attr.getValue().getZExtValue();
}

::std::optional<::mlir::xevm::StoreCacheControl> BlockStore2dOpGenericAdaptorBase::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::StoreCacheControl>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
BlockStore2dOpAdaptor::BlockStore2dOpAdaptor(BlockStore2dOp op) : BlockStore2dOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult BlockStore2dOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;
  auto tblgen_elem_size_in_bits = getProperties().elem_size_in_bits; (void)tblgen_elem_size_in_bits;
  if (!tblgen_elem_size_in_bits) return emitError(loc, "'xevm.blockstore2d' op ""requires attribute 'elem_size_in_bits'");
  auto tblgen_tile_height = getProperties().tile_height; (void)tblgen_tile_height;
  if (!tblgen_tile_height) return emitError(loc, "'xevm.blockstore2d' op ""requires attribute 'tile_height'");
  auto tblgen_tile_width = getProperties().tile_width; (void)tblgen_tile_width;
  if (!tblgen_tile_width) return emitError(loc, "'xevm.blockstore2d' op ""requires attribute 'tile_width'");

  if (tblgen_elem_size_in_bits && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_elem_size_in_bits))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_elem_size_in_bits).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockstore2d' op ""attribute 'elem_size_in_bits' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_tile_width && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_tile_width))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_tile_width).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockstore2d' op ""attribute 'tile_width' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_tile_height && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_tile_height))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_tile_height).getType().isSignlessInteger(32)))))
    return emitError(loc, "'xevm.blockstore2d' op ""attribute 'tile_height' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_cache_control && !((::llvm::isa<::mlir::xevm::StoreCacheControlAttr>(tblgen_cache_control))))
    return emitError(loc, "'xevm.blockstore2d' op ""attribute 'cache_control' failed to satisfy constraint: Describe the cache settings for store operators");
  return ::mlir::success();
}

::llvm::LogicalResult BlockStore2dOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache_control;
       auto attr = dict.get("cache_control");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.elem_size_in_bits;
       auto attr = dict.get("elem_size_in_bits");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_size_in_bits` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tile_height;
       auto attr = dict.get("tile_height");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_height` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tile_width;
       auto attr = dict.get("tile_width");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_width` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute BlockStore2dOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache_control;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache_control",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.elem_size_in_bits;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("elem_size_in_bits",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tile_height;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tile_height",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tile_width;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tile_width",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code BlockStore2dOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache_control.getAsOpaquePointer()), 
    llvm::hash_value(prop.elem_size_in_bits.getAsOpaquePointer()), 
    llvm::hash_value(prop.tile_height.getAsOpaquePointer()), 
    llvm::hash_value(prop.tile_width.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> BlockStore2dOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache_control")
      return prop.cache_control;

    if (name == "elem_size_in_bits")
      return prop.elem_size_in_bits;

    if (name == "tile_height")
      return prop.tile_height;

    if (name == "tile_width")
      return prop.tile_width;
  return std::nullopt;
}

void BlockStore2dOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache_control") {
       prop.cache_control = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache_control)>>(value);
       return;
    }

    if (name == "elem_size_in_bits") {
       prop.elem_size_in_bits = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.elem_size_in_bits)>>(value);
       return;
    }

    if (name == "tile_height") {
       prop.tile_height = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tile_height)>>(value);
       return;
    }

    if (name == "tile_width") {
       prop.tile_width = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tile_width)>>(value);
       return;
    }
}

void BlockStore2dOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache_control) attrs.append("cache_control", prop.cache_control);

    if (prop.elem_size_in_bits) attrs.append("elem_size_in_bits", prop.elem_size_in_bits);

    if (prop.tile_height) attrs.append("tile_height", prop.tile_height);

    if (prop.tile_width) attrs.append("tile_width", prop.tile_width);
}

::llvm::LogicalResult BlockStore2dOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheControlAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps4(attr, "cache_control", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getElemSizeInBitsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "elem_size_in_bits", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTileHeightAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "tile_height", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTileWidthAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(attr, "tile_width", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult BlockStore2dOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache_control)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.elem_size_in_bits)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.tile_height)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.tile_width)))
    return ::mlir::failure();
  return ::mlir::success();
}

void BlockStore2dOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache_control);
  writer.writeAttribute(prop.elem_size_in_bits);
  writer.writeAttribute(prop.tile_height);
  writer.writeAttribute(prop.tile_width);
}

uint32_t BlockStore2dOp::getElemSizeInBits() {
  auto attr = getElemSizeInBitsAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockStore2dOp::getTileWidth() {
  auto attr = getTileWidthAttr();
  return attr.getValue().getZExtValue();
}

uint32_t BlockStore2dOp::getTileHeight() {
  auto attr = getTileHeightAttr();
  return attr.getValue().getZExtValue();
}

::std::optional<::mlir::xevm::StoreCacheControl> BlockStore2dOp::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::StoreCacheControl>(attr.getValue()) : (::std::nullopt);
}

void BlockStore2dOp::setElemSizeInBits(uint32_t attrValue) {
  getProperties().elem_size_in_bits = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockStore2dOp::setTileWidth(uint32_t attrValue) {
  getProperties().tile_width = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockStore2dOp::setTileHeight(uint32_t attrValue) {
  getProperties().tile_height = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BlockStore2dOp::setCacheControl(::std::optional<::mlir::xevm::StoreCacheControl> attrValue) {
    auto &odsProp = getProperties().cache_control;
    if (attrValue)
      odsProp = ::mlir::xevm::StoreCacheControlAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void BlockStore2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.addOperands(stored_val);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = elem_size_in_bits;
  odsState.getOrAddProperties<Properties>().tile_width = tile_width;
  odsState.getOrAddProperties<Properties>().tile_height = tile_height;
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
}

BlockStore2dOp BlockStore2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockStore2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStore2dOp BlockStore2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
}

void BlockStore2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.addOperands(stored_val);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = elem_size_in_bits;
  odsState.getOrAddProperties<Properties>().tile_width = tile_width;
  odsState.getOrAddProperties<Properties>().tile_height = tile_height;
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockStore2dOp BlockStore2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockStore2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStore2dOp BlockStore2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, ::mlir::IntegerAttr elem_size_in_bits, ::mlir::IntegerAttr tile_width, ::mlir::IntegerAttr tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
}

void BlockStore2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.addOperands(stored_val);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_size_in_bits);
  odsState.getOrAddProperties<Properties>().tile_width = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_width);
  odsState.getOrAddProperties<Properties>().tile_height = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_height);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
}

BlockStore2dOp BlockStore2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockStore2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStore2dOp BlockStore2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
}

void BlockStore2dOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(base_width);
  odsState.addOperands(base_height);
  odsState.addOperands(base_pitch);
  odsState.addOperands(x);
  odsState.addOperands(y);
  odsState.addOperands(stored_val);
  odsState.getOrAddProperties<Properties>().elem_size_in_bits = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_size_in_bits);
  odsState.getOrAddProperties<Properties>().tile_width = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_width);
  odsState.getOrAddProperties<Properties>().tile_height = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), tile_height);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockStore2dOp BlockStore2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockStore2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStore2dOp BlockStore2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value base_width, ::mlir::Value base_height, ::mlir::Value base_pitch, ::mlir::Value x, ::mlir::Value y, uint32_t elem_size_in_bits, uint32_t tile_width, uint32_t tile_height, ::mlir::Value stored_val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, base_width, base_height, base_pitch, x, y, elem_size_in_bits, tile_width, tile_height, stored_val, cache_control);
}

void BlockStore2dOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 7u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<BlockStore2dOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

BlockStore2dOp BlockStore2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<BlockStore2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStore2dOp BlockStore2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void BlockStore2dOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 7u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

BlockStore2dOp BlockStore2dOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<BlockStore2dOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStore2dOp BlockStore2dOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult BlockStore2dOp::verifyInvariantsImpl() {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;
  auto tblgen_elem_size_in_bits = getProperties().elem_size_in_bits; (void)tblgen_elem_size_in_bits;
  if (!tblgen_elem_size_in_bits) return emitOpError("requires attribute 'elem_size_in_bits'");
  auto tblgen_tile_height = getProperties().tile_height; (void)tblgen_tile_height;
  if (!tblgen_tile_height) return emitOpError("requires attribute 'tile_height'");
  auto tblgen_tile_width = getProperties().tile_width; (void)tblgen_tile_width;
  if (!tblgen_tile_width) return emitOpError("requires attribute 'tile_width'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_elem_size_in_bits, "elem_size_in_bits")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_tile_width, "tile_width")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps1(*this, tblgen_tile_height, "tile_height")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps4(*this, tblgen_cache_control, "cache_control")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult BlockStore2dOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult BlockStore2dOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;
  [[maybe_unused]] ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult BlockStore2dOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.elem_size_in_bits;
    auto elem_size_in_bitsAttrName = ::mlir::StringAttr::get(ctx, "elem_size_in_bits");
    auto attr = dict.get(elem_size_in_bitsAttrName);
    usedKeys.insert(elem_size_in_bitsAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for elem_size_in_bits in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_size_in_bits` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.tile_width;
    auto tile_widthAttrName = ::mlir::StringAttr::get(ctx, "tile_width");
    auto attr = dict.get(tile_widthAttrName);
    usedKeys.insert(tile_widthAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for tile_width in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_width` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.tile_height;
    auto tile_heightAttrName = ::mlir::StringAttr::get(ctx, "tile_height");
    auto attr = dict.get(tile_heightAttrName);
    usedKeys.insert(tile_heightAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for tile_height in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tile_height` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.cache_control;
    auto cache_controlAttrName = ::mlir::StringAttr::get(ctx, "cache_control");
    auto attr = dict.get(cache_controlAttrName);
    usedKeys.insert(cache_controlAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for cache_control in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void BlockStore2dOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  _odsPrinter << getOperation()->getOperandTypes();
  _odsPrinter << ")";
}

void BlockStore2dOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::BlockStore2dOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::BlockStoreOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BlockStoreOpGenericAdaptorBase::BlockStoreOpGenericAdaptorBase(BlockStoreOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xevm::StoreCacheControl> BlockStoreOpGenericAdaptorBase::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::StoreCacheControl>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
BlockStoreOpAdaptor::BlockStoreOpAdaptor(BlockStoreOp op) : BlockStoreOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult BlockStoreOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;

  if (tblgen_cache_control && !((::llvm::isa<::mlir::xevm::StoreCacheControlAttr>(tblgen_cache_control))))
    return emitError(loc, "'xevm.blockstore' op ""attribute 'cache_control' failed to satisfy constraint: Describe the cache settings for store operators");
  return ::mlir::success();
}

::llvm::LogicalResult BlockStoreOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache_control;
       auto attr = dict.get("cache_control");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute BlockStoreOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache_control;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache_control",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code BlockStoreOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache_control.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> BlockStoreOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache_control")
      return prop.cache_control;
  return std::nullopt;
}

void BlockStoreOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache_control") {
       prop.cache_control = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache_control)>>(value);
       return;
    }
}

void BlockStoreOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache_control) attrs.append("cache_control", prop.cache_control);
}

::llvm::LogicalResult BlockStoreOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheControlAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps4(attr, "cache_control", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult BlockStoreOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache_control)))
    return ::mlir::failure();
  return ::mlir::success();
}

void BlockStoreOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache_control);
}

::std::optional<::mlir::xevm::StoreCacheControl> BlockStoreOp::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::StoreCacheControl>(attr.getValue()) : (::std::nullopt);
}

void BlockStoreOp::setCacheControl(::std::optional<::mlir::xevm::StoreCacheControl> attrValue) {
    auto &odsProp = getProperties().cache_control;
    if (attrValue)
      odsProp = ::mlir::xevm::StoreCacheControlAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void BlockStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(val);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
}

BlockStoreOp BlockStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, val, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStoreOp BlockStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), ptr, val, cache_control);
}

void BlockStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  odsState.addOperands(val);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BlockStoreOp BlockStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, val, cache_control);
  auto __res__ = ::llvm::dyn_cast<BlockStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStoreOp BlockStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value val, /*optional*/::mlir::xevm::StoreCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, val, cache_control);
}

void BlockStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<BlockStoreOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

BlockStoreOp BlockStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<BlockStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStoreOp BlockStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void BlockStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

BlockStoreOp BlockStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<BlockStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BlockStoreOp BlockStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult BlockStoreOp::verifyInvariantsImpl() {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps4(*this, tblgen_cache_control, "cache_control")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult BlockStoreOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult BlockStoreOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;
  [[maybe_unused]] ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult BlockStoreOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.cache_control;
    auto cache_controlAttrName = ::mlir::StringAttr::get(ctx, "cache_control");
    auto attr = dict.get(cache_controlAttrName);
    usedKeys.insert(cache_controlAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for cache_control in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void BlockStoreOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  _odsPrinter << getOperation()->getOperandTypes();
  _odsPrinter << ")";
}

void BlockStoreOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::BlockStoreOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::GridDimXOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GridDimXOpGenericAdaptorBase::GridDimXOpGenericAdaptorBase(GridDimXOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> GridDimXOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
GridDimXOpAdaptor::GridDimXOpAdaptor(GridDimXOp op) : GridDimXOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult GridDimXOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.group_count.x' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult GridDimXOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute GridDimXOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GridDimXOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> GridDimXOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void GridDimXOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void GridDimXOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult GridDimXOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult GridDimXOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void GridDimXOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> GridDimXOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void GridDimXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

GridDimXOp GridDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<GridDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimXOp GridDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void GridDimXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

GridDimXOp GridDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<GridDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimXOp GridDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void GridDimXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<GridDimXOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

GridDimXOp GridDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<GridDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimXOp GridDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void GridDimXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

GridDimXOp GridDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<GridDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimXOp GridDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult GridDimXOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult GridDimXOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GridDimXOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<GridDimXOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void GridDimXOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::GridDimXOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::GridDimYOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GridDimYOpGenericAdaptorBase::GridDimYOpGenericAdaptorBase(GridDimYOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> GridDimYOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
GridDimYOpAdaptor::GridDimYOpAdaptor(GridDimYOp op) : GridDimYOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult GridDimYOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.group_count.y' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult GridDimYOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute GridDimYOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GridDimYOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> GridDimYOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void GridDimYOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void GridDimYOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult GridDimYOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult GridDimYOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void GridDimYOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> GridDimYOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void GridDimYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

GridDimYOp GridDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<GridDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimYOp GridDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void GridDimYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

GridDimYOp GridDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<GridDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimYOp GridDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void GridDimYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<GridDimYOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

GridDimYOp GridDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<GridDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimYOp GridDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void GridDimYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

GridDimYOp GridDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<GridDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimYOp GridDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult GridDimYOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult GridDimYOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GridDimYOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<GridDimYOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void GridDimYOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::GridDimYOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::GridDimZOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GridDimZOpGenericAdaptorBase::GridDimZOpGenericAdaptorBase(GridDimZOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> GridDimZOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
GridDimZOpAdaptor::GridDimZOpAdaptor(GridDimZOp op) : GridDimZOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult GridDimZOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.group_count.z' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult GridDimZOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute GridDimZOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GridDimZOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> GridDimZOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void GridDimZOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void GridDimZOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult GridDimZOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult GridDimZOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void GridDimZOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> GridDimZOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void GridDimZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

GridDimZOp GridDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<GridDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimZOp GridDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void GridDimZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

GridDimZOp GridDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<GridDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimZOp GridDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void GridDimZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<GridDimZOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

GridDimZOp GridDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<GridDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimZOp GridDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void GridDimZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

GridDimZOp GridDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<GridDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GridDimZOp GridDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult GridDimZOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult GridDimZOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GridDimZOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<GridDimZOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void GridDimZOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::GridDimZOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::LaneIdOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LaneIdOpGenericAdaptorBase::LaneIdOpGenericAdaptorBase(LaneIdOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> LaneIdOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
LaneIdOpAdaptor::LaneIdOpAdaptor(LaneIdOp op) : LaneIdOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult LaneIdOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.lane_id' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult LaneIdOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute LaneIdOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LaneIdOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> LaneIdOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void LaneIdOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void LaneIdOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult LaneIdOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult LaneIdOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void LaneIdOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> LaneIdOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void LaneIdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

LaneIdOp LaneIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<LaneIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

LaneIdOp LaneIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void LaneIdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

LaneIdOp LaneIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<LaneIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

LaneIdOp LaneIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void LaneIdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<LaneIdOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

LaneIdOp LaneIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<LaneIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

LaneIdOp LaneIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void LaneIdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

LaneIdOp LaneIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<LaneIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

LaneIdOp LaneIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult LaneIdOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult LaneIdOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LaneIdOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<LaneIdOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void LaneIdOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::LaneIdOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::MMAOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MMAOpGenericAdaptorBase::MMAOpGenericAdaptorBase(MMAOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> MMAOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::xevm::MMAShapeAttr MMAOpGenericAdaptorBase::getShape() {
  auto attr = getShapeAttr();
  return ::llvm::cast<::mlir::xevm::MMAShapeAttr>(attr);
}

::mlir::xevm::MMATypesAttr MMAOpGenericAdaptorBase::getTypes() {
  auto attr = getTypesAttr();
  return ::llvm::cast<::mlir::xevm::MMATypesAttr>(attr);
}

} // namespace detail
MMAOpAdaptor::MMAOpAdaptor(MMAOp op) : MMAOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult MMAOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_shape = getProperties().shape; (void)tblgen_shape;
  if (!tblgen_shape) return emitError(loc, "'xevm.mma' op ""requires attribute 'shape'");
  auto tblgen_types = getProperties().types; (void)tblgen_types;
  if (!tblgen_types) return emitError(loc, "'xevm.mma' op ""requires attribute 'types'");

  if (tblgen_shape && !((::llvm::isa<::mlir::xevm::MMAShapeAttr>(tblgen_shape))))
    return emitError(loc, "'xevm.mma' op ""attribute 'shape' failed to satisfy constraint: ");

  if (tblgen_types && !((::llvm::isa<::mlir::xevm::MMATypesAttr>(tblgen_types))))
    return emitError(loc, "'xevm.mma' op ""attribute 'types' failed to satisfy constraint: ");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MMAOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange MMAOp::getCMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult MMAOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.shape;
       auto attr = dict.get("shape");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `shape` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.types;
       auto attr = dict.get("types");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `types` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MMAOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.shape;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("shape",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.types;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("types",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MMAOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.shape.getAsOpaquePointer()), 
    llvm::hash_value(prop.types.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MMAOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "shape")
      return prop.shape;

    if (name == "types")
      return prop.types;
  return std::nullopt;
}

void MMAOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "shape") {
       prop.shape = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.shape)>>(value);
       return;
    }

    if (name == "types") {
       prop.types = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.types)>>(value);
       return;
    }
}

void MMAOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.shape) attrs.append("shape", prop.shape);

    if (prop.types) attrs.append("types", prop.types);
}

::llvm::LogicalResult MMAOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getShapeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps6(attr, "shape", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTypesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps7(attr, "types", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult MMAOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.shape)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.types)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MMAOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.shape);
  writer.writeAttribute(prop.types);
}

::mlir::xevm::MMAShapeAttr MMAOp::getShape() {
  auto attr = getShapeAttr();
  return ::llvm::cast<::mlir::xevm::MMAShapeAttr>(attr);
}

::mlir::xevm::MMATypesAttr MMAOp::getTypes() {
  auto attr = getTypesAttr();
  return ::llvm::cast<::mlir::xevm::MMATypesAttr>(attr);
}

void MMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, /*optional*/::mlir::Value c, ::mlir::xevm::MMAShapeAttr shape, ::mlir::xevm::MMATypesAttr types) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (c)
    odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().shape = shape;
  odsState.getOrAddProperties<Properties>().types = types;
  odsState.addTypes(d);
}

MMAOp MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, /*optional*/::mlir::Value c, ::mlir::xevm::MMAShapeAttr shape, ::mlir::xevm::MMATypesAttr types) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, d, a, b, c, shape, types);
  auto __res__ = ::llvm::dyn_cast<MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MMAOp MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, /*optional*/::mlir::Value c, ::mlir::xevm::MMAShapeAttr shape, ::mlir::xevm::MMATypesAttr types) {
  return create(builder, builder.getLoc(), d, a, b, c, shape, types);
}

void MMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, /*optional*/::mlir::Value c, ::mlir::xevm::MMAShapeAttr shape, ::mlir::xevm::MMATypesAttr types) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (c)
    odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().shape = shape;
  odsState.getOrAddProperties<Properties>().types = types;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

MMAOp MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, /*optional*/::mlir::Value c, ::mlir::xevm::MMAShapeAttr shape, ::mlir::xevm::MMATypesAttr types) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, c, shape, types);
  auto __res__ = ::llvm::dyn_cast<MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MMAOp MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, /*optional*/::mlir::Value c, ::mlir::xevm::MMAShapeAttr shape, ::mlir::xevm::MMATypesAttr types) {
  return create(builder, builder.getLoc(), resultTypes, a, b, c, shape, types);
}

void MMAOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<MMAOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

MMAOp MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MMAOp MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void MMAOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

MMAOp MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MMAOp MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult MMAOp::verifyInvariantsImpl() {
  auto tblgen_shape = getProperties().shape; (void)tblgen_shape;
  if (!tblgen_shape) return emitOpError("requires attribute 'shape'");
  auto tblgen_types = getProperties().types; (void)tblgen_types;
  if (!tblgen_types) return emitOpError("requires attribute 'types'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps6(*this, tblgen_shape, "shape")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps7(*this, tblgen_types, "types")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult MMAOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult MMAOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand aRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> aOperands(&aRawOperand, 1);  ::llvm::SMLoc aOperandsLoc;
  (void)aOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand bRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bOperands(&bRawOperand, 1);  ::llvm::SMLoc bOperandsLoc;
  (void)bOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> cOperands;
  ::llvm::SMLoc cOperandsLoc;
  (void)cOperandsLoc;
  ::mlir::xevm::MMAShapeAttr shapeAttr;
  ::mlir::xevm::MMATypesAttr typesAttr;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  aOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(aRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  bOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    cOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      cOperands.push_back(operand);
    }
  }
  }
  if (parser.parseLBrace())
    return ::mlir::failure();
  if (parser.parseKeyword("shape"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(shapeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (shapeAttr) result.getOrAddProperties<MMAOp::Properties>().shape = shapeAttr;
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseKeyword("types"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(typesAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (typesAttr) result.getOrAddProperties<MMAOp::Properties>().types = typesAttr;
  if (parser.parseRBrace())
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(aOperands, bOperands, cOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MMAOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getA();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getB();
  if (getC()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getC())
      _odsPrinter << value;
  }
  _odsPrinter << ' ';
  _odsPrinter << "{";
  _odsPrinter << "shape";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getShapeAttr());
  _odsPrinter << ",";
  _odsPrinter << ' ' << "types";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getTypesAttr());
  _odsPrinter << "}";
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("shape");
  elidedAttrs.push_back("types");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::MMAOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::MemfenceOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MemfenceOpGenericAdaptorBase::MemfenceOpGenericAdaptorBase(MemfenceOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::xevm::MemScope MemfenceOpGenericAdaptorBase::getScope() {
  auto attr = getScopeAttr();
  return attr.getValue();
}

::mlir::xevm::AddrSpaceAttr MemfenceOpGenericAdaptorBase::getAddrspaceAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::xevm::AddrSpaceAttr>(getProperties().addrspace);
  return attr;
}

mlir::xevm::AddrSpace MemfenceOpGenericAdaptorBase::getAddrspace() {
  auto attr = getAddrspaceAttr();
  return attr.getValue();
}

} // namespace detail
MemfenceOpAdaptor::MemfenceOpAdaptor(MemfenceOp op) : MemfenceOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult MemfenceOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_addrspace = getProperties().addrspace; (void)tblgen_addrspace;
  auto tblgen_scope = getProperties().scope; (void)tblgen_scope;
  if (!tblgen_scope) return emitError(loc, "'xevm.memfence' op ""requires attribute 'scope'");

  if (tblgen_scope && !((::llvm::isa<::mlir::xevm::MemScopeAttr>(tblgen_scope))))
    return emitError(loc, "'xevm.memfence' op ""attribute 'scope' failed to satisfy constraint: Describe memory scopes");

  if (tblgen_addrspace && !((::llvm::isa<::mlir::xevm::AddrSpaceAttr>(tblgen_addrspace))))
    return emitError(loc, "'xevm.memfence' op ""attribute 'addrspace' failed to satisfy constraint: Describe address spaces");
  return ::mlir::success();
}

::llvm::LogicalResult MemfenceOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.addrspace;
       auto attr = dict.get("addrspace");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `addrspace` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.scope;
       auto attr = dict.get("scope");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `scope` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MemfenceOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.addrspace;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("addrspace",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.scope;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("scope",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MemfenceOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.addrspace.getAsOpaquePointer()), 
    llvm::hash_value(prop.scope.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MemfenceOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "addrspace")
      return prop.addrspace;

    if (name == "scope")
      return prop.scope;
  return std::nullopt;
}

void MemfenceOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "addrspace") {
       prop.addrspace = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.addrspace)>>(value);
       return;
    }

    if (name == "scope") {
       prop.scope = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.scope)>>(value);
       return;
    }
}

void MemfenceOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.addrspace) attrs.append("addrspace", prop.addrspace);

    if (prop.scope) attrs.append("scope", prop.scope);
}

::llvm::LogicalResult MemfenceOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAddrspaceAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps9(attr, "addrspace", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getScopeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps8(attr, "scope", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult MemfenceOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.addrspace)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.scope)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MemfenceOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.addrspace);
  writer.writeAttribute(prop.scope);
}

::mlir::xevm::MemScope MemfenceOp::getScope() {
  auto attr = getScopeAttr();
  return attr.getValue();
}

mlir::xevm::AddrSpace MemfenceOp::getAddrspace() {
  auto attr = getAddrspaceAttr();
  return attr.getValue();
}

void MemfenceOp::setScope(::mlir::xevm::MemScope attrValue) {
  getProperties().scope = ::mlir::xevm::MemScopeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void MemfenceOp::setAddrspace(mlir::xevm::AddrSpace attrValue) {
  getProperties().addrspace = mlir::xevm::AddrSpaceAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void MemfenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::xevm::MemScopeAttr scope, ::mlir::xevm::AddrSpaceAttr addrspace) {
  odsState.getOrAddProperties<Properties>().scope = scope;
  if (addrspace) {
    odsState.getOrAddProperties<Properties>().addrspace = addrspace;
  }
}

MemfenceOp MemfenceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::xevm::MemScopeAttr scope, ::mlir::xevm::AddrSpaceAttr addrspace) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, scope, addrspace);
  auto __res__ = ::llvm::dyn_cast<MemfenceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MemfenceOp MemfenceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::xevm::MemScopeAttr scope, ::mlir::xevm::AddrSpaceAttr addrspace) {
  return create(builder, builder.getLoc(), scope, addrspace);
}

void MemfenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::xevm::MemScopeAttr scope, ::mlir::xevm::AddrSpaceAttr addrspace) {
  odsState.getOrAddProperties<Properties>().scope = scope;
  if (addrspace) {
    odsState.getOrAddProperties<Properties>().addrspace = addrspace;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

MemfenceOp MemfenceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::xevm::MemScopeAttr scope, ::mlir::xevm::AddrSpaceAttr addrspace) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, scope, addrspace);
  auto __res__ = ::llvm::dyn_cast<MemfenceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MemfenceOp MemfenceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::xevm::MemScopeAttr scope, ::mlir::xevm::AddrSpaceAttr addrspace) {
  return create(builder, builder.getLoc(), resultTypes, scope, addrspace);
}

void MemfenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::xevm::MemScope scope, mlir::xevm::AddrSpace addrspace) {
  odsState.getOrAddProperties<Properties>().scope = ::mlir::xevm::MemScopeAttr::get(odsBuilder.getContext(), scope);
  odsState.getOrAddProperties<Properties>().addrspace = mlir::xevm::AddrSpaceAttr::get(odsBuilder.getContext(), addrspace);
}

MemfenceOp MemfenceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::xevm::MemScope scope, mlir::xevm::AddrSpace addrspace) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, scope, addrspace);
  auto __res__ = ::llvm::dyn_cast<MemfenceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MemfenceOp MemfenceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::xevm::MemScope scope, mlir::xevm::AddrSpace addrspace) {
  return create(builder, builder.getLoc(), scope, addrspace);
}

void MemfenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::xevm::MemScope scope, mlir::xevm::AddrSpace addrspace) {
  odsState.getOrAddProperties<Properties>().scope = ::mlir::xevm::MemScopeAttr::get(odsBuilder.getContext(), scope);
  odsState.getOrAddProperties<Properties>().addrspace = mlir::xevm::AddrSpaceAttr::get(odsBuilder.getContext(), addrspace);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

MemfenceOp MemfenceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::xevm::MemScope scope, mlir::xevm::AddrSpace addrspace) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, scope, addrspace);
  auto __res__ = ::llvm::dyn_cast<MemfenceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MemfenceOp MemfenceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::xevm::MemScope scope, mlir::xevm::AddrSpace addrspace) {
  return create(builder, builder.getLoc(), resultTypes, scope, addrspace);
}

void MemfenceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<MemfenceOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

MemfenceOp MemfenceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<MemfenceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MemfenceOp MemfenceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void MemfenceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

MemfenceOp MemfenceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<MemfenceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

MemfenceOp MemfenceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void MemfenceOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.addrspace)
    properties.addrspace = mlir::xevm::AddrSpaceAttr::get(odsBuilder.getContext(), mlir::xevm::AddrSpace::GENERIC);
}

::llvm::LogicalResult MemfenceOp::verifyInvariantsImpl() {
  auto tblgen_addrspace = getProperties().addrspace; (void)tblgen_addrspace;
  auto tblgen_scope = getProperties().scope; (void)tblgen_scope;
  if (!tblgen_scope) return emitOpError("requires attribute 'scope'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps8(*this, tblgen_scope, "scope")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps9(*this, tblgen_addrspace, "addrspace")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult MemfenceOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MemfenceOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

::llvm::LogicalResult MemfenceOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.scope;
    auto scopeAttrName = ::mlir::StringAttr::get(ctx, "scope");
    auto attr = dict.get(scopeAttrName);
    usedKeys.insert(scopeAttrName);
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for scope in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `scope` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.addrspace;
    auto addrspaceAttrName = ::mlir::StringAttr::get(ctx, "addrspace");
    auto attr = dict.get(addrspaceAttrName);
    usedKeys.insert(addrspaceAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for addrspace in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `addrspace` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void MemfenceOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAddrspaceAttr();
     if(attr && (attr == mlir::xevm::AddrSpaceAttr::get(odsBuilder.getContext(), mlir::xevm::AddrSpace::GENERIC)))
       elidedProps.push_back("addrspace");
  }
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAddrspaceAttr();
     if(attr && (attr == mlir::xevm::AddrSpaceAttr::get(odsBuilder.getContext(), mlir::xevm::AddrSpace::GENERIC)))
       elidedAttrs.push_back("addrspace");
  }
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::MemfenceOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::PrefetchOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PrefetchOpGenericAdaptorBase::PrefetchOpGenericAdaptorBase(PrefetchOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xevm::LoadCacheControl> PrefetchOpGenericAdaptorBase::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
PrefetchOpAdaptor::PrefetchOpAdaptor(PrefetchOp op) : PrefetchOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult PrefetchOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;

  if (tblgen_cache_control && !((::llvm::isa<::mlir::xevm::LoadCacheControlAttr>(tblgen_cache_control))))
    return emitError(loc, "'xevm.prefetch' op ""attribute 'cache_control' failed to satisfy constraint: Describe the cache settings for load operators");
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache_control;
       auto attr = dict.get("cache_control");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute PrefetchOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache_control;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache_control",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PrefetchOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache_control.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> PrefetchOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache_control")
      return prop.cache_control;
  return std::nullopt;
}

void PrefetchOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache_control") {
       prop.cache_control = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache_control)>>(value);
       return;
    }
}

void PrefetchOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache_control) attrs.append("cache_control", prop.cache_control);
}

::llvm::LogicalResult PrefetchOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheControlAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(attr, "cache_control", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache_control)))
    return ::mlir::failure();
  return ::mlir::success();
}

void PrefetchOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache_control);
}

::std::optional<::mlir::xevm::LoadCacheControl> PrefetchOp::getCacheControl() {
  auto attr = getCacheControlAttr();
  return attr ? ::std::optional<::mlir::xevm::LoadCacheControl>(attr.getValue()) : (::std::nullopt);
}

void PrefetchOp::setCacheControl(::std::optional<::mlir::xevm::LoadCacheControl> attrValue) {
    auto &odsProp = getProperties().cache_control;
    if (attrValue)
      odsProp = ::mlir::xevm::LoadCacheControlAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
}

PrefetchOp PrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, cache_control);
  auto __res__ = ::llvm::dyn_cast<PrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

PrefetchOp PrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), ptr, cache_control);
}

void PrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  odsState.addOperands(ptr);
  if (cache_control) {
    odsState.getOrAddProperties<Properties>().cache_control = cache_control;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

PrefetchOp PrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, ptr, cache_control);
  auto __res__ = ::llvm::dyn_cast<PrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

PrefetchOp PrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, /*optional*/::mlir::xevm::LoadCacheControlAttr cache_control) {
  return create(builder, builder.getLoc(), resultTypes, ptr, cache_control);
}

void PrefetchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<PrefetchOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

PrefetchOp PrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<PrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

PrefetchOp PrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void PrefetchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

PrefetchOp PrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<PrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

PrefetchOp PrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult PrefetchOp::verifyInvariantsImpl() {
  auto tblgen_cache_control = getProperties().cache_control; (void)tblgen_cache_control;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps3(*this, tblgen_cache_control, "cache_control")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult PrefetchOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;
  [[maybe_unused]] ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  ::mlir::DenseSet<::mlir::StringAttr> usedKeys;
  ::mlir::MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.cache_control;
    auto cache_controlAttrName = ::mlir::StringAttr::get(ctx, "cache_control");
    auto attr = dict.get(cache_controlAttrName);
    usedKeys.insert(cache_controlAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for cache_control in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache_control` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (::mlir::NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void PrefetchOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  _odsPrinter << getOperation()->getOperandTypes();
  _odsPrinter << ")";
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::PrefetchOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::SubgroupIdOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SubgroupIdOpGenericAdaptorBase::SubgroupIdOpGenericAdaptorBase(SubgroupIdOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> SubgroupIdOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
SubgroupIdOpAdaptor::SubgroupIdOpAdaptor(SubgroupIdOp op) : SubgroupIdOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SubgroupIdOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.subgroup_id' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult SubgroupIdOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute SubgroupIdOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SubgroupIdOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> SubgroupIdOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void SubgroupIdOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void SubgroupIdOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult SubgroupIdOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SubgroupIdOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void SubgroupIdOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> SubgroupIdOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void SubgroupIdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

SubgroupIdOp SubgroupIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<SubgroupIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupIdOp SubgroupIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void SubgroupIdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SubgroupIdOp SubgroupIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<SubgroupIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupIdOp SubgroupIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void SubgroupIdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SubgroupIdOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SubgroupIdOp SubgroupIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SubgroupIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupIdOp SubgroupIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SubgroupIdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SubgroupIdOp SubgroupIdOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SubgroupIdOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupIdOp SubgroupIdOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SubgroupIdOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SubgroupIdOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SubgroupIdOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<SubgroupIdOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void SubgroupIdOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::SubgroupIdOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::SubgroupSizeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SubgroupSizeOpGenericAdaptorBase::SubgroupSizeOpGenericAdaptorBase(SubgroupSizeOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> SubgroupSizeOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
SubgroupSizeOpAdaptor::SubgroupSizeOpAdaptor(SubgroupSizeOp op) : SubgroupSizeOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SubgroupSizeOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.subgroup_size' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult SubgroupSizeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute SubgroupSizeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SubgroupSizeOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> SubgroupSizeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void SubgroupSizeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void SubgroupSizeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult SubgroupSizeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SubgroupSizeOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void SubgroupSizeOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> SubgroupSizeOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void SubgroupSizeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<SubgroupSizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void SubgroupSizeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<SubgroupSizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void SubgroupSizeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SubgroupSizeOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SubgroupSizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SubgroupSizeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SubgroupSizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SubgroupSizeOp SubgroupSizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SubgroupSizeOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SubgroupSizeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SubgroupSizeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<SubgroupSizeOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void SubgroupSizeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::SubgroupSizeOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkgroupDimXOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkgroupDimXOpGenericAdaptorBase::WorkgroupDimXOpGenericAdaptorBase(WorkgroupDimXOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupDimXOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkgroupDimXOpAdaptor::WorkgroupDimXOpAdaptor(WorkgroupDimXOp op) : WorkgroupDimXOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkgroupDimXOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.local_size.x' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimXOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkgroupDimXOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkgroupDimXOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkgroupDimXOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkgroupDimXOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkgroupDimXOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkgroupDimXOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimXOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkgroupDimXOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupDimXOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkgroupDimXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkgroupDimXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkgroupDimXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkgroupDimXOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkgroupDimXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimXOp WorkgroupDimXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkgroupDimXOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimXOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkgroupDimXOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkgroupDimXOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkgroupDimXOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkgroupDimXOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkgroupDimYOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkgroupDimYOpGenericAdaptorBase::WorkgroupDimYOpGenericAdaptorBase(WorkgroupDimYOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupDimYOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkgroupDimYOpAdaptor::WorkgroupDimYOpAdaptor(WorkgroupDimYOp op) : WorkgroupDimYOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkgroupDimYOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.local_size.y' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimYOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkgroupDimYOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkgroupDimYOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkgroupDimYOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkgroupDimYOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkgroupDimYOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkgroupDimYOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimYOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkgroupDimYOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupDimYOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkgroupDimYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkgroupDimYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkgroupDimYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkgroupDimYOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkgroupDimYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimYOp WorkgroupDimYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkgroupDimYOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimYOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkgroupDimYOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkgroupDimYOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkgroupDimYOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkgroupDimYOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkgroupDimZOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkgroupDimZOpGenericAdaptorBase::WorkgroupDimZOpGenericAdaptorBase(WorkgroupDimZOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupDimZOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkgroupDimZOpAdaptor::WorkgroupDimZOpAdaptor(WorkgroupDimZOp op) : WorkgroupDimZOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkgroupDimZOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.local_size.z' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimZOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkgroupDimZOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkgroupDimZOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkgroupDimZOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkgroupDimZOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkgroupDimZOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkgroupDimZOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimZOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkgroupDimZOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupDimZOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkgroupDimZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkgroupDimZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkgroupDimZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkgroupDimZOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkgroupDimZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupDimZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupDimZOp WorkgroupDimZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkgroupDimZOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupDimZOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkgroupDimZOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkgroupDimZOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkgroupDimZOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkgroupDimZOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkgroupIdXOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkgroupIdXOpGenericAdaptorBase::WorkgroupIdXOpGenericAdaptorBase(WorkgroupIdXOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupIdXOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkgroupIdXOpAdaptor::WorkgroupIdXOpAdaptor(WorkgroupIdXOp op) : WorkgroupIdXOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkgroupIdXOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.group_id.x' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdXOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkgroupIdXOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkgroupIdXOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkgroupIdXOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkgroupIdXOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkgroupIdXOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkgroupIdXOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdXOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkgroupIdXOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupIdXOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkgroupIdXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkgroupIdXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkgroupIdXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkgroupIdXOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkgroupIdXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdXOp WorkgroupIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkgroupIdXOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdXOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkgroupIdXOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkgroupIdXOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkgroupIdXOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkgroupIdXOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkgroupIdYOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkgroupIdYOpGenericAdaptorBase::WorkgroupIdYOpGenericAdaptorBase(WorkgroupIdYOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupIdYOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkgroupIdYOpAdaptor::WorkgroupIdYOpAdaptor(WorkgroupIdYOp op) : WorkgroupIdYOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkgroupIdYOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.group_id.y' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdYOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkgroupIdYOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkgroupIdYOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkgroupIdYOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkgroupIdYOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkgroupIdYOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkgroupIdYOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdYOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkgroupIdYOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupIdYOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkgroupIdYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkgroupIdYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkgroupIdYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkgroupIdYOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkgroupIdYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdYOp WorkgroupIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkgroupIdYOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdYOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkgroupIdYOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkgroupIdYOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkgroupIdYOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkgroupIdYOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkgroupIdZOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkgroupIdZOpGenericAdaptorBase::WorkgroupIdZOpGenericAdaptorBase(WorkgroupIdZOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupIdZOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkgroupIdZOpAdaptor::WorkgroupIdZOpAdaptor(WorkgroupIdZOp op) : WorkgroupIdZOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkgroupIdZOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.group_id.z' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdZOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkgroupIdZOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkgroupIdZOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkgroupIdZOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkgroupIdZOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkgroupIdZOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkgroupIdZOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdZOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkgroupIdZOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkgroupIdZOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkgroupIdZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkgroupIdZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkgroupIdZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkgroupIdZOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkgroupIdZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkgroupIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkgroupIdZOp WorkgroupIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkgroupIdZOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkgroupIdZOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkgroupIdZOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkgroupIdZOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkgroupIdZOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkgroupIdZOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkitemIdXOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkitemIdXOpGenericAdaptorBase::WorkitemIdXOpGenericAdaptorBase(WorkitemIdXOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkitemIdXOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkitemIdXOpAdaptor::WorkitemIdXOpAdaptor(WorkitemIdXOp op) : WorkitemIdXOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkitemIdXOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.local_id.x' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdXOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkitemIdXOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkitemIdXOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkitemIdXOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkitemIdXOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkitemIdXOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkitemIdXOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdXOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkitemIdXOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkitemIdXOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkitemIdXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkitemIdXOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkitemIdXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkitemIdXOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkitemIdXOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdXOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdXOp WorkitemIdXOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkitemIdXOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdXOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkitemIdXOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkitemIdXOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkitemIdXOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkitemIdXOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkitemIdYOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkitemIdYOpGenericAdaptorBase::WorkitemIdYOpGenericAdaptorBase(WorkitemIdYOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkitemIdYOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkitemIdYOpAdaptor::WorkitemIdYOpAdaptor(WorkitemIdYOp op) : WorkitemIdYOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkitemIdYOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.local_id.y' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdYOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkitemIdYOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkitemIdYOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkitemIdYOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkitemIdYOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkitemIdYOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkitemIdYOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdYOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkitemIdYOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkitemIdYOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkitemIdYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkitemIdYOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkitemIdYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkitemIdYOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkitemIdYOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdYOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdYOp WorkitemIdYOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkitemIdYOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdYOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkitemIdYOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkitemIdYOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkitemIdYOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkitemIdYOp)

namespace mlir {
namespace xevm {

//===----------------------------------------------------------------------===//
// ::mlir::xevm::WorkitemIdZOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WorkitemIdZOpGenericAdaptorBase::WorkitemIdZOpGenericAdaptorBase(WorkitemIdZOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkitemIdZOpGenericAdaptorBase::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

} // namespace detail
WorkitemIdZOpAdaptor::WorkitemIdZOpAdaptor(WorkitemIdZOp op) : WorkitemIdZOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WorkitemIdZOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (tblgen_range && !((::llvm::isa<::mlir::LLVM::ConstantRangeAttr>(tblgen_range))))
    return emitError(loc, "'xevm.local_id.z' op ""attribute 'range' failed to satisfy constraint: A range of two integers, corresponding to LLVM's ConstantRange");
  return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdZOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.range;
       auto attr = dict.get("range");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `range` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WorkitemIdZOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.range;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("range",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WorkitemIdZOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.range.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WorkitemIdZOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "range")
      return prop.range;
  return std::nullopt;
}

void WorkitemIdZOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "range") {
       prop.range = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.range)>>(value);
       return;
    }
}

void WorkitemIdZOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.range) attrs.append("range", prop.range);
}

::llvm::LogicalResult WorkitemIdZOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(attr, "range", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdZOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.range)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WorkitemIdZOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.range);
}

::std::optional<::mlir::LLVM::ConstantRangeAttr> WorkitemIdZOp::getRange() {
  auto attr = getRangeAttr();
  return attr ? ::std::optional<::mlir::LLVM::ConstantRangeAttr>(::llvm::cast<::mlir::LLVM::ConstantRangeAttr>(attr)) : (::std::nullopt);
}

void WorkitemIdZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  odsState.addTypes(res);
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, res, range);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), res, range);
}

void WorkitemIdZOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  if (range) {
    odsState.getOrAddProperties<Properties>().range = range;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, range);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range) {
  return create(builder, builder.getLoc(), resultTypes, range);
}

void WorkitemIdZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WorkitemIdZOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WorkitemIdZOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WorkitemIdZOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WorkitemIdZOp WorkitemIdZOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WorkitemIdZOp::verifyInvariantsImpl() {
  auto tblgen_range = getProperties().range; (void)tblgen_range;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeVMOps5(*this, tblgen_range, "range")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeVMOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WorkitemIdZOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult WorkitemIdZOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::ConstantRangeAttr rangeAttr;
  ::mlir::Type resRawType{};
  ::llvm::ArrayRef<::mlir::Type> resTypes(&resRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("range"))) {

  if (parser.parseCustomAttributeWithFallback(rangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (rangeAttr) result.getOrAddProperties<WorkitemIdZOp::Properties>().range = rangeAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawType = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void WorkitemIdZOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getRangeAttr()) {
    _odsPrinter << ' ' << "range";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getRangeAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("range");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xevm
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xevm::WorkitemIdZOp)


#endif // GET_OP_CLASSES

