/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: CUFOps.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::cuf::AllocOp,
::cuf::AllocateOp,
::cuf::DataTransferOp,
::cuf::DeallocateOp,
::cuf::DeviceAddressOp,
::cuf::FreeOp,
::cuf::KernelLaunchOp,
::cuf::KernelOp,
::cuf::RegisterKernelOp,
::cuf::RegisterModuleOp,
::cuf::SharedMemoryOp,
::cuf::StreamCastOp,
::cuf::SyncDescriptorOp
#endif // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace cuf {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isSignlessIntOrIndex())) || (((type.hasTrait<::mlir::ValueSemantics>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessIntOrIndex()); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) || ((type.isSignedInteger())) || ((type.isUnsignedInteger())) || ((::llvm::isa<::fir::IntegerType>(type))) || ((::llvm::isa<::fir::UnsignedType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of any integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::fir::ReferenceType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be Reference to an entity type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::fir::ReferenceType>(type))) || ((::llvm::isa<::fir::HeapType>(type))) || ((::llvm::isa<::fir::PointerType>(type))) || ((mlir::isa<::fir::BaseBoxType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any legal ref or box type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isSignlessIntOrIndex())) || (((type.hasTrait<::mlir::ValueSemantics>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessIntOrIndex()); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) || ((type.isSignedInteger())) || ((type.isUnsignedInteger())) || ((::llvm::isa<::fir::IntegerType>(type))) || ((::llvm::isa<::fir::UnsignedType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((true))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::fir::ShapeType>(type))) || ((::llvm::isa<::fir::ShapeShiftType>(type))) || ((::llvm::isa<::fir::ShiftType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any legal shape or shift type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps7(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::fir::ReferenceType>(type))) || ((::llvm::isa<::fir::HeapType>(type))) || ((::llvm::isa<::fir::PointerType>(type))) || ((::llvm::isa<::fir::LLVMPointerType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any reference, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps8(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(32)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps9(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((true))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of any type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps10(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(32)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps11(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::IndexType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of index, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps12(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM pointer type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps13(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::fir::ReferenceType>(type))) || ((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be Reference to an entity type or LLVM pointer type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_CUFOps14(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::gpu::AsyncTokenType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be async token type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::TypeAttr>(attr))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(attr).getValue()))) && ((true))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: any type attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::StringAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: string attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::cuf::DataAttributeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: CUDA Fortran variable attributes";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::cuf::DataTransferKindAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: CUDA Fortran data transfer kind";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::SymbolRefAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: symbol reference attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::ArrayAttr>(attr))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(attr), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::DictionaryAttr>(attr))); }))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Array of dictionary attributes";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps8(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(64)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps8(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps9(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::ArrayAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: array attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_CUFOps9(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_CUFOps9(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_region_constraint_CUFOps1(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((true))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: any region";
  }
  return ::mlir::success();
}
} // namespace cuf
namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::AllocOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AllocOpGenericAdaptorBase::AllocOpGenericAdaptorBase(AllocOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> AllocOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Type AllocOpGenericAdaptorBase::getInType() {
  auto attr = getInTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::std::optional< ::llvm::StringRef > AllocOpGenericAdaptorBase::getUniqName() {
  auto attr = getUniqNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::std::optional< ::llvm::StringRef > AllocOpGenericAdaptorBase::getBindcName() {
  auto attr = getBindcNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::cuf::DataAttribute AllocOpGenericAdaptorBase::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

} // namespace detail
AllocOpAdaptor::AllocOpAdaptor(AllocOp op) : AllocOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AllocOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_bindc_name = getProperties().bindc_name; (void)tblgen_bindc_name;
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitError(loc, "'cuf.alloc' op ""requires attribute 'data_attr'");
  auto tblgen_in_type = getProperties().in_type; (void)tblgen_in_type;
  if (!tblgen_in_type) return emitError(loc, "'cuf.alloc' op ""requires attribute 'in_type'");
  auto tblgen_uniq_name = getProperties().uniq_name; (void)tblgen_uniq_name;

  if (tblgen_in_type && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_in_type))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_in_type).getValue()))) && ((true))))
    return emitError(loc, "'cuf.alloc' op ""attribute 'in_type' failed to satisfy constraint: any type attribute");

  if (tblgen_uniq_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_uniq_name))))
    return emitError(loc, "'cuf.alloc' op ""attribute 'uniq_name' failed to satisfy constraint: string attribute");

  if (tblgen_bindc_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_bindc_name))))
    return emitError(loc, "'cuf.alloc' op ""attribute 'bindc_name' failed to satisfy constraint: string attribute");

  if (tblgen_data_attr && !((::llvm::isa<::cuf::DataAttributeAttr>(tblgen_data_attr))))
    return emitError(loc, "'cuf.alloc' op ""attribute 'data_attr' failed to satisfy constraint: CUDA Fortran variable attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AllocOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange AllocOp::getTypeparamsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange AllocOp::getShapeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult AllocOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.bindc_name;
       auto attr = dict.get("bindc_name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `bindc_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.data_attr;
       auto attr = dict.get("data_attr");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `data_attr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.in_type;
       auto attr = dict.get("in_type");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `in_type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.uniq_name;
       auto attr = dict.get("uniq_name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `uniq_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute AllocOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.bindc_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("bindc_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.data_attr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("data_attr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.in_type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("in_type",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.uniq_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("uniq_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AllocOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.bindc_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.data_attr.getAsOpaquePointer()), 
    llvm::hash_value(prop.in_type.getAsOpaquePointer()), 
    llvm::hash_value(prop.uniq_name.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> AllocOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "bindc_name")
      return prop.bindc_name;

    if (name == "data_attr")
      return prop.data_attr;

    if (name == "in_type")
      return prop.in_type;

    if (name == "uniq_name")
      return prop.uniq_name;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void AllocOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "bindc_name") {
       prop.bindc_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.bindc_name)>>(value);
       return;
    }

    if (name == "data_attr") {
       prop.data_attr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.data_attr)>>(value);
       return;
    }

    if (name == "in_type") {
       prop.in_type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.in_type)>>(value);
       return;
    }

    if (name == "uniq_name") {
       prop.uniq_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.uniq_name)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void AllocOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.bindc_name) attrs.append("bindc_name", prop.bindc_name);

    if (prop.data_attr) attrs.append("data_attr", prop.data_attr);

    if (prop.in_type) attrs.append("in_type", prop.in_type);

    if (prop.uniq_name) attrs.append("uniq_name", prop.uniq_name);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult AllocOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getBindcNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(attr, "bindc_name", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getDataAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(attr, "data_attr", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getInTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps1(attr, "in_type", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getUniqNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(attr, "uniq_name", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AllocOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.bindc_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.data_attr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.in_type)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.uniq_name)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void AllocOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.bindc_name);
  writer.writeAttribute(prop.data_attr);
  writer.writeAttribute(prop.in_type);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.uniq_name);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::Type AllocOp::getInType() {
  auto attr = getInTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::std::optional< ::llvm::StringRef > AllocOp::getUniqName() {
  auto attr = getUniqNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::std::optional< ::llvm::StringRef > AllocOp::getBindcName() {
  auto attr = getBindcNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::cuf::DataAttribute AllocOp::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

void AllocOp::setInType(::mlir::Type attrValue) {
  getProperties().in_type = ::mlir::TypeAttr::get(attrValue);
}

void AllocOp::setUniqName(::std::optional<::llvm::StringRef> attrValue) {
    auto &odsProp = getProperties().uniq_name;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue);
    else
      odsProp = nullptr;
}

void AllocOp::setBindcName(::std::optional<::llvm::StringRef> attrValue) {
    auto &odsProp = getProperties().bindc_name;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue);
    else
      odsProp = nullptr;
}

void AllocOp::setDataAttr(::cuf::DataAttribute attrValue) {
  getProperties().data_attr = ::cuf::DataAttributeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, cuf::DataAttributeAttr cudaAttr, mlir::ValueRange typeparams, mlir::ValueRange shape, llvm::ArrayRef<mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, inType, uniqName, bindcName, cudaAttr, typeparams, shape, attributes);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, cuf::DataAttributeAttr cudaAttr, mlir::ValueRange typeparams, mlir::ValueRange shape, llvm::ArrayRef<mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), inType, uniqName, bindcName, cudaAttr, typeparams, shape, attributes);
}

void AllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = in_type;
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  odsState.addTypes(ptr);
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr) {
  return create(builder, builder.getLoc(), ptr, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
}

void AllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = in_type;
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttributeAttr data_attr) {
  return create(builder, builder.getLoc(), resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
}

void AllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = ::mlir::TypeAttr::get(in_type);
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  odsState.addTypes(ptr);
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr) {
  return create(builder, builder.getLoc(), ptr, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
}

void AllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = ::mlir::TypeAttr::get(in_type);
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, ::cuf::DataAttribute data_attr) {
  return create(builder, builder.getLoc(), resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, data_attr);
}

void AllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AllocOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AllocOp AllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocOp AllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AllocOp::verifyInvariantsImpl() {
  auto tblgen_bindc_name = getProperties().bindc_name; (void)tblgen_bindc_name;
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitOpError("requires attribute 'data_attr'");
  auto tblgen_in_type = getProperties().in_type; (void)tblgen_in_type;
  if (!tblgen_in_type) return emitOpError("requires attribute 'in_type'");
  auto tblgen_uniq_name = getProperties().uniq_name; (void)tblgen_uniq_name;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps1(*this, tblgen_in_type, "in_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(*this, tblgen_uniq_name, "uniq_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(*this, tblgen_bindc_name, "bindc_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(*this, tblgen_data_attr, "data_attr")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AllocOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AllocOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::TypeAttr in_typeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> typeparamsOperands;
  ::llvm::SMLoc typeparamsOperandsLoc;
  (void)typeparamsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> typeparamsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> shapeTypes;
  ::mlir::Type ptrRawType{};
  ::llvm::ArrayRef<::mlir::Type> ptrTypes(&ptrRawType, 1);

  if (parser.parseCustomAttributeWithFallback(in_typeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (in_typeAttr) result.getOrAddProperties<AllocOp::Properties>().in_type = in_typeAttr;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  typeparamsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(typeparamsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(typeparamsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  shapeOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shapeOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(shapeTypes))
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(ptrRawType))
    return ::mlir::failure();
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparamsOperands.size()), static_cast<int32_t>(shapeOperands.size())}), result.getOrAddProperties<AllocOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(ptrTypes);
  if (parser.resolveOperands(typeparamsOperands, typeparamsTypes, typeparamsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(shapeOperands, shapeTypes, shapeOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AllocOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getInTypeAttr());
  if (!getTypeparams().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getTypeparams();
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getTypeparams().getTypes();
    _odsPrinter << ")";
  }
  if (!getShape().empty()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << getShape();
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getShape().getTypes();
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("in_type");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getPtr().getType();
}

void AllocOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Allocate::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::AllocOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::AllocateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AllocateOpGenericAdaptorBase::AllocateOpGenericAdaptorBase(AllocateOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> AllocateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::cuf::DataAttribute AllocateOpGenericAdaptorBase::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

::mlir::UnitAttr AllocateOpGenericAdaptorBase::getHasStatAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasStat);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool AllocateOpGenericAdaptorBase::getHasStat() {
  auto attr = getHasStatAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
AllocateOpAdaptor::AllocateOpAdaptor(AllocateOp op) : AllocateOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AllocateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitError(loc, "'cuf.allocate' op ""requires attribute 'data_attr'");
  auto tblgen_hasStat = getProperties().hasStat; (void)tblgen_hasStat;

  if (tblgen_data_attr && !((::llvm::isa<::cuf::DataAttributeAttr>(tblgen_data_attr))))
    return emitError(loc, "'cuf.allocate' op ""attribute 'data_attr' failed to satisfy constraint: CUDA Fortran variable attributes");

  if (tblgen_hasStat && !((::llvm::isa<::mlir::UnitAttr>(tblgen_hasStat))))
    return emitError(loc, "'cuf.allocate' op ""attribute 'hasStat' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AllocateOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange AllocateOp::getErrmsgMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange AllocateOp::getStreamMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange AllocateOp::getPinnedMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange AllocateOp::getSourceMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult AllocateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.data_attr;
       auto attr = dict.get("data_attr");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `data_attr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.hasStat;
       auto attr = dict.get("hasStat");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `hasStat` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute AllocateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.data_attr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("data_attr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.hasStat;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hasStat",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AllocateOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.data_attr.getAsOpaquePointer()), 
    llvm::hash_value(prop.hasStat.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> AllocateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "data_attr")
      return prop.data_attr;

    if (name == "hasStat")
      return prop.hasStat;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void AllocateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "data_attr") {
       prop.data_attr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.data_attr)>>(value);
       return;
    }

    if (name == "hasStat") {
       prop.hasStat = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hasStat)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void AllocateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.data_attr) attrs.append("data_attr", prop.data_attr);

    if (prop.hasStat) attrs.append("hasStat", prop.hasStat);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult AllocateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getDataAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(attr, "data_attr", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getHasStatAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps4(attr, "hasStat", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AllocateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.data_attr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.hasStat)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void AllocateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.data_attr);

  writer.writeOptionalAttribute(prop.hasStat);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::cuf::DataAttribute AllocateOp::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

bool AllocateOp::getHasStat() {
  auto attr = getHasStatAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void AllocateOp::setDataAttr(::cuf::DataAttribute attrValue) {
  getProperties().data_attr = ::cuf::DataAttributeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void AllocateOp::setHasStat(bool attrValue) {
    auto &odsProp = getProperties().hasStat;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void AllocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  if (stream)
    odsState.addOperands(stream);
  if (pinned)
    odsState.addOperands(pinned);
  if (source)
    odsState.addOperands(source);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (errmsg ? 1 : 0), (stream ? 1 : 0), (pinned ? 1 : 0), (source ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = hasStat;
  }
  odsState.addTypes(stat);
}

AllocateOp AllocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, stat, box, errmsg, stream, pinned, source, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<AllocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocateOp AllocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  return create(builder, builder.getLoc(), stat, box, errmsg, stream, pinned, source, data_attr, hasStat);
}

void AllocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  if (stream)
    odsState.addOperands(stream);
  if (pinned)
    odsState.addOperands(pinned);
  if (source)
    odsState.addOperands(source);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (errmsg ? 1 : 0), (stream ? 1 : 0), (pinned ? 1 : 0), (source ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = hasStat;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AllocateOp AllocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, box, errmsg, stream, pinned, source, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<AllocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocateOp AllocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  return create(builder, builder.getLoc(), resultTypes, box, errmsg, stream, pinned, source, data_attr, hasStat);
}

void AllocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  if (stream)
    odsState.addOperands(stream);
  if (pinned)
    odsState.addOperands(pinned);
  if (source)
    odsState.addOperands(source);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (errmsg ? 1 : 0), (stream ? 1 : 0), (pinned ? 1 : 0), (source ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = ((hasStat) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.addTypes(stat);
}

AllocateOp AllocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, stat, box, errmsg, stream, pinned, source, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<AllocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocateOp AllocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  return create(builder, builder.getLoc(), stat, box, errmsg, stream, pinned, source, data_attr, hasStat);
}

void AllocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  if (stream)
    odsState.addOperands(stream);
  if (pinned)
    odsState.addOperands(pinned);
  if (source)
    odsState.addOperands(source);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (errmsg ? 1 : 0), (stream ? 1 : 0), (pinned ? 1 : 0), (source ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = ((hasStat) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AllocateOp AllocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, box, errmsg, stream, pinned, source, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<AllocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocateOp AllocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, /*optional*/::mlir::Value stream, /*optional*/::mlir::Value pinned, /*optional*/::mlir::Value source, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  return create(builder, builder.getLoc(), resultTypes, box, errmsg, stream, pinned, source, data_attr, hasStat);
}

void AllocateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AllocateOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

AllocateOp AllocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AllocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocateOp AllocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AllocateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AllocateOp AllocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AllocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AllocateOp AllocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AllocateOp::verifyInvariantsImpl() {
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitOpError("requires attribute 'data_attr'");
  auto tblgen_hasStat = getProperties().hasStat; (void)tblgen_hasStat;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(*this, tblgen_data_attr, "data_attr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps4(*this, tblgen_hasStat, "hasStat")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps4(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AllocateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AllocateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand boxRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> boxOperands(&boxRawOperand, 1);  ::llvm::SMLoc boxOperandsLoc;
  (void)boxOperandsLoc;
  ::mlir::Type boxRawType{};
  ::llvm::ArrayRef<::mlir::Type> boxTypes(&boxRawType, 1);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> sourceOperands;
  ::llvm::SMLoc sourceOperandsLoc;
  (void)sourceOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> sourceTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> errmsgOperands;
  ::llvm::SMLoc errmsgOperandsLoc;
  (void)errmsgOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> errmsgTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> streamOperands;
  ::llvm::SMLoc streamOperandsLoc;
  (void)streamOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> streamTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> pinnedOperands;
  ::llvm::SMLoc pinnedOperandsLoc;
  (void)pinnedOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> pinnedTypes;
  ::mlir::Type statRawType{};
  ::llvm::ArrayRef<::mlir::Type> statTypes(&statRawType, 1);

  boxOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(boxRawOperand))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(boxRawType))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("source"))) {
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    sourceOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      sourceOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      sourceTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("errmsg"))) {
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    errmsgOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      errmsgOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      errmsgTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("stream"))) {
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    streamOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      streamOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      streamTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("pinned"))) {
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    pinnedOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      pinnedOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      pinnedTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    statRawType = type;
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(errmsgOperands.size()), static_cast<int32_t>(streamOperands.size()), static_cast<int32_t>(pinnedOperands.size()), static_cast<int32_t>(sourceOperands.size())}), result.getOrAddProperties<AllocateOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(statTypes);
  if (parser.resolveOperands(boxOperands, boxTypes, boxOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(errmsgOperands, errmsgTypes, errmsgOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(streamOperands, streamTypes, streamOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(pinnedOperands, pinnedTypes, pinnedOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(sourceOperands, sourceTypes, sourceOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AllocateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBox();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getBox().getType();
  if (getSource()) {
    _odsPrinter << ' ' << "source";
    _odsPrinter << "(";
    if (::mlir::Value value = getSource())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getSource() ? ::llvm::ArrayRef<::mlir::Type>(getSource().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    _odsPrinter << ")";
  }
  if (getErrmsg()) {
    _odsPrinter << ' ' << "errmsg";
    _odsPrinter << "(";
    if (::mlir::Value value = getErrmsg())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getErrmsg() ? ::llvm::ArrayRef<::mlir::Type>(getErrmsg().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    _odsPrinter << ")";
  }
  if (getStream()) {
    _odsPrinter << ' ' << "stream";
    _odsPrinter << "(";
    if (::mlir::Value value = getStream())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getStream() ? ::llvm::ArrayRef<::mlir::Type>(getStream().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    _odsPrinter << ")";
  }
  if (getPinned()) {
    _odsPrinter << ' ' << "pinned";
    _odsPrinter << "(";
    if (::mlir::Value value = getPinned())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getPinned() ? ::llvm::ArrayRef<::mlir::Type>(getPinned().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getHasStatAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("hasStat");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getStat().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void AllocateOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Allocate::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(1);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(3);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(4);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::AllocateOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::DataTransferOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DataTransferOpGenericAdaptorBase::DataTransferOpGenericAdaptorBase(DataTransferOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> DataTransferOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::cuf::DataTransferKind DataTransferOpGenericAdaptorBase::getTransferKind() {
  auto attr = getTransferKindAttr();
  return attr.getValue();
}

} // namespace detail
DataTransferOpAdaptor::DataTransferOpAdaptor(DataTransferOp op) : DataTransferOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult DataTransferOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_transfer_kind = getProperties().transfer_kind; (void)tblgen_transfer_kind;
  if (!tblgen_transfer_kind) return emitError(loc, "'cuf.data_transfer' op ""requires attribute 'transfer_kind'");

  if (tblgen_transfer_kind && !((::llvm::isa<::cuf::DataTransferKindAttr>(tblgen_transfer_kind))))
    return emitError(loc, "'cuf.data_transfer' op ""attribute 'transfer_kind' failed to satisfy constraint: CUDA Fortran data transfer kind");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DataTransferOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange DataTransferOp::getShapeMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult DataTransferOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.transfer_kind;
       auto attr = dict.get("transfer_kind");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `transfer_kind` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute DataTransferOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.transfer_kind;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("transfer_kind",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DataTransferOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.transfer_kind.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> DataTransferOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "transfer_kind")
      return prop.transfer_kind;
  return std::nullopt;
}

void DataTransferOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "transfer_kind") {
       prop.transfer_kind = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.transfer_kind)>>(value);
       return;
    }
}

void DataTransferOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.transfer_kind) attrs.append("transfer_kind", prop.transfer_kind);
}

::llvm::LogicalResult DataTransferOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getTransferKindAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps5(attr, "transfer_kind", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult DataTransferOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.transfer_kind)))
    return ::mlir::failure();
  return ::mlir::success();
}

void DataTransferOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.transfer_kind);
}

::cuf::DataTransferKind DataTransferOp::getTransferKind() {
  auto attr = getTransferKindAttr();
  return attr.getValue();
}

void DataTransferOp::setTransferKind(::cuf::DataTransferKind attrValue) {
  getProperties().transfer_kind = ::cuf::DataTransferKindAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void DataTransferOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind) {
  odsState.addOperands(src);
  odsState.addOperands(dst);
  if (shape)
    odsState.addOperands(shape);
  odsState.getOrAddProperties<Properties>().transfer_kind = transfer_kind;
}

DataTransferOp DataTransferOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, src, dst, shape, transfer_kind);
  auto __res__ = ::llvm::dyn_cast<DataTransferOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DataTransferOp DataTransferOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind) {
  return create(builder, builder.getLoc(), src, dst, shape, transfer_kind);
}

void DataTransferOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind) {
  odsState.addOperands(src);
  odsState.addOperands(dst);
  if (shape)
    odsState.addOperands(shape);
  odsState.getOrAddProperties<Properties>().transfer_kind = transfer_kind;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

DataTransferOp DataTransferOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src, dst, shape, transfer_kind);
  auto __res__ = ::llvm::dyn_cast<DataTransferOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DataTransferOp DataTransferOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKindAttr transfer_kind) {
  return create(builder, builder.getLoc(), resultTypes, src, dst, shape, transfer_kind);
}

void DataTransferOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind) {
  odsState.addOperands(src);
  odsState.addOperands(dst);
  if (shape)
    odsState.addOperands(shape);
  odsState.getOrAddProperties<Properties>().transfer_kind = ::cuf::DataTransferKindAttr::get(odsBuilder.getContext(), transfer_kind);
}

DataTransferOp DataTransferOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, src, dst, shape, transfer_kind);
  auto __res__ = ::llvm::dyn_cast<DataTransferOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DataTransferOp DataTransferOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind) {
  return create(builder, builder.getLoc(), src, dst, shape, transfer_kind);
}

void DataTransferOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind) {
  odsState.addOperands(src);
  odsState.addOperands(dst);
  if (shape)
    odsState.addOperands(shape);
  odsState.getOrAddProperties<Properties>().transfer_kind = ::cuf::DataTransferKindAttr::get(odsBuilder.getContext(), transfer_kind);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

DataTransferOp DataTransferOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src, dst, shape, transfer_kind);
  auto __res__ = ::llvm::dyn_cast<DataTransferOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DataTransferOp DataTransferOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value shape, ::cuf::DataTransferKind transfer_kind) {
  return create(builder, builder.getLoc(), resultTypes, src, dst, shape, transfer_kind);
}

void DataTransferOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<DataTransferOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

DataTransferOp DataTransferOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<DataTransferOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DataTransferOp DataTransferOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void DataTransferOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

DataTransferOp DataTransferOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<DataTransferOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DataTransferOp DataTransferOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult DataTransferOp::verifyInvariantsImpl() {
  auto tblgen_transfer_kind = getProperties().transfer_kind; (void)tblgen_transfer_kind;
  if (!tblgen_transfer_kind) return emitOpError("requires attribute 'transfer_kind'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps5(*this, tblgen_transfer_kind, "transfer_kind")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult DataTransferOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DataTransferOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dstRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dstOperands(&dstRawOperand, 1);  ::llvm::SMLoc dstOperandsLoc;
  (void)dstOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> shapeTypes;
  ::mlir::Type srcRawType{};
  ::llvm::ArrayRef<::mlir::Type> srcTypes(&srcRawType, 1);
  ::mlir::Type dstRawType{};
  ::llvm::ArrayRef<::mlir::Type> dstTypes(&dstRawType, 1);

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  if (parser.parseKeyword("to"))
    return ::mlir::failure();

  dstOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dstRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    shapeOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      shapeOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      shapeTypes.push_back(optionalType);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    srcRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    dstRawType = type;
  }
  if (parser.resolveOperands(srcOperands, srcTypes, srcOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dstOperands, dstTypes, dstOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(shapeOperands, shapeTypes, shapeOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DataTransferOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ';
  _odsPrinter << getDst();
  if (getShape()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getShape())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getShape() ? ::llvm::ArrayRef<::mlir::Type>(getShape().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getSrc().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getDst().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void DataTransferOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(1);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::DataTransferOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::DeallocateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeallocateOpGenericAdaptorBase::DeallocateOpGenericAdaptorBase(DeallocateOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> DeallocateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::cuf::DataAttribute DeallocateOpGenericAdaptorBase::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

::mlir::UnitAttr DeallocateOpGenericAdaptorBase::getHasStatAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasStat);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool DeallocateOpGenericAdaptorBase::getHasStat() {
  auto attr = getHasStatAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
DeallocateOpAdaptor::DeallocateOpAdaptor(DeallocateOp op) : DeallocateOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult DeallocateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitError(loc, "'cuf.deallocate' op ""requires attribute 'data_attr'");
  auto tblgen_hasStat = getProperties().hasStat; (void)tblgen_hasStat;

  if (tblgen_data_attr && !((::llvm::isa<::cuf::DataAttributeAttr>(tblgen_data_attr))))
    return emitError(loc, "'cuf.deallocate' op ""attribute 'data_attr' failed to satisfy constraint: CUDA Fortran variable attributes");

  if (tblgen_hasStat && !((::llvm::isa<::mlir::UnitAttr>(tblgen_hasStat))))
    return emitError(loc, "'cuf.deallocate' op ""attribute 'hasStat' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DeallocateOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange DeallocateOp::getErrmsgMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult DeallocateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.data_attr;
       auto attr = dict.get("data_attr");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `data_attr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.hasStat;
       auto attr = dict.get("hasStat");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `hasStat` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute DeallocateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.data_attr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("data_attr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.hasStat;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hasStat",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DeallocateOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.data_attr.getAsOpaquePointer()), 
    llvm::hash_value(prop.hasStat.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> DeallocateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "data_attr")
      return prop.data_attr;

    if (name == "hasStat")
      return prop.hasStat;
  return std::nullopt;
}

void DeallocateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "data_attr") {
       prop.data_attr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.data_attr)>>(value);
       return;
    }

    if (name == "hasStat") {
       prop.hasStat = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hasStat)>>(value);
       return;
    }
}

void DeallocateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.data_attr) attrs.append("data_attr", prop.data_attr);

    if (prop.hasStat) attrs.append("hasStat", prop.hasStat);
}

::llvm::LogicalResult DeallocateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getDataAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(attr, "data_attr", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getHasStatAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps4(attr, "hasStat", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult DeallocateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.data_attr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.hasStat)))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeallocateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.data_attr);

  writer.writeOptionalAttribute(prop.hasStat);
}

::cuf::DataAttribute DeallocateOp::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

bool DeallocateOp::getHasStat() {
  auto attr = getHasStatAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void DeallocateOp::setDataAttr(::cuf::DataAttribute attrValue) {
  getProperties().data_attr = ::cuf::DataAttributeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void DeallocateOp::setHasStat(bool attrValue) {
    auto &odsProp = getProperties().hasStat;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void DeallocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = hasStat;
  }
  odsState.addTypes(stat);
}

DeallocateOp DeallocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, stat, box, errmsg, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<DeallocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeallocateOp DeallocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  return create(builder, builder.getLoc(), stat, box, errmsg, data_attr, hasStat);
}

void DeallocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = hasStat;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

DeallocateOp DeallocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, box, errmsg, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<DeallocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeallocateOp DeallocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::UnitAttr hasStat) {
  return create(builder, builder.getLoc(), resultTypes, box, errmsg, data_attr, hasStat);
}

void DeallocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = ((hasStat) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.addTypes(stat);
}

DeallocateOp DeallocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, stat, box, errmsg, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<DeallocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeallocateOp DeallocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type stat, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  return create(builder, builder.getLoc(), stat, box, errmsg, data_attr, hasStat);
}

void DeallocateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  odsState.addOperands(box);
  if (errmsg)
    odsState.addOperands(errmsg);
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  if (hasStat) {
    odsState.getOrAddProperties<Properties>().hasStat = ((hasStat) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

DeallocateOp DeallocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, box, errmsg, data_attr, hasStat);
  auto __res__ = ::llvm::dyn_cast<DeallocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeallocateOp DeallocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value errmsg, ::cuf::DataAttribute data_attr, /*optional*/bool hasStat) {
  return create(builder, builder.getLoc(), resultTypes, box, errmsg, data_attr, hasStat);
}

void DeallocateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<DeallocateOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

DeallocateOp DeallocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<DeallocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeallocateOp DeallocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void DeallocateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

DeallocateOp DeallocateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<DeallocateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeallocateOp DeallocateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult DeallocateOp::verifyInvariantsImpl() {
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitOpError("requires attribute 'data_attr'");
  auto tblgen_hasStat = getProperties().hasStat; (void)tblgen_hasStat;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(*this, tblgen_data_attr, "data_attr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps4(*this, tblgen_hasStat, "hasStat")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps4(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult DeallocateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DeallocateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand boxRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> boxOperands(&boxRawOperand, 1);  ::llvm::SMLoc boxOperandsLoc;
  (void)boxOperandsLoc;
  ::mlir::Type boxRawType{};
  ::llvm::ArrayRef<::mlir::Type> boxTypes(&boxRawType, 1);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> errmsgOperands;
  ::llvm::SMLoc errmsgOperandsLoc;
  (void)errmsgOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> errmsgTypes;
  ::mlir::Type statRawType{};
  ::llvm::ArrayRef<::mlir::Type> statTypes(&statRawType, 1);

  boxOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(boxRawOperand))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(boxRawType))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("errmsg"))) {
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    errmsgOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      errmsgOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      errmsgTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    statRawType = type;
  }
  result.addTypes(statTypes);
  if (parser.resolveOperands(boxOperands, boxTypes, boxOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(errmsgOperands, errmsgTypes, errmsgOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeallocateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBox();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getBox().getType();
  if (getErrmsg()) {
    _odsPrinter << ' ' << "errmsg";
    _odsPrinter << "(";
    if (::mlir::Value value = getErrmsg())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getErrmsg() ? ::llvm::ArrayRef<::mlir::Type>(getErrmsg().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getHasStatAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("hasStat");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getStat().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void DeallocateOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Free::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(1);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::DeallocateOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::DeviceAddressOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeviceAddressOpGenericAdaptorBase::DeviceAddressOpGenericAdaptorBase(DeviceAddressOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::SymbolRefAttr DeviceAddressOpGenericAdaptorBase::getHostSymbol() {
  auto attr = getHostSymbolAttr();
  return attr;
}

} // namespace detail
DeviceAddressOpAdaptor::DeviceAddressOpAdaptor(DeviceAddressOp op) : DeviceAddressOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult DeviceAddressOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_hostSymbol = getProperties().hostSymbol; (void)tblgen_hostSymbol;
  if (!tblgen_hostSymbol) return emitError(loc, "'cuf.device_address' op ""requires attribute 'hostSymbol'");

  if (tblgen_hostSymbol && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_hostSymbol))))
    return emitError(loc, "'cuf.device_address' op ""attribute 'hostSymbol' failed to satisfy constraint: symbol reference attribute");
  return ::mlir::success();
}

::llvm::LogicalResult DeviceAddressOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.hostSymbol;
       auto attr = dict.get("hostSymbol");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `hostSymbol` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute DeviceAddressOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.hostSymbol;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hostSymbol",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DeviceAddressOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.hostSymbol.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> DeviceAddressOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "hostSymbol")
      return prop.hostSymbol;
  return std::nullopt;
}

void DeviceAddressOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "hostSymbol") {
       prop.hostSymbol = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hostSymbol)>>(value);
       return;
    }
}

void DeviceAddressOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.hostSymbol) attrs.append("hostSymbol", prop.hostSymbol);
}

::llvm::LogicalResult DeviceAddressOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getHostSymbolAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(attr, "hostSymbol", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult DeviceAddressOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.hostSymbol)))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeviceAddressOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.hostSymbol);
}

::mlir::SymbolRefAttr DeviceAddressOp::getHostSymbol() {
  auto attr = getHostSymbolAttr();
  return attr;
}

void DeviceAddressOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type addr, ::mlir::SymbolRefAttr hostSymbol) {
  odsState.getOrAddProperties<Properties>().hostSymbol = hostSymbol;
  odsState.addTypes(addr);
}

DeviceAddressOp DeviceAddressOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type addr, ::mlir::SymbolRefAttr hostSymbol) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, addr, hostSymbol);
  auto __res__ = ::llvm::dyn_cast<DeviceAddressOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeviceAddressOp DeviceAddressOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type addr, ::mlir::SymbolRefAttr hostSymbol) {
  return create(builder, builder.getLoc(), addr, hostSymbol);
}

void DeviceAddressOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr hostSymbol) {
  odsState.getOrAddProperties<Properties>().hostSymbol = hostSymbol;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

DeviceAddressOp DeviceAddressOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr hostSymbol) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, hostSymbol);
  auto __res__ = ::llvm::dyn_cast<DeviceAddressOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeviceAddressOp DeviceAddressOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr hostSymbol) {
  return create(builder, builder.getLoc(), resultTypes, hostSymbol);
}

void DeviceAddressOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<DeviceAddressOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

DeviceAddressOp DeviceAddressOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<DeviceAddressOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeviceAddressOp DeviceAddressOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void DeviceAddressOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

DeviceAddressOp DeviceAddressOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<DeviceAddressOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

DeviceAddressOp DeviceAddressOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult DeviceAddressOp::verifyInvariantsImpl() {
  auto tblgen_hostSymbol = getProperties().hostSymbol; (void)tblgen_hostSymbol;
  if (!tblgen_hostSymbol) return emitOpError("requires attribute 'hostSymbol'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(*this, tblgen_hostSymbol, "hostSymbol")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult DeviceAddressOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult DeviceAddressOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr hostSymbolAttr;
  ::mlir::Type addrRawType{};
  ::llvm::ArrayRef<::mlir::Type> addrTypes(&addrRawType, 1);

  if (parser.parseCustomAttributeWithFallback(hostSymbolAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (hostSymbolAttr) result.getOrAddProperties<DeviceAddressOp::Properties>().hostSymbol = hostSymbolAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::fir::ReferenceType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    addrRawType = type;
  }
  result.addTypes(addrTypes);
  return ::mlir::success();
}

void DeviceAddressOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getHostSymbolAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("hostSymbol");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAddr().getType();
    if (auto validType = ::llvm::dyn_cast<::fir::ReferenceType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::DeviceAddressOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::FreeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FreeOpGenericAdaptorBase::FreeOpGenericAdaptorBase(FreeOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::cuf::DataAttribute FreeOpGenericAdaptorBase::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

} // namespace detail
FreeOpAdaptor::FreeOpAdaptor(FreeOp op) : FreeOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult FreeOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitError(loc, "'cuf.free' op ""requires attribute 'data_attr'");

  if (tblgen_data_attr && !((::llvm::isa<::cuf::DataAttributeAttr>(tblgen_data_attr))))
    return emitError(loc, "'cuf.free' op ""attribute 'data_attr' failed to satisfy constraint: CUDA Fortran variable attributes");
  return ::mlir::success();
}

::llvm::LogicalResult FreeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.data_attr;
       auto attr = dict.get("data_attr");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `data_attr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FreeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.data_attr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("data_attr",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FreeOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.data_attr.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FreeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "data_attr")
      return prop.data_attr;
  return std::nullopt;
}

void FreeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "data_attr") {
       prop.data_attr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.data_attr)>>(value);
       return;
    }
}

void FreeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.data_attr) attrs.append("data_attr", prop.data_attr);
}

::llvm::LogicalResult FreeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getDataAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(attr, "data_attr", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult FreeOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.data_attr)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FreeOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.data_attr);
}

::cuf::DataAttribute FreeOp::getDataAttr() {
  auto attr = getDataAttrAttr();
  return attr.getValue();
}

void FreeOp::setDataAttr(::cuf::DataAttribute attrValue) {
  getProperties().data_attr = ::cuf::DataAttributeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void FreeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr) {
  odsState.addOperands(devptr);
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
}

FreeOp FreeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, devptr, data_attr);
  auto __res__ = ::llvm::dyn_cast<FreeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FreeOp FreeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr) {
  return create(builder, builder.getLoc(), devptr, data_attr);
}

void FreeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr) {
  odsState.addOperands(devptr);
  odsState.getOrAddProperties<Properties>().data_attr = data_attr;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

FreeOp FreeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, devptr, data_attr);
  auto __res__ = ::llvm::dyn_cast<FreeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FreeOp FreeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttributeAttr data_attr) {
  return create(builder, builder.getLoc(), resultTypes, devptr, data_attr);
}

void FreeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value devptr, ::cuf::DataAttribute data_attr) {
  odsState.addOperands(devptr);
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
}

FreeOp FreeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value devptr, ::cuf::DataAttribute data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, devptr, data_attr);
  auto __res__ = ::llvm::dyn_cast<FreeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FreeOp FreeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value devptr, ::cuf::DataAttribute data_attr) {
  return create(builder, builder.getLoc(), devptr, data_attr);
}

void FreeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttribute data_attr) {
  odsState.addOperands(devptr);
  odsState.getOrAddProperties<Properties>().data_attr = ::cuf::DataAttributeAttr::get(odsBuilder.getContext(), data_attr);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

FreeOp FreeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttribute data_attr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, devptr, data_attr);
  auto __res__ = ::llvm::dyn_cast<FreeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FreeOp FreeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value devptr, ::cuf::DataAttribute data_attr) {
  return create(builder, builder.getLoc(), resultTypes, devptr, data_attr);
}

void FreeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<FreeOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

FreeOp FreeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<FreeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FreeOp FreeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void FreeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

FreeOp FreeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<FreeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FreeOp FreeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult FreeOp::verifyInvariantsImpl() {
  auto tblgen_data_attr = getProperties().data_attr; (void)tblgen_data_attr;
  if (!tblgen_data_attr) return emitOpError("requires attribute 'data_attr'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps3(*this, tblgen_data_attr, "data_attr")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult FreeOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult FreeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand devptrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> devptrOperands(&devptrRawOperand, 1);  ::llvm::SMLoc devptrOperandsLoc;
  (void)devptrOperandsLoc;
  ::mlir::Type devptrRawType{};
  ::llvm::ArrayRef<::mlir::Type> devptrTypes(&devptrRawType, 1);

  devptrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(devptrRawOperand))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(devptrRawType))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.resolveOperands(devptrOperands, devptrTypes, devptrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FreeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDevptr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getDevptr().getType();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

void FreeOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Free::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Free::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::SideEffects::DefaultResource::get());
    }
  }
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::FreeOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::KernelLaunchOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
KernelLaunchOpGenericAdaptorBase::KernelLaunchOpGenericAdaptorBase(KernelLaunchOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> KernelLaunchOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::SymbolRefAttr KernelLaunchOpGenericAdaptorBase::getCallee() {
  auto attr = getCalleeAttr();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > KernelLaunchOpGenericAdaptorBase::getArgAttrs() {
  auto attr = getArgAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::std::optional< ::mlir::ArrayAttr > KernelLaunchOpGenericAdaptorBase::getResAttrs() {
  auto attr = getResAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
KernelLaunchOpAdaptor::KernelLaunchOpAdaptor(KernelLaunchOp op) : KernelLaunchOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult KernelLaunchOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_arg_attrs = getProperties().arg_attrs; (void)tblgen_arg_attrs;
  auto tblgen_callee = getProperties().callee; (void)tblgen_callee;
  if (!tblgen_callee) return emitError(loc, "'cuf.kernel_launch' op ""requires attribute 'callee'");
  auto tblgen_res_attrs = getProperties().res_attrs; (void)tblgen_res_attrs;

  if (tblgen_callee && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_callee))))
    return emitError(loc, "'cuf.kernel_launch' op ""attribute 'callee' failed to satisfy constraint: symbol reference attribute");

  if (tblgen_arg_attrs && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_arg_attrs))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_arg_attrs), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::DictionaryAttr>(attr))); }))))
    return emitError(loc, "'cuf.kernel_launch' op ""attribute 'arg_attrs' failed to satisfy constraint: Array of dictionary attributes");

  if (tblgen_res_attrs && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_res_attrs))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_res_attrs), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::DictionaryAttr>(attr))); }))))
    return emitError(loc, "'cuf.kernel_launch' op ""attribute 'res_attrs' failed to satisfy constraint: Array of dictionary attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> KernelLaunchOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange KernelLaunchOp::getBytesMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelLaunchOp::getStreamMutable() {
  auto range = getODSOperandIndexAndLength(7);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(7u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelLaunchOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(8);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(8u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult KernelLaunchOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.arg_attrs;
       auto attr = dict.get("arg_attrs");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `arg_attrs` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.callee;
       auto attr = dict.get("callee");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `callee` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.res_attrs;
       auto attr = dict.get("res_attrs");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `res_attrs` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute KernelLaunchOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.arg_attrs;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("arg_attrs",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.callee;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("callee",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.res_attrs;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("res_attrs",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code KernelLaunchOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.arg_attrs.getAsOpaquePointer()), 
    llvm::hash_value(prop.callee.getAsOpaquePointer()), 
    llvm::hash_value(prop.res_attrs.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> KernelLaunchOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "arg_attrs")
      return prop.arg_attrs;

    if (name == "callee")
      return prop.callee;

    if (name == "res_attrs")
      return prop.res_attrs;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void KernelLaunchOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "arg_attrs") {
       prop.arg_attrs = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.arg_attrs)>>(value);
       return;
    }

    if (name == "callee") {
       prop.callee = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.callee)>>(value);
       return;
    }

    if (name == "res_attrs") {
       prop.res_attrs = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.res_attrs)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void KernelLaunchOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.arg_attrs) attrs.append("arg_attrs", prop.arg_attrs);

    if (prop.callee) attrs.append("callee", prop.callee);

    if (prop.res_attrs) attrs.append("res_attrs", prop.res_attrs);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult KernelLaunchOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getArgAttrsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps7(attr, "arg_attrs", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getCalleeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(attr, "callee", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getResAttrsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps7(attr, "res_attrs", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult KernelLaunchOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.arg_attrs)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.callee)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.res_attrs)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void KernelLaunchOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.arg_attrs);
  writer.writeAttribute(prop.callee);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.res_attrs);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::SymbolRefAttr KernelLaunchOp::getCallee() {
  auto attr = getCalleeAttr();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > KernelLaunchOp::getArgAttrs() {
  auto attr = getArgAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::std::optional< ::mlir::ArrayAttr > KernelLaunchOp::getResAttrs() {
  auto attr = getResAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void KernelLaunchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs) {
  odsState.addOperands(grid_x);
  odsState.addOperands(grid_y);
  odsState.addOperands(grid_z);
  odsState.addOperands(block_x);
  odsState.addOperands(block_y);
  odsState.addOperands(block_z);
  if (bytes)
    odsState.addOperands(bytes);
  if (stream)
    odsState.addOperands(stream);
  odsState.addOperands(args);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, 1, 1, 1, (bytes ? 1 : 0), (stream ? 1 : 0), static_cast<int32_t>(args.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().callee = callee;
  if (arg_attrs) {
    odsState.getOrAddProperties<Properties>().arg_attrs = arg_attrs;
  }
  if (res_attrs) {
    odsState.getOrAddProperties<Properties>().res_attrs = res_attrs;
  }
}

KernelLaunchOp KernelLaunchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, callee, grid_x, grid_y, grid_z, block_x, block_y, block_z, bytes, stream, args, arg_attrs, res_attrs);
  auto __res__ = ::llvm::dyn_cast<KernelLaunchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelLaunchOp KernelLaunchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs) {
  return create(builder, builder.getLoc(), callee, grid_x, grid_y, grid_z, block_x, block_y, block_z, bytes, stream, args, arg_attrs, res_attrs);
}

void KernelLaunchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs) {
  odsState.addOperands(grid_x);
  odsState.addOperands(grid_y);
  odsState.addOperands(grid_z);
  odsState.addOperands(block_x);
  odsState.addOperands(block_y);
  odsState.addOperands(block_z);
  if (bytes)
    odsState.addOperands(bytes);
  if (stream)
    odsState.addOperands(stream);
  odsState.addOperands(args);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, 1, 1, 1, (bytes ? 1 : 0), (stream ? 1 : 0), static_cast<int32_t>(args.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().callee = callee;
  if (arg_attrs) {
    odsState.getOrAddProperties<Properties>().arg_attrs = arg_attrs;
  }
  if (res_attrs) {
    odsState.getOrAddProperties<Properties>().res_attrs = res_attrs;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

KernelLaunchOp KernelLaunchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, callee, grid_x, grid_y, grid_z, block_x, block_y, block_z, bytes, stream, args, arg_attrs, res_attrs);
  auto __res__ = ::llvm::dyn_cast<KernelLaunchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelLaunchOp KernelLaunchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr callee, ::mlir::Value grid_x, ::mlir::Value grid_y, ::mlir::Value grid_z, ::mlir::Value block_x, ::mlir::Value block_y, ::mlir::Value block_z, /*optional*/::mlir::Value bytes, /*optional*/::mlir::Value stream, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs) {
  return create(builder, builder.getLoc(), resultTypes, callee, grid_x, grid_y, grid_z, block_x, block_y, block_z, bytes, stream, args, arg_attrs, res_attrs);
}

void KernelLaunchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<KernelLaunchOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

KernelLaunchOp KernelLaunchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<KernelLaunchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelLaunchOp KernelLaunchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void KernelLaunchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

KernelLaunchOp KernelLaunchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<KernelLaunchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelLaunchOp KernelLaunchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult KernelLaunchOp::verifyInvariantsImpl() {
  auto tblgen_arg_attrs = getProperties().arg_attrs; (void)tblgen_arg_attrs;
  auto tblgen_callee = getProperties().callee; (void)tblgen_callee;
  if (!tblgen_callee) return emitOpError("requires attribute 'callee'");
  auto tblgen_res_attrs = getProperties().res_attrs; (void)tblgen_res_attrs;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(*this, tblgen_callee, "callee")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps7(*this, tblgen_arg_attrs, "arg_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps7(*this, tblgen_res_attrs, "res_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    if (valueGroup6.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup6.size();
    }

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup7 = getODSOperands(7);

    if (valueGroup7.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup7.size();
    }

    for (auto v : valueGroup7) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup8 = getODSOperands(8);

    for (auto v : valueGroup8) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult KernelLaunchOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult KernelLaunchOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr calleeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand grid_xRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> grid_xOperands(&grid_xRawOperand, 1);  ::llvm::SMLoc grid_xOperandsLoc;
  (void)grid_xOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand grid_yRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> grid_yOperands(&grid_yRawOperand, 1);  ::llvm::SMLoc grid_yOperandsLoc;
  (void)grid_yOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand grid_zRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> grid_zOperands(&grid_zRawOperand, 1);  ::llvm::SMLoc grid_zOperandsLoc;
  (void)grid_zOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand block_xRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> block_xOperands(&block_xRawOperand, 1);  ::llvm::SMLoc block_xOperandsLoc;
  (void)block_xOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand block_yRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> block_yOperands(&block_yRawOperand, 1);  ::llvm::SMLoc block_yOperandsLoc;
  (void)block_yOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand block_zRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> block_zOperands(&block_zRawOperand, 1);  ::llvm::SMLoc block_zOperandsLoc;
  (void)block_zOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> bytesOperands;
  ::llvm::SMLoc bytesOperandsLoc;
  (void)bytesOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> streamOperands;
  ::llvm::SMLoc streamOperandsLoc;
  (void)streamOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> streamTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> argsOperands;
  ::llvm::SMLoc argsOperandsLoc;
  (void)argsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> argsTypes;

  if (parser.parseCustomAttributeWithFallback(calleeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (calleeAttr) result.getOrAddProperties<KernelLaunchOp::Properties>().callee = calleeAttr;
  if (parser.parseLess())
    return ::mlir::failure();
  if (parser.parseLess())
    return ::mlir::failure();
  if (parser.parseLess())
    return ::mlir::failure();

  grid_xOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(grid_xRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  grid_yOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(grid_yRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  grid_zOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(grid_zRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  block_xOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(block_xRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  block_yOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(block_yRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  block_zOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(block_zRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    bytesOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      bytesOperands.push_back(operand);
    }
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    streamOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      streamOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      streamTypes.push_back(optionalType);
    }
  }
  }
  }
  if (parser.parseGreater())
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  argsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(argsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalColon())) {
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(argsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, 1, 1, 1, static_cast<int32_t>(bytesOperands.size()), static_cast<int32_t>(streamOperands.size()), static_cast<int32_t>(argsOperands.size())}), result.getOrAddProperties<KernelLaunchOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(32);
  if (parser.resolveOperands(grid_xOperands, odsBuildableType0, grid_xOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(grid_yOperands, odsBuildableType0, grid_yOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(grid_zOperands, odsBuildableType0, grid_zOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(block_xOperands, odsBuildableType0, block_xOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(block_yOperands, odsBuildableType0, block_yOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(block_zOperands, odsBuildableType0, block_zOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(bytesOperands, odsBuildableType0, bytesOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(streamOperands, streamTypes, streamOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(argsOperands, argsTypes, argsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void KernelLaunchOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getCalleeAttr());
  _odsPrinter << "<";
  _odsPrinter << "<";
  _odsPrinter << "<";
  _odsPrinter << getGridX();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getGridY();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getGridZ();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBlockX();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBlockY();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBlockZ();
  if (getBytes()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getBytes())
      _odsPrinter << value;
    if (getStream()) {
      _odsPrinter << ",";
      _odsPrinter << ' ';
      if (::mlir::Value value = getStream())
        _odsPrinter << value;
      _odsPrinter << ' ' << ":";
      _odsPrinter << ' ';
      _odsPrinter << (getStream() ? ::llvm::ArrayRef<::mlir::Type>(getStream().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    }
  }
  _odsPrinter << ">";
  _odsPrinter << ">";
  _odsPrinter << ">";
  _odsPrinter << "(";
  _odsPrinter << getArgs();
  _odsPrinter << ")";
  if (!getArgs().empty()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ' << "(";
    _odsPrinter << getArgs().getTypes();
    _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("callee");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::KernelLaunchOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::KernelOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
KernelOpGenericAdaptorBase::KernelOpGenericAdaptorBase(KernelOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> KernelOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::std::optional<uint64_t> KernelOpGenericAdaptorBase::getN() {
  auto attr = getNAttr();
  return attr ? ::std::optional<uint64_t>(attr.getValue().getZExtValue()) : (::std::nullopt);
}

::std::optional< ::mlir::ArrayAttr > KernelOpGenericAdaptorBase::getReduceAttrs() {
  auto attr = getReduceAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
KernelOpAdaptor::KernelOpAdaptor(KernelOp op) : KernelOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult KernelOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_n = getProperties().n; (void)tblgen_n;
  auto tblgen_reduceAttrs = getProperties().reduceAttrs; (void)tblgen_reduceAttrs;

  if (tblgen_n && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_n))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_n).getType().isSignlessInteger(64)))))
    return emitError(loc, "'cuf.kernel' op ""attribute 'n' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_reduceAttrs && !((::llvm::isa<::mlir::ArrayAttr>(tblgen_reduceAttrs))))
    return emitError(loc, "'cuf.kernel' op ""attribute 'reduceAttrs' failed to satisfy constraint: array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> KernelOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange KernelOp::getGridMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelOp::getBlockMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelOp::getStreamMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelOp::getLowerboundMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelOp::getUpperboundMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelOp::getStepMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelOp::getReduceOperandsMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult KernelOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.n;
       auto attr = dict.get("n");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `n` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.reduceAttrs;
       auto attr = dict.get("reduceAttrs");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `reduceAttrs` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute KernelOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.n;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("n",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.reduceAttrs;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("reduceAttrs",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code KernelOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.n.getAsOpaquePointer()), 
    llvm::hash_value(prop.reduceAttrs.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> KernelOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "n")
      return prop.n;

    if (name == "reduceAttrs")
      return prop.reduceAttrs;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void KernelOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "n") {
       prop.n = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.n)>>(value);
       return;
    }

    if (name == "reduceAttrs") {
       prop.reduceAttrs = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.reduceAttrs)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void KernelOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.n) attrs.append("n", prop.n);

    if (prop.reduceAttrs) attrs.append("reduceAttrs", prop.reduceAttrs);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult KernelOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps8(attr, "n", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getReduceAttrsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps9(attr, "reduceAttrs", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult KernelOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.n)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.reduceAttrs)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void KernelOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.n);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.reduceAttrs);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::std::optional<uint64_t> KernelOp::getN() {
  auto attr = getNAttr();
  return attr ? ::std::optional<uint64_t>(attr.getValue().getZExtValue()) : (::std::nullopt);
}

::std::optional< ::mlir::ArrayAttr > KernelOp::getReduceAttrs() {
  auto attr = getReduceAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void KernelOp::setN(::std::optional<uint64_t> attrValue) {
    auto &odsProp = getProperties().n;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), *attrValue);
    else
      odsProp = nullptr;
}

void KernelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs) {
  odsState.addOperands(grid);
  odsState.addOperands(block);
  if (stream)
    odsState.addOperands(stream);
  odsState.addOperands(lowerbound);
  odsState.addOperands(upperbound);
  odsState.addOperands(step);
  odsState.addOperands(reduceOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(grid.size()), static_cast<int32_t>(block.size()), (stream ? 1 : 0), static_cast<int32_t>(lowerbound.size()), static_cast<int32_t>(upperbound.size()), static_cast<int32_t>(step.size()), static_cast<int32_t>(reduceOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (n) {
    odsState.getOrAddProperties<Properties>().n = n;
  }
  if (reduceAttrs) {
    odsState.getOrAddProperties<Properties>().reduceAttrs = reduceAttrs;
  }
  (void)odsState.addRegion();
}

KernelOp KernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, grid, block, stream, lowerbound, upperbound, step, n, reduceOperands, reduceAttrs);
  auto __res__ = ::llvm::dyn_cast<KernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelOp KernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs) {
  return create(builder, builder.getLoc(), grid, block, stream, lowerbound, upperbound, step, n, reduceOperands, reduceAttrs);
}

void KernelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs) {
  odsState.addOperands(grid);
  odsState.addOperands(block);
  if (stream)
    odsState.addOperands(stream);
  odsState.addOperands(lowerbound);
  odsState.addOperands(upperbound);
  odsState.addOperands(step);
  odsState.addOperands(reduceOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(grid.size()), static_cast<int32_t>(block.size()), (stream ? 1 : 0), static_cast<int32_t>(lowerbound.size()), static_cast<int32_t>(upperbound.size()), static_cast<int32_t>(step.size()), static_cast<int32_t>(reduceOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (n) {
    odsState.getOrAddProperties<Properties>().n = n;
  }
  if (reduceAttrs) {
    odsState.getOrAddProperties<Properties>().reduceAttrs = reduceAttrs;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

KernelOp KernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, grid, block, stream, lowerbound, upperbound, step, n, reduceOperands, reduceAttrs);
  auto __res__ = ::llvm::dyn_cast<KernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelOp KernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange grid, ::mlir::ValueRange block, /*optional*/::mlir::Value stream, ::mlir::ValueRange lowerbound, ::mlir::ValueRange upperbound, ::mlir::ValueRange step, /*optional*/::mlir::IntegerAttr n, ::mlir::ValueRange reduceOperands, /*optional*/::mlir::ArrayAttr reduceAttrs) {
  return create(builder, builder.getLoc(), resultTypes, grid, block, stream, lowerbound, upperbound, step, n, reduceOperands, reduceAttrs);
}

void KernelOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<KernelOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

KernelOp KernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<KernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelOp KernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void KernelOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

KernelOp KernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<KernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KernelOp KernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult KernelOp::verifyInvariantsImpl() {
  auto tblgen_n = getProperties().n; (void)tblgen_n;
  auto tblgen_reduceAttrs = getProperties().reduceAttrs; (void)tblgen_reduceAttrs;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps8(*this, tblgen_n, "n")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps9(*this, tblgen_reduceAttrs, "reduceAttrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_CUFOps1(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::llvm::LogicalResult KernelOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult KernelOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> gridOperands;
  ::llvm::SMLoc gridOperandsLoc;
  (void)gridOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> gridTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> blockOperands;
  ::llvm::SMLoc blockOperandsLoc;
  (void)blockOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> blockTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> streamOperands;
  ::llvm::SMLoc streamOperandsLoc;
  (void)streamOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> streamTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> reduceOperandsOperands;
  ::llvm::SMLoc reduceOperandsOperandsLoc;
  (void)reduceOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> reduceOperandsTypes;
  ::mlir::ArrayAttr reduceAttrsAttr;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> lowerboundOperands;
  ::llvm::SMLoc lowerboundOperandsLoc;
  (void)lowerboundOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> lowerboundTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> upperboundOperands;
  ::llvm::SMLoc upperboundOperandsLoc;
  (void)upperboundOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> upperboundTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> stepOperands;
  ::llvm::SMLoc stepOperandsLoc;
  (void)stepOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> stepTypes;
  if (parser.parseLess())
    return ::mlir::failure();
  if (parser.parseLess())
    return ::mlir::failure();
  if (parser.parseLess())
    return ::mlir::failure();
  {
    gridOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseCUFKernelValues(parser, gridOperands, gridTypes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseComma())
    return ::mlir::failure();
  {
    blockOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseCUFKernelValues(parser, blockOperands, blockTypes);
    if (odsResult) return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {
  if (parser.parseKeyword("stream"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  {
    streamOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      streamOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      streamTypes.push_back(optionalType);
    }
  }
  }
  if (parser.parseGreater())
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("reduce"))) {
  if (parser.parseLParen())
    return ::mlir::failure();

  reduceOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(reduceOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(reduceOperandsTypes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(reduceAttrsAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (reduceAttrsAttr) result.getOrAddProperties<KernelOp::Properties>().reduceAttrs = reduceAttrsAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  {
    lowerboundOperandsLoc = parser.getCurrentLocation();
    upperboundOperandsLoc = parser.getCurrentLocation();
    stepOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseCUFKernelLoopControl(parser, *regionRegion, lowerboundOperands, lowerboundTypes, upperboundOperands, upperboundTypes, stepOperands, stepTypes);
    if (odsResult) return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(gridOperands.size()), static_cast<int32_t>(blockOperands.size()), static_cast<int32_t>(streamOperands.size()), static_cast<int32_t>(lowerboundOperands.size()), static_cast<int32_t>(upperboundOperands.size()), static_cast<int32_t>(stepOperands.size()), static_cast<int32_t>(reduceOperandsOperands.size())}), result.getOrAddProperties<KernelOp::Properties>().operandSegmentSizes.begin());
  if (parser.resolveOperands(gridOperands, gridTypes, gridOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(blockOperands, blockTypes, blockOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(streamOperands, streamTypes, streamOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(lowerboundOperands, lowerboundTypes, lowerboundOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(upperboundOperands, upperboundTypes, upperboundOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(stepOperands, stepTypes, stepOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(reduceOperandsOperands, reduceOperandsTypes, reduceOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void KernelOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "<";
  _odsPrinter << "<";
  _odsPrinter << "<";
  printCUFKernelValues(_odsPrinter, *this, getGrid(), getGrid().getTypes());
  _odsPrinter << ",";
  _odsPrinter << ' ';
  printCUFKernelValues(_odsPrinter, *this, getBlock(), getBlock().getTypes());
  if (getStream()) {
    _odsPrinter << ",";
    _odsPrinter << ' ' << "stream";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    if (::mlir::Value value = getStream())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getStream() ? ::llvm::ArrayRef<::mlir::Type>(getStream().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  }
  _odsPrinter << ">";
  _odsPrinter << ">";
  _odsPrinter << ">";
  if (!getReduceOperands().empty()) {
    _odsPrinter << ' ' << "reduce";
    _odsPrinter << "(";
    _odsPrinter << getReduceOperands();
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getReduceOperands().getTypes();
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter.printAttributeWithoutType(getReduceAttrsAttr());
    _odsPrinter << ")";
  }
  _odsPrinter << ' ';
  printCUFKernelLoopControl(_odsPrinter, *this, getRegion(), getLowerbound(), getLowerbound().getTypes(), getUpperbound(), getUpperbound().getTypes(), getStep(), getStep().getTypes());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("reduceAttrs");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::KernelOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::RegisterKernelOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
RegisterKernelOpGenericAdaptorBase::RegisterKernelOpGenericAdaptorBase(RegisterKernelOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::SymbolRefAttr RegisterKernelOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr;
}

} // namespace detail
RegisterKernelOpAdaptor::RegisterKernelOpAdaptor(RegisterKernelOp op) : RegisterKernelOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult RegisterKernelOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitError(loc, "'cuf.register_kernel' op ""requires attribute 'name'");

  if (tblgen_name && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_name))))
    return emitError(loc, "'cuf.register_kernel' op ""attribute 'name' failed to satisfy constraint: symbol reference attribute");
  return ::mlir::success();
}

::llvm::LogicalResult RegisterKernelOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute RegisterKernelOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code RegisterKernelOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.name.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> RegisterKernelOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "name")
      return prop.name;
  return std::nullopt;
}

void RegisterKernelOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }
}

void RegisterKernelOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.name) attrs.append("name", prop.name);
}

::llvm::LogicalResult RegisterKernelOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(attr, "name", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult RegisterKernelOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.name)))
    return ::mlir::failure();
  return ::mlir::success();
}

void RegisterKernelOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.name);
}

::mlir::SymbolRefAttr RegisterKernelOp::getName() {
  auto attr = getNameAttr();
  return attr;
}

void RegisterKernelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr) {
  odsState.addOperands(modulePtr);
  odsState.getOrAddProperties<Properties>().name = name;
}

RegisterKernelOp RegisterKernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, name, modulePtr);
  auto __res__ = ::llvm::dyn_cast<RegisterKernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterKernelOp RegisterKernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr) {
  return create(builder, builder.getLoc(), name, modulePtr);
}

void RegisterKernelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr) {
  odsState.addOperands(modulePtr);
  odsState.getOrAddProperties<Properties>().name = name;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

RegisterKernelOp RegisterKernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, name, modulePtr);
  auto __res__ = ::llvm::dyn_cast<RegisterKernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterKernelOp RegisterKernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name, ::mlir::Value modulePtr) {
  return create(builder, builder.getLoc(), resultTypes, name, modulePtr);
}

void RegisterKernelOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<RegisterKernelOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

RegisterKernelOp RegisterKernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<RegisterKernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterKernelOp RegisterKernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void RegisterKernelOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

RegisterKernelOp RegisterKernelOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<RegisterKernelOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterKernelOp RegisterKernelOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult RegisterKernelOp::verifyInvariantsImpl() {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitOpError("requires attribute 'name'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps12(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult RegisterKernelOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult RegisterKernelOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr nameAttr;
  ::mlir::OpAsmParser::UnresolvedOperand modulePtrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> modulePtrOperands(&modulePtrRawOperand, 1);  ::llvm::SMLoc modulePtrOperandsLoc;
  (void)modulePtrOperandsLoc;
  ::mlir::Type modulePtrRawType{};
  ::llvm::ArrayRef<::mlir::Type> modulePtrTypes(&modulePtrRawType, 1);

  if (parser.parseCustomAttributeWithFallback(nameAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (nameAttr) result.getOrAddProperties<RegisterKernelOp::Properties>().name = nameAttr;
  if (parser.parseLParen())
    return ::mlir::failure();

  modulePtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(modulePtrRawOperand))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::LLVM::LLVMPointerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    modulePtrRawType = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.resolveOperands(modulePtrOperands, modulePtrTypes, modulePtrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void RegisterKernelOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getNameAttr());
  _odsPrinter << "(";
  _odsPrinter << getModulePtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getModulePtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::LLVM::LLVMPointerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("name");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::RegisterKernelOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::RegisterModuleOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
RegisterModuleOpGenericAdaptorBase::RegisterModuleOpGenericAdaptorBase(RegisterModuleOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::SymbolRefAttr RegisterModuleOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr;
}

} // namespace detail
RegisterModuleOpAdaptor::RegisterModuleOpAdaptor(RegisterModuleOp op) : RegisterModuleOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult RegisterModuleOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitError(loc, "'cuf.register_module' op ""requires attribute 'name'");

  if (tblgen_name && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_name))))
    return emitError(loc, "'cuf.register_module' op ""attribute 'name' failed to satisfy constraint: symbol reference attribute");
  return ::mlir::success();
}

::llvm::LogicalResult RegisterModuleOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute RegisterModuleOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code RegisterModuleOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.name.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> RegisterModuleOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "name")
      return prop.name;
  return std::nullopt;
}

void RegisterModuleOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }
}

void RegisterModuleOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.name) attrs.append("name", prop.name);
}

::llvm::LogicalResult RegisterModuleOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(attr, "name", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult RegisterModuleOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.name)))
    return ::mlir::failure();
  return ::mlir::success();
}

void RegisterModuleOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.name);
}

::mlir::SymbolRefAttr RegisterModuleOp::getName() {
  auto attr = getNameAttr();
  return attr;
}

void RegisterModuleOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type modulePtr, ::mlir::SymbolRefAttr name) {
  odsState.getOrAddProperties<Properties>().name = name;
  odsState.addTypes(modulePtr);
}

RegisterModuleOp RegisterModuleOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type modulePtr, ::mlir::SymbolRefAttr name) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, modulePtr, name);
  auto __res__ = ::llvm::dyn_cast<RegisterModuleOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterModuleOp RegisterModuleOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type modulePtr, ::mlir::SymbolRefAttr name) {
  return create(builder, builder.getLoc(), modulePtr, name);
}

void RegisterModuleOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name) {
  odsState.getOrAddProperties<Properties>().name = name;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

RegisterModuleOp RegisterModuleOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, name);
  auto __res__ = ::llvm::dyn_cast<RegisterModuleOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterModuleOp RegisterModuleOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr name) {
  return create(builder, builder.getLoc(), resultTypes, name);
}

void RegisterModuleOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<RegisterModuleOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

RegisterModuleOp RegisterModuleOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<RegisterModuleOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterModuleOp RegisterModuleOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void RegisterModuleOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

RegisterModuleOp RegisterModuleOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<RegisterModuleOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RegisterModuleOp RegisterModuleOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult RegisterModuleOp::verifyInvariantsImpl() {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitOpError("requires attribute 'name'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps12(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult RegisterModuleOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult RegisterModuleOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr nameAttr;
  ::mlir::Type modulePtrRawType{};
  ::llvm::ArrayRef<::mlir::Type> modulePtrTypes(&modulePtrRawType, 1);

  if (parser.parseCustomAttributeWithFallback(nameAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (nameAttr) result.getOrAddProperties<RegisterModuleOp::Properties>().name = nameAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::LLVM::LLVMPointerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    modulePtrRawType = type;
  }
  result.addTypes(modulePtrTypes);
  return ::mlir::success();
}

void RegisterModuleOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getNameAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("name");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getModulePtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::LLVM::LLVMPointerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::RegisterModuleOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::SharedMemoryOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SharedMemoryOpGenericAdaptorBase::SharedMemoryOpGenericAdaptorBase(SharedMemoryOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> SharedMemoryOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Type SharedMemoryOpGenericAdaptorBase::getInType() {
  auto attr = getInTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::std::optional< ::llvm::StringRef > SharedMemoryOpGenericAdaptorBase::getUniqName() {
  auto attr = getUniqNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::std::optional< ::llvm::StringRef > SharedMemoryOpGenericAdaptorBase::getBindcName() {
  auto attr = getBindcNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
SharedMemoryOpAdaptor::SharedMemoryOpAdaptor(SharedMemoryOp op) : SharedMemoryOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SharedMemoryOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_bindc_name = getProperties().bindc_name; (void)tblgen_bindc_name;
  auto tblgen_in_type = getProperties().in_type; (void)tblgen_in_type;
  if (!tblgen_in_type) return emitError(loc, "'cuf.shared_memory' op ""requires attribute 'in_type'");
  auto tblgen_uniq_name = getProperties().uniq_name; (void)tblgen_uniq_name;

  if (tblgen_in_type && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_in_type))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_in_type).getValue()))) && ((true))))
    return emitError(loc, "'cuf.shared_memory' op ""attribute 'in_type' failed to satisfy constraint: any type attribute");

  if (tblgen_uniq_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_uniq_name))))
    return emitError(loc, "'cuf.shared_memory' op ""attribute 'uniq_name' failed to satisfy constraint: string attribute");

  if (tblgen_bindc_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_bindc_name))))
    return emitError(loc, "'cuf.shared_memory' op ""attribute 'bindc_name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SharedMemoryOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange SharedMemoryOp::getTypeparamsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SharedMemoryOp::getShapeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SharedMemoryOp::getOffsetMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult SharedMemoryOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.bindc_name;
       auto attr = dict.get("bindc_name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `bindc_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.in_type;
       auto attr = dict.get("in_type");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `in_type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.uniq_name;
       auto attr = dict.get("uniq_name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `uniq_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute SharedMemoryOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.bindc_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("bindc_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.in_type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("in_type",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.uniq_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("uniq_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SharedMemoryOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.bindc_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.in_type.getAsOpaquePointer()), 
    llvm::hash_value(prop.uniq_name.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> SharedMemoryOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "bindc_name")
      return prop.bindc_name;

    if (name == "in_type")
      return prop.in_type;

    if (name == "uniq_name")
      return prop.uniq_name;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void SharedMemoryOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "bindc_name") {
       prop.bindc_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.bindc_name)>>(value);
       return;
    }

    if (name == "in_type") {
       prop.in_type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.in_type)>>(value);
       return;
    }

    if (name == "uniq_name") {
       prop.uniq_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.uniq_name)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void SharedMemoryOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.bindc_name) attrs.append("bindc_name", prop.bindc_name);

    if (prop.in_type) attrs.append("in_type", prop.in_type);

    if (prop.uniq_name) attrs.append("uniq_name", prop.uniq_name);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult SharedMemoryOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getBindcNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(attr, "bindc_name", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getInTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps1(attr, "in_type", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getUniqNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(attr, "uniq_name", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SharedMemoryOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.bindc_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.in_type)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.uniq_name)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void SharedMemoryOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.bindc_name);
  writer.writeAttribute(prop.in_type);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.uniq_name);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::Type SharedMemoryOp::getInType() {
  auto attr = getInTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::std::optional< ::llvm::StringRef > SharedMemoryOp::getUniqName() {
  auto attr = getUniqNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::std::optional< ::llvm::StringRef > SharedMemoryOp::getBindcName() {
  auto attr = getBindcNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void SharedMemoryOp::setInType(::mlir::Type attrValue) {
  getProperties().in_type = ::mlir::TypeAttr::get(attrValue);
}

void SharedMemoryOp::setUniqName(::std::optional<::llvm::StringRef> attrValue) {
    auto &odsProp = getProperties().uniq_name;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SharedMemoryOp::setBindcName(::std::optional<::llvm::StringRef> attrValue) {
    auto &odsProp = getProperties().bindc_name;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue);
    else
      odsProp = nullptr;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams, mlir::ValueRange shape, llvm::ArrayRef<mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, inType, uniqName, bindcName, typeparams, shape, attributes);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams, mlir::ValueRange shape, llvm::ArrayRef<mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), inType, uniqName, bindcName, typeparams, shape, attributes);
}

void SharedMemoryOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  if (offset)
    odsState.addOperands(offset);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size()), (offset ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = in_type;
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  odsState.addTypes(ptr);
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, in_type, uniq_name, bindc_name, typeparams, shape, offset);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  return create(builder, builder.getLoc(), ptr, in_type, uniq_name, bindc_name, typeparams, shape, offset);
}

void SharedMemoryOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  if (offset)
    odsState.addOperands(offset);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size()), (offset ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = in_type;
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, offset);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  return create(builder, builder.getLoc(), resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, offset);
}

void SharedMemoryOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  if (offset)
    odsState.addOperands(offset);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size()), (offset ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = ::mlir::TypeAttr::get(in_type);
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  odsState.addTypes(ptr);
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, ptr, in_type, uniq_name, bindc_name, typeparams, shape, offset);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type ptr, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  return create(builder, builder.getLoc(), ptr, in_type, uniq_name, bindc_name, typeparams, shape, offset);
}

void SharedMemoryOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  odsState.addOperands(typeparams);
  odsState.addOperands(shape);
  if (offset)
    odsState.addOperands(offset);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparams.size()), static_cast<int32_t>(shape.size()), (offset ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().in_type = ::mlir::TypeAttr::get(in_type);
  if (uniq_name) {
    odsState.getOrAddProperties<Properties>().uniq_name = uniq_name;
  }
  if (bindc_name) {
    odsState.getOrAddProperties<Properties>().bindc_name = bindc_name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, offset);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape, /*optional*/::mlir::Value offset) {
  return create(builder, builder.getLoc(), resultTypes, in_type, uniq_name, bindc_name, typeparams, shape, offset);
}

void SharedMemoryOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SharedMemoryOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SharedMemoryOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SharedMemoryOp SharedMemoryOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SharedMemoryOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SharedMemoryOp SharedMemoryOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SharedMemoryOp::verifyInvariantsImpl() {
  auto tblgen_bindc_name = getProperties().bindc_name; (void)tblgen_bindc_name;
  auto tblgen_in_type = getProperties().in_type; (void)tblgen_in_type;
  if (!tblgen_in_type) return emitOpError("requires attribute 'in_type'");
  auto tblgen_uniq_name = getProperties().uniq_name; (void)tblgen_uniq_name;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps1(*this, tblgen_in_type, "in_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(*this, tblgen_uniq_name, "uniq_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps2(*this, tblgen_bindc_name, "bindc_name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SharedMemoryOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SharedMemoryOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> offsetOperands;
  ::llvm::SMLoc offsetOperandsLoc;
  (void)offsetOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> offsetTypes;
  ::mlir::TypeAttr in_typeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> typeparamsOperands;
  ::llvm::SMLoc typeparamsOperandsLoc;
  (void)typeparamsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> typeparamsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> shapeTypes;
  ::mlir::Type ptrRawType{};
  ::llvm::ArrayRef<::mlir::Type> ptrTypes(&ptrRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  {
    offsetOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      offsetOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      offsetTypes.push_back(optionalType);
    }
  }
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseCustomAttributeWithFallback(in_typeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (in_typeAttr) result.getOrAddProperties<SharedMemoryOp::Properties>().in_type = in_typeAttr;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  typeparamsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(typeparamsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(typeparamsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  shapeOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shapeOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(shapeTypes))
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(ptrRawType))
    return ::mlir::failure();
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(typeparamsOperands.size()), static_cast<int32_t>(shapeOperands.size()), static_cast<int32_t>(offsetOperands.size())}), result.getOrAddProperties<SharedMemoryOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(ptrTypes);
  if (parser.resolveOperands(typeparamsOperands, typeparamsTypes, typeparamsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(shapeOperands, shapeTypes, shapeOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(offsetOperands, offsetTypes, offsetOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SharedMemoryOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getOffset()) {
    _odsPrinter << "[";
    if (::mlir::Value value = getOffset())
      _odsPrinter << value;
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getOffset() ? ::llvm::ArrayRef<::mlir::Type>(getOffset().getType()) : ::llvm::ArrayRef<::mlir::Type>());
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getInTypeAttr());
  if (!getTypeparams().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getTypeparams();
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getTypeparams().getTypes();
    _odsPrinter << ")";
  }
  if (!getShape().empty()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << getShape();
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getShape().getTypes();
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("in_type");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getPtr().getType();
}

void SharedMemoryOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::SharedMemoryOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::StreamCastOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StreamCastOpGenericAdaptorBase::StreamCastOpGenericAdaptorBase(StreamCastOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
StreamCastOpAdaptor::StreamCastOpAdaptor(StreamCastOp op) : StreamCastOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult StreamCastOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult StreamCastOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute StreamCastOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code StreamCastOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> StreamCastOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void StreamCastOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void StreamCastOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult StreamCastOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void StreamCastOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type token, ::mlir::Value stream) {
  odsState.addOperands(stream);
  odsState.addTypes(token);
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type token, ::mlir::Value stream) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, stream);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type token, ::mlir::Value stream) {
  return create(builder, builder.getLoc(), token, stream);
}

void StreamCastOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value stream) {
  odsState.addOperands(stream);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(StreamCastOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::mlir::detail::reportFatalInferReturnTypesError(odsState);
        
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value stream) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, stream);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value stream) {
  return create(builder, builder.getLoc(), stream);
}

void StreamCastOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value stream) {
  odsState.addOperands(stream);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value stream) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, stream);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value stream) {
  return create(builder, builder.getLoc(), resultTypes, stream);
}

void StreamCastOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void StreamCastOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(StreamCastOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), operands, attributes);
}

void StreamCastOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void StreamCastOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties &>(properties));
  odsState.addAttributes(discardableAttributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(StreamCastOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

StreamCastOp StreamCastOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<StreamCastOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

StreamCastOp StreamCastOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), operands, properties, discardableAttributes);
}

::llvm::LogicalResult StreamCastOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps13(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CUFOps14(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult StreamCastOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::llvm::LogicalResult StreamCastOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = mlir::gpu::AsyncTokenType::get(odsBuilder.getContext());
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult StreamCastOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand streamRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> streamOperands(&streamRawOperand, 1);  ::llvm::SMLoc streamOperandsLoc;
  (void)streamOperandsLoc;
  ::mlir::Type streamRawType{};
  ::llvm::ArrayRef<::mlir::Type> streamTypes(&streamRawType, 1);

  streamOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(streamRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    streamRawType = type;
  }
  ::mlir::Type odsBuildableType0 = mlir::gpu::AsyncTokenType::get(parser.getBuilder().getContext());
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(streamOperands, streamTypes, streamOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StreamCastOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getStream();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getStream().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void StreamCastOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::StreamCastOp)

namespace cuf {

//===----------------------------------------------------------------------===//
// ::cuf::SyncDescriptorOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SyncDescriptorOpGenericAdaptorBase::SyncDescriptorOpGenericAdaptorBase(SyncDescriptorOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::SymbolRefAttr SyncDescriptorOpGenericAdaptorBase::getGlobalName() {
  auto attr = getGlobalNameAttr();
  return attr;
}

} // namespace detail
SyncDescriptorOpAdaptor::SyncDescriptorOpAdaptor(SyncDescriptorOp op) : SyncDescriptorOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SyncDescriptorOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_globalName = getProperties().globalName; (void)tblgen_globalName;
  if (!tblgen_globalName) return emitError(loc, "'cuf.sync_descriptor' op ""requires attribute 'globalName'");

  if (tblgen_globalName && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_globalName))))
    return emitError(loc, "'cuf.sync_descriptor' op ""attribute 'globalName' failed to satisfy constraint: symbol reference attribute");
  return ::mlir::success();
}

::llvm::LogicalResult SyncDescriptorOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.globalName;
       auto attr = dict.get("globalName");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `globalName` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute SyncDescriptorOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.globalName;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("globalName",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SyncDescriptorOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.globalName.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> SyncDescriptorOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "globalName")
      return prop.globalName;
  return std::nullopt;
}

void SyncDescriptorOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "globalName") {
       prop.globalName = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.globalName)>>(value);
       return;
    }
}

void SyncDescriptorOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.globalName) attrs.append("globalName", prop.globalName);
}

::llvm::LogicalResult SyncDescriptorOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getGlobalNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(attr, "globalName", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SyncDescriptorOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.globalName)))
    return ::mlir::failure();
  return ::mlir::success();
}

void SyncDescriptorOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.globalName);
}

::mlir::SymbolRefAttr SyncDescriptorOp::getGlobalName() {
  auto attr = getGlobalNameAttr();
  return attr;
}

void SyncDescriptorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::SymbolRefAttr globalName) {
  odsState.getOrAddProperties<Properties>().globalName = globalName;
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::SymbolRefAttr globalName) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, globalName);
  auto __res__ = ::llvm::dyn_cast<SyncDescriptorOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::SymbolRefAttr globalName) {
  return create(builder, builder.getLoc(), globalName);
}

void SyncDescriptorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr globalName) {
  odsState.getOrAddProperties<Properties>().globalName = globalName;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr globalName) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, globalName);
  auto __res__ = ::llvm::dyn_cast<SyncDescriptorOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr globalName) {
  return create(builder, builder.getLoc(), resultTypes, globalName);
}

void SyncDescriptorOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SyncDescriptorOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SyncDescriptorOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SyncDescriptorOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SyncDescriptorOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SyncDescriptorOp SyncDescriptorOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SyncDescriptorOp::verifyInvariantsImpl() {
  auto tblgen_globalName = getProperties().globalName; (void)tblgen_globalName;
  if (!tblgen_globalName) return emitOpError("requires attribute 'globalName'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_CUFOps6(*this, tblgen_globalName, "globalName")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult SyncDescriptorOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SyncDescriptorOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr globalNameAttr;

  if (parser.parseCustomAttributeWithFallback(globalNameAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (globalNameAttr) result.getOrAddProperties<SyncDescriptorOp::Properties>().globalName = globalNameAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void SyncDescriptorOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getGlobalNameAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("globalName");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace cuf
MLIR_DEFINE_EXPLICIT_TYPE_ID(::cuf::SyncDescriptorOp)


#endif // GET_OP_CLASSES

