# Copyright © Advanced Micro Devices, Inc., or its affiliates.
# SPDX-License-Identifier:  MIT


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was hipdnn_sdkConfig_imported.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

find_dependency(flatbuffers REQUIRED)
find_dependency(spdlog REQUIRED)
find_dependency(nlohmann_json REQUIRED)

# Subdirectory path for hipDNN engine plugins (relative to lib)
set(HIPDNN_PLUGIN_ENGINE_SUBDIR "hipdnn_plugins/engines")

# Install path for engine plugins
set(HIPDNN_FULL_INSTALL_PLUGIN_ENGINE_DIR "/therock/output/build/ml-libs/hipDNN/stage/lib/hipdnn_plugins/engines")
set(HIPDNN_RELATIVE_INSTALL_PLUGIN_ENGINE_DIR "lib/hipdnn_plugins/engines")

include("${CMAKE_CURRENT_LIST_DIR}/hipdnn_sdkTargets.cmake")

message(STATUS "hipDNN SDK: Engine plugin build directory is ${CMAKE_INSTALL_LIBDIR}/${HIPDNN_PLUGIN_ENGINE_SUBDIR}")
message(STATUS "hipDNN SDK: Plugin absolute installation directory ${HIPDNN_FULL_INSTALL_PLUGIN_ENGINE_DIR}")
message(STATUS "hipDNN SDK: Plugin relative installation directory ${HIPDNN_RELATIVE_INSTALL_PLUGIN_ENGINE_DIR}")
